/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.util;

import java.io.StringWriter;
import java.text.DecimalFormat;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Node;

public class Miscellaneous {
    public static String domToString(Node node) throws TransformerException, TransformerFactoryConfigurationError {
        TransformerFactory transFactory = TransformerFactory.newInstance();
        StringWriter writer = new StringWriter();
        transFactory.newTransformer().transform(new DOMSource(node), new StreamResult(writer));
        String result = writer.getBuffer().toString();
        return result;
    }

    public static String domToColorHtml(Node node) throws TransformerException {
        TransformerFactory transFactory = TransformerFactory.newInstance();
        StringWriter writer = new StringWriter();
        StreamSource xsltSource = new StreamSource(Miscellaneous.class.getResourceAsStream("xml2html.xslt"));
        Transformer transformer = transFactory.newTransformer(xsltSource);
        StreamResult result = new StreamResult(System.out);
        transformer.transform(new DOMSource(node), result);
        return writer.getBuffer().toString();
    }

    public static String leftPad(String str, int length) {
        return Miscellaneous.leftPad(str, length, ' ');
    }

    public static String leftPad(String str, int length, char ch) {
        int padding = length - str.length();
        if (padding > 0) {
            char[] buf = new char[padding];
            int i = 0;
            while (i < padding) {
                buf[i] = ch;
                ++i;
            }
            return String.valueOf(new String(buf)) + str;
        }
        return str;
    }

    public static String checkForScientificNotation(Double doubleVal) {
        int decimals = 0;
        String format = "";
        String stringValue = "";
        if (doubleVal.toString().contains("E")) {
            String[] scientificPlaces = doubleVal.toString().split("E");
            int places = Integer.parseInt(scientificPlaces[1]);
            if (scientificPlaces[0].contains(".")) {
                String[] beforeE = scientificPlaces[0].split("\\.");
                places += beforeE[0].length();
                decimals = beforeE[1].length();
            }
            int i = 0;
            while (i < places) {
                format = String.valueOf(format) + "#";
                ++i;
            }
            if (decimals > places) {
                decimals -= places;
                format = String.valueOf(format) + ".";
                int d = 0;
                while (d <= decimals) {
                    format = String.valueOf(format) + "#";
                    ++d;
                }
            }
            DecimalFormat dFormat = new DecimalFormat(format);
            stringValue = dFormat.format(doubleVal);
        } else {
            stringValue = doubleVal.toString();
        }
        return stringValue;
    }
}

