/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.util;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openmetadata.dataset.Code;
import org.openmetadata.dataset.CodeList;
import org.openmetadata.dataset.DataFile;
import org.openmetadata.dataset.Variable;

public class Harmonizer {
    private DataFile dataFile;
    private LinkedHashMap<String, String> codeListIdMap = new LinkedHashMap();
    private LinkedHashMap<String, Boolean> idMap = new LinkedHashMap();
    private ArrayList<String> removals = new ArrayList();
    private Log log = LogFactory.getLog(this.getClass());

    public Harmonizer() {
    }

    public Harmonizer(DataFile dataFile) {
        this.dataFile = dataFile;
    }

    public void HarmonizeCodeLists() throws Exception {
        this.log.info((Object)"Harmonizing Codelists");
        for (Variable var : this.dataFile.getVariables()) {
            if (var.getCodeListId() == null || var.getCodeListId().isEmpty()) continue;
            CodeList codeList = this.dataFile.getCodeList(var.getCodeListId());
            LinkedHashMap codes = codeList.getCodeList();
            String codesAndCategories = "";
            for (Code code : codes.values()) {
                codesAndCategories = String.valueOf(codesAndCategories) + code.getCode();
                codesAndCategories = String.valueOf(codesAndCategories) + code.getLabel();
                codesAndCategories = String.valueOf(codesAndCategories) + code.isMissing();
            }
            MessageDigest md = null;
            try {
                md = MessageDigest.getInstance("SHA-1");
            }
            catch (NoSuchAlgorithmException e1) {
                e1.printStackTrace();
            }
            try {
                md.update(codesAndCategories.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            byte[] digest = md.digest();
            StringBuffer hexString = new StringBuffer();
            int i = 0;
            while (i < digest.length) {
                hexString.append(Integer.toHexString(0xFF & digest[i]));
                ++i;
            }
            if (this.codeListIdMap.keySet().contains(hexString.toString())) {
                this.checkPreviousHarmonization(var.getCodeListId());
                String codeListId = this.codeListIdMap.get(hexString.toString());
                this.removals.add(var.getCodeListId());
                var.setCodeListId(codeListId);
                continue;
            }
            this.checkPreviousHarmonization(var.getCodeListId());
            this.codeListIdMap.put(hexString.toString(), var.getCodeListId());
        }
        for (String removal : this.removals) {
            boolean isHarmonized = this.idMap.get(removal);
            if (isHarmonized) continue;
            this.dataFile.removeCodeList(removal);
        }
    }

    private void checkPreviousHarmonization(String codeListId) {
        boolean isHarmonized = false;
        if (this.idMap.keySet().contains(codeListId)) {
            isHarmonized = true;
            this.idMap.put(codeListId, isHarmonized);
        } else {
            this.idMap.put(codeListId, isHarmonized);
        }
    }
}

