/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.util.subsettransformer;

import java.util.ArrayList;
import java.util.List;
import org.openmetadata.dataset.DataFile;
import org.openmetadata.dataset.Filter;
import org.openmetadata.dataset.Selection;
import org.openmetadata.dataset.TransformDefinition;
import org.openmetadata.dataset.Variable;
import org.openmetadata.dataset.VariableSelection;

public class Transformer {
    private DataFile dataFile;
    private TransformDefinition transformDefinition;
    private List<Variable> variableSubset = new ArrayList<Variable>();

    public Transformer(DataFile dataFile, TransformDefinition transformDefinition) throws Exception {
        this.dataFile = dataFile;
        this.transformDefinition = transformDefinition;
        this.transform();
    }

    private boolean applyFilters(Filter filter, Variable var) throws Exception {
        boolean addVar = false;
        boolean filterApplies = false;
        if (filter.getFilters().size() > 0) {
            for (Filter subfilter : filter.getFilters()) {
                filterApplies = this.applyFilters(subfilter, var);
                addVar = filterApplies;
                if (!addVar) continue;
                return addVar;
            }
        }
        if (filter.getSelections().size() > 0) {
            int currentSelection = 1;
            for (Selection selection : filter.getSelections()) {
                if (selection instanceof VariableSelection) {
                    VariableSelection varSelection = (VariableSelection)selection;
                    filterApplies = this.analyzeVariableSelection(varSelection, var);
                    if (!filterApplies && filter.getLogic() == Filter.LOGIC.AND) {
                        addVar = filterApplies;
                        return addVar;
                    }
                    if (filterApplies && filter.getLogic() == Filter.LOGIC.AND) {
                        addVar = filterApplies;
                        if (currentSelection == filter.getSelections().size()) {
                            return addVar;
                        }
                    }
                    if (filterApplies && filter.getLogic() == Filter.LOGIC.OR) {
                        addVar = filterApplies;
                        return addVar;
                    }
                    if (filter.getLogic() == null && filterApplies) {
                        addVar = filterApplies;
                        return addVar;
                    }
                }
                ++currentSelection;
            }
        }
        return addVar;
    }

    private void applyTransformations() {
    }

    private boolean checkOperator(Object varAttr, VariableSelection.VAR_OPERATOR varOp, String value) {
        boolean addVar = false;
        switch (varOp) {
            case EQUALS: {
                if (!varAttr.toString().equalsIgnoreCase(value)) break;
                addVar = true;
                break;
            }
            case CONTAINS: {
                if (!varAttr.toString().toLowerCase().contains(value.toLowerCase())) break;
                addVar = true;
                break;
            }
            case STARTS_WITH: {
                if (!varAttr.toString().toLowerCase().startsWith(value.toLowerCase())) break;
                addVar = true;
            }
        }
        return addVar;
    }

    private boolean analyzeVariableSelection(VariableSelection varSelection, Variable var) throws Exception {
        boolean addVar = false;
        switch (varSelection.getFilterType()) {
            case ATTR: {
                addVar = this.checkVarByAttr(varSelection, var);
                break;
            }
            case INDEX: {
                addVar = this.checkVarByIndex(varSelection, var);
                break;
            }
            case CATEGORY: {
                addVar = this.checkVarByCategory(varSelection, var);
                break;
            }
        }
        return addVar;
    }

    private boolean checkVarByAttr(VariableSelection varSelection, Variable var) {
        boolean addVar = false;
        switch (varSelection.getVarAttr()) {
            case NAME: {
                addVar = this.checkOperator(var.getName(), varSelection.getVarOp(), varSelection.getValue());
                break;
            }
            case LABEL: {
                addVar = this.checkOperator(var.getLabel(), varSelection.getVarOp(), varSelection.getValue());
                break;
            }
            case FORMAT: {
                addVar = this.checkOperator(var.getFormat(), varSelection.getVarOp(), varSelection.getValue());
                break;
            }
            case ID: {
                addVar = this.checkOperator(var.getDataType(), varSelection.getVarOp(), varSelection.getValue());
            }
        }
        return addVar;
    }

    private boolean checkVarByIndex(VariableSelection varSelection, Variable var) throws Exception {
        boolean addVar = false;
        ArrayList variableList = new ArrayList(this.dataFile.getVariables().values());
        if (varSelection.getVarIndexPosition() == variableList.indexOf(var) + 1) {
            addVar = true;
        }
        return addVar;
    }

    private boolean checkVarByCategory(VariableSelection varSelection, Variable var) {
        boolean addVar = false;
        if (!var.getCodeListId().equals(null) && !var.getCodeListId().equals("")) {
            addVar = true;
        }
        return addVar;
    }

    private void transform() throws Exception {
        if (this.transformDefinition.getFilters().size() > 0) {
            for (Variable var : this.dataFile.getVariables().values()) {
                for (Filter filter : this.transformDefinition.getFilters()) {
                    boolean addVar = this.applyFilters(filter, var);
                    if (!addVar) continue;
                    this.variableSubset.add(var);
                }
            }
        }
        this.applyTransformations();
    }

    public List<Variable> getVariableSubset() {
        return this.variableSubset;
    }
}

