/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.util.ascii;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Arrays;
import org.openmetadata.dataset.DataFile;
import org.openmetadata.dataset.Variable;
import org.openmetadata.fileformat.AsciiFileFormat;
import org.openmetadata.util.ascii.AsciiExportOptions;
import org.openmetadata.util.subsettransformer.Transformer;

public class AsciiTextFormatter {
    DataFile dataFile;
    AsciiExportOptions asciiExportOptions;
    Transformer subsetTransformer;
    boolean showProgress = false;

    public AsciiTextFormatter() {
    }

    public AsciiTextFormatter(DataFile dataFile) {
        this.dataFile = dataFile;
        this.asciiExportOptions = new AsciiExportOptions(null);
    }

    public AsciiTextFormatter(DataFile dataFile, AsciiExportOptions asciiExportOptions) {
        this.dataFile = dataFile;
        this.asciiExportOptions = asciiExportOptions;
    }

    public String adjustOutput(String output, int width) throws Exception {
        switch (this.asciiExportOptions.getWidthMode()) {
            case OPTIMIZE: {
                if (output.length() <= 2 || !output.substring(output.length() - 2, output.length()).equals(".0")) break;
                output = output.substring(0, output.length() - 2);
                break;
            }
            case REPORT_ONLY: {
                if (output.length() <= width) break;
                output = "*";
                break;
            }
            case THROW_EXCEPTION: {
                if (output.length() <= width) break;
                throw new Exception("Data is larger than allowed width.");
            }
        }
        return output;
    }

    public void writeFormattedData(AsciiFileFormat asciiFormat, BufferedWriter writer, String nullValue, boolean includeVarNames) throws Exception {
        int indexVar = 0;
        ArrayList variables = new ArrayList(this.dataFile.getVariables().values());
        if (includeVarNames) {
            for (Variable var : this.dataFile.getVariables().values()) {
                writer.write(var.getName());
                if (++indexVar == this.dataFile.getVariableCount()) continue;
                writer.write(",");
            }
        }
        if (this.dataFile.getDataSource().getShowProgress()) {
            this.dataFile.getDataSource().setShowProgress(false);
            this.showProgress = true;
        }
        if (includeVarNames) {
            writer.write("\n");
        }
        long r = 0L;
        while (r < this.dataFile.getRecordCount()) {
            ArrayList dataRecord = this.dataFile.getDataSource().getRecord(Long.valueOf(r));
            int i = 0;
            while (i < dataRecord.size()) {
                Object dataValue = dataRecord.get(i);
                String result = "";
                String spaces = "";
                int remaining = 0;
                int width = ((Variable)variables.get(i)).getTextDisplayWidth();
                if (dataValue != null) {
                    result = "" + dataValue;
                }
                if (result.equals("NaN")) {
                    result = "";
                }
                switch (asciiFormat.getAsciiFormat()) {
                    case FIXED: {
                        result = this.adjustOutput(result, width);
                        if (((Variable)variables.get(i)).getDataType() == Variable.DATA_TYPE.NUMERIC) {
                            remaining = width - result.length();
                            spaces = new String(new char[remaining]).replace('\u0000', ' ');
                            result = String.valueOf(spaces) + result;
                            break;
                        }
                        char[] array = Arrays.copyOf(result.toCharArray(), width);
                        result = new String(array).replace('\u0000', ' ');
                        break;
                    }
                    case DELIMITED: {
                        if (result != null) {
                            result = this.adjustOutput(result, width);
                        }
                        result = String.valueOf(result) + "\t";
                        break;
                    }
                    case CSV: {
                        String csvStr = "";
                        if (result != null && ((csvStr = (result = this.adjustOutput(result, width))).contains(",") || csvStr.contains("\""))) {
                            result = result.replaceAll("\"", "\"\"");
                            result = "\"" + result + "\"";
                        }
                        result = String.valueOf(result) + ",";
                        break;
                    }
                    case CSV_SQL: {
                        String csvSqlStr = "";
                        if (result != null && !result.isEmpty()) {
                            csvSqlStr = result = this.adjustOutput(result, width);
                            if (csvSqlStr.contains(",") || csvSqlStr.contains("\"") || csvSqlStr.equalsIgnoreCase("null")) {
                                result = result.replaceAll("\"", "\"\"");
                                result = "\"" + result + "\"";
                            }
                        } else {
                            result = nullValue;
                        }
                        if (i == dataRecord.size() - 1) break;
                        result = String.valueOf(result) + ",";
                    }
                }
                writer.write(result);
                ++i;
            }
            writer.write("\n");
            if (this.showProgress) {
                if (r % 10000L == 0L) {
                    System.out.println(String.valueOf(r) + "/" + this.dataFile.getRecordCount());
                } else if (r == this.dataFile.getRecordCount() - 1L) {
                    System.out.println(String.valueOf(r + 1L) + "/" + this.dataFile.getRecordCount());
                }
            }
            ++r;
        }
        if (this.showProgress) {
            this.dataFile.getDataSource().setShowProgress(true);
        }
    }

    public ArrayList<String> writeFormattedDataSql(AsciiFileFormat asciiFormat, String exportFile, String nullValue, boolean includeVarNames, int maxColumns) throws Exception {
        boolean indexVar = false;
        ArrayList<String> csvFiles = new ArrayList<String>();
        ArrayList<BufferedWriter> writers = new ArrayList<BufferedWriter>();
        int neededWriters = this.dataFile.getVariableCount() / maxColumns;
        if (neededWriters == 0) {
            ++neededWriters;
        } else if (this.dataFile.getVariableCount() % maxColumns > 0) {
            ++neededWriters;
        }
        int i = 0;
        while (i < neededWriters) {
            FileWriter fileWriter = new FileWriter(exportFile.replace(".csv", ".table" + (i + 1) + ".csv"));
            csvFiles.add(exportFile.replace(".csv", ".table" + (i + 1) + ".csv"));
            BufferedWriter buffWriter = new BufferedWriter(fileWriter);
            writers.add(buffWriter);
            ++i;
        }
        ArrayList variables = new ArrayList(this.dataFile.getVariables().values());
        if (this.dataFile.getDataSource().getShowProgress()) {
            this.dataFile.getDataSource().setShowProgress(false);
            this.showProgress = true;
        }
        long r = 0L;
        while (r < this.dataFile.getRecordCount()) {
            ArrayList dataRecord = this.dataFile.getDataSource().getRecord(Long.valueOf(r));
            int i2 = 0;
            while (i2 < dataRecord.size()) {
                int writerIndex = i2 / maxColumns;
                BufferedWriter writer = (BufferedWriter)writers.get(writerIndex);
                Object dataValue = dataRecord.get(i2);
                String result = "";
                String spaces = "";
                boolean remaining = false;
                int width = ((Variable)variables.get(i2)).getTextDisplayWidth();
                if (dataValue != null) {
                    result = "" + dataValue;
                }
                if (result.equals("NaN")) {
                    result = "";
                }
                String csvSqlStr = "";
                if (result != null && !result.isEmpty()) {
                    csvSqlStr = result = this.adjustOutput(result, width);
                    if (csvSqlStr.contains(",") || csvSqlStr.contains("\"") || csvSqlStr.equalsIgnoreCase("null")) {
                        result = result.replaceAll("\"", "\"\"");
                        result = "\"" + result + "\"";
                    }
                } else {
                    result = nullValue;
                }
                if (i2 != dataRecord.size() - 1 && (i2 + 1) % maxColumns != 0) {
                    result = String.valueOf(result) + ",";
                }
                writer.write(result);
                ++i2;
            }
            for (BufferedWriter bWriter : writers) {
                bWriter.write("\n");
            }
            if (this.showProgress) {
                if (r % 10000L == 0L) {
                    System.out.println(String.valueOf(r) + "/" + this.dataFile.getRecordCount());
                } else if (r == this.dataFile.getRecordCount() - 1L) {
                    System.out.println(String.valueOf(r + 1L) + "/" + this.dataFile.getRecordCount());
                }
            }
            ++r;
        }
        for (BufferedWriter bWriter : writers) {
            bWriter.flush();
            bWriter.close();
        }
        if (this.showProgress) {
            this.dataFile.getDataSource().setShowProgress(true);
        }
        return csvFiles;
    }

    public DataFile getDataFile() {
        return this.dataFile;
    }

    public void setDataFile(DataFile dataFile) {
        this.dataFile = dataFile;
    }

    public AsciiExportOptions getAsciiExportoptions() {
        return this.asciiExportOptions;
    }

    public void setAsciiExportoptions(AsciiExportOptions asciiExportoptions) {
        this.asciiExportOptions = asciiExportoptions;
    }

    public Transformer getSubsetTransformer() {
        return this.subsetTransformer;
    }

    public void setSubsetTransformer(Transformer subsetTransformer) {
        this.subsetTransformer = subsetTransformer;
    }

    public void setShowProgress(boolean showProgress) {
        this.showProgress = showProgress;
    }
}

