/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.util;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import org.openmetadata.dataset.DataFile;
import org.openmetadata.dataset.DataSet;
import org.openmetadata.dataset.SummaryStatistics;
import org.openmetadata.dataset.SummaryStatisticsOptions;
import org.openmetadata.dataset.Variable;

public class SummaryStatisticsGenerator {
    DataFile dataFile;
    DataSet dataset;
    SummaryStatisticsOptions summaryStatisticsOptions;
    public boolean initiallyContainedValid = true;
    public boolean initiallyContainedInvalid = true;
    public boolean initiallyContainedMean = true;
    public boolean secondRun = false;

    public SummaryStatisticsGenerator() {
    }

    public SummaryStatisticsGenerator(DataFile dataFile, SummaryStatisticsOptions summaryStatisticsOptions) {
        this.dataFile = dataFile;
        this.summaryStatisticsOptions = this.checkForSecondRun(summaryStatisticsOptions);
    }

    public SummaryStatisticsGenerator(DataSet dataset, SummaryStatisticsOptions summaryStatisticsOptions) {
        this.dataset = dataset;
        this.summaryStatisticsOptions = summaryStatisticsOptions;
    }

    public SummaryStatisticsOptions checkForSecondRun(SummaryStatisticsOptions summaryOptions) {
        if (summaryOptions.stats.contains(SummaryStatisticsOptions.STATS.STDEV) || summaryOptions.stats.contains(SummaryStatisticsOptions.STATS.MEDIAN) || summaryOptions.stats.contains(SummaryStatisticsOptions.STATS.MODE)) {
            this.secondRun = true;
        }
        if (summaryOptions.stats.contains(SummaryStatisticsOptions.STATS.STDEV) && !summaryOptions.stats.contains(SummaryStatisticsOptions.STATS.MEAN)) {
            summaryOptions.stats.add(SummaryStatisticsOptions.STATS.MEAN);
            summaryOptions.stats.add(SummaryStatisticsOptions.STATS.VALID);
            summaryOptions.stats.add(SummaryStatisticsOptions.STATS.INVALID);
            this.initiallyContainedValid = false;
            this.initiallyContainedInvalid = false;
            this.initiallyContainedMean = false;
        }
        if (summaryOptions.stats.contains(SummaryStatisticsOptions.STATS.MEAN) && !summaryOptions.stats.contains(SummaryStatisticsOptions.STATS.VALID)) {
            summaryOptions.stats.add(SummaryStatisticsOptions.STATS.VALID);
            this.initiallyContainedValid = false;
        }
        return summaryOptions;
    }

    public void checkSumStatsFromDS(Variable var, Double doubleVal, Double weightValue) {
        SummaryStatistics sumStat;
        String id = this.summaryStatisticsOptions.getId();
        if (doubleVal == null || doubleVal.equals(Double.NaN)) {
            doubleVal = null;
        }
        if (var.getSummaryStatistics(id) != null) {
            sumStat = var.getSummaryStatistics(id);
        } else {
            sumStat = new SummaryStatistics(this.summaryStatisticsOptions);
            var.getSumStatMap().put(id, sumStat);
        }
        if (doubleVal != null) {
            if (doubleVal > sumStat.getMax()) {
                sumStat.setMax(doubleVal.doubleValue());
            }
            if (doubleVal < sumStat.getMin()) {
                sumStat.setMin(doubleVal.doubleValue());
            }
            double meanValTtl = sumStat.getMeanValTotal();
            sumStat.setMeanValTotal(meanValTtl + doubleVal * weightValue);
            Double f = (Double)sumStat.getFrequencies().get(doubleVal);
            f = f != null ? Double.valueOf(f + weightValue) : weightValue;
            sumStat.getFrequencies().put(doubleVal, f);
            double valid = sumStat.getValid();
            sumStat.setValid(valid += weightValue.doubleValue());
        } else {
            double invalid = sumStat.getInvalid();
            sumStat.setInvalid(invalid + 1.0);
        }
    }

    public void computeSumStatResultsFromDS(Variable var) {
        double stanDev;
        String id = this.summaryStatisticsOptions.getId();
        double mean = 0.0;
        double mode = 0.0;
        double most = 0.0;
        double divisor = var.getSummaryStatistics(id).getValid() - 1.0;
        double totalDev = var.getSummaryStatistics(id).getTotalDev();
        if (var.getSummaryStatistics(id).getValid() > 0.0) {
            mean = var.getSummaryStatistics(id).getMeanValTotal() / var.getSummaryStatistics(id).getValid();
            mean = this.roundDouble(mean);
        }
        for (Object valueKey : var.getSummaryStatistics(id).getFrequencies().keySet()) {
            if (valueKey.equals(Double.NaN)) continue;
            String valueStr = valueKey.toString();
            Double value = (double)Double.valueOf(valueStr);
            double deviation = value - mean;
            deviation = Math.pow(deviation, 2.0);
            Double frequency = (Double)var.getSummaryStatistics(id).getFrequencies().get(valueKey);
            var.getSummaryStatistics(id).setTotalDev(totalDev += (deviation *= frequency.doubleValue()));
            if (!(frequency > most)) continue;
            most = frequency;
            mode = (Double)valueKey;
        }
        if (totalDev == 0.0 && divisor == 0.0) {
            stanDev = 0.0;
            double variance = 0.0;
        } else {
            stanDev = totalDev / divisor;
        }
        double variance = stanDev = Math.abs(stanDev);
        variance = this.roundDouble(variance);
        stanDev = Math.sqrt(stanDev);
        stanDev = this.roundDouble(stanDev);
        var.getSummaryStatistics(id).setMean(mean);
        var.getSummaryStatistics(id).setMode((Object)mode);
        var.getSummaryStatistics(id).setStdDeviation(stanDev);
        var.getSummaryStatistics(id).setVariance(variance);
    }

    private void computeMean(Variable var, SummaryStatisticsOptions summaryOptions) {
        if (var.getSummaryStatistics(summaryOptions.getId()).getValid() > 0.0) {
            double mean = var.getSummaryStatistics(summaryOptions.getId()).getMeanValTotal() / var.getSummaryStatistics(summaryOptions.getId()).getValid();
            mean = this.roundDouble(mean);
            var.getSummaryStatistics(summaryOptions.getId()).setMean(mean);
        }
    }

    private void computeMedian(Variable var, SummaryStatisticsOptions summaryOptions) {
        ArrayList<Double> values = var.getSummaryStatistics(summaryOptions.getId()).getValues();
        if (values.size() > 0) {
            values = this.quickSort(values, 0, values.size() - 1);
            int middle = values.size() / 2;
            String valString = values.get(middle).toString();
            Double medianVal = (double)Double.valueOf(valString);
            var.getSummaryStatistics(summaryOptions.getId()).setMedian(medianVal.doubleValue());
        }
    }

    private void computeNumericMode(Variable var, SummaryStatisticsOptions summaryOptions) {
        double mode = 0.0;
        double most = 0.0;
        for (Object val : var.getSummaryStatistics(summaryOptions.getId()).getFrequencies().keySet()) {
            Double frequency = (Double)var.getSummaryStatistics(summaryOptions.getId()).getFrequencies().get(val);
            if (!(frequency > most)) continue;
            most = frequency;
            mode = (Double)val;
        }
        var.getSummaryStatistics(summaryOptions.getId()).setMode((Object)mode);
    }

    private void computeTextMode(Variable var, SummaryStatisticsOptions summaryOptions) {
        String mode = "";
        double strMost = 0.0;
        for (Object str : var.getSummaryStatistics(summaryOptions.getId()).getFrequencies().keySet()) {
            Double frequency = (Double)var.getSummaryStatistics(summaryOptions.getId()).getFrequencies().get(str);
            if (!(frequency > strMost)) continue;
            strMost = frequency;
            mode = (String)str;
        }
        var.getSummaryStatistics(summaryOptions.getId()).setMode((Object)mode);
    }

    private void computeWeightedStandardDeviation(Variable var, SummaryStatisticsOptions summaryOptions, LinkedHashMap<Long, Double> weightValues) throws Exception {
        double weight = 1.0;
        double mean = var.getSummaryStatistics(summaryOptions.getId()).getMean();
        double totalDev = var.getSummaryStatistics(summaryOptions.getId()).getTotalDev();
        ArrayList devValues = var.getSummaryStatistics(summaryOptions.getId()).getDevValueList();
        Long j = 0L;
        while (j < (long)devValues.size()) {
            Double value;
            if (devValues.get(j.intValue()) != null && !((Double)devValues.get(j.intValue())).equals(Double.NaN)) {
                String valueStr = ((Double)devValues.get(j.intValue())).toString();
                value = (double)Double.valueOf(valueStr);
            } else {
                value = null;
            }
            if (weightValues.get(j) != null) {
                weight = weightValues.get(j);
            }
            if (value != null) {
                double deviation = value - mean;
                deviation = Math.pow(deviation, 2.0);
                totalDev = summaryOptions.getWeightVariables().size() > 0 ? (totalDev += deviation * weight) : (totalDev += deviation);
                var.getSummaryStatistics(summaryOptions.getId()).setTotalDev(totalDev);
            }
            j = j + 1L;
        }
        this.calculateFinalStdDev(var, totalDev, summaryOptions);
    }

    private void calculateFinalStdDev(Variable var, Double totalDev, SummaryStatisticsOptions summaryOptions) {
        double valid = var.getSummaryStatistics(summaryOptions.getId()).getValid();
        double invalid = var.getSummaryStatistics(summaryOptions.getId()).getInvalid();
        double divisor = (double)(this.dataFile.getRecordCount() - 1L) - invalid;
        if (summaryOptions.getWeightVariables().size() > 0) {
            divisor = valid;
        }
        double stanDev = totalDev / divisor;
        double variance = stanDev = Math.abs(stanDev);
        variance = this.roundDouble(variance);
        stanDev = Math.sqrt(stanDev);
        stanDev = this.roundDouble(stanDev);
        var.getSummaryStatistics(summaryOptions.getId()).setStdDeviation(stanDev);
        var.getSummaryStatistics(summaryOptions.getId()).setVariance(variance);
    }

    private void computeUnweightedStandardDeviation(Variable var, SummaryStatisticsOptions summaryOptions) throws Exception {
        double mean = var.getSummaryStatistics(summaryOptions.getId()).getMean();
        double totalDev = var.getSummaryStatistics(summaryOptions.getId()).getTotalDev();
        for (Object valueKey : var.getSummaryStatistics(summaryOptions.getId()).getDevValueMap().keySet()) {
            Double value;
            if (valueKey != null && !valueKey.equals(Double.NaN)) {
                String valueStr = valueKey.toString();
                value = (double)Double.valueOf(valueStr);
            } else {
                value = null;
            }
            if (value == null) continue;
            double deviation = value - mean;
            deviation = Math.pow(deviation, 2.0);
            Double equalDeviations = (Double)var.getSummaryStatistics(summaryOptions.getId()).getDevValueMap().get(valueKey);
            var.getSummaryStatistics(summaryOptions.getId()).setTotalDev(totalDev += (deviation *= equalDeviations.doubleValue()));
        }
        this.calculateFinalStdDev(var, totalDev, summaryOptions);
    }

    public void computeSummaryStatisticsByVariable(Variable var) throws Exception {
        LinkedHashMap<Long, Double> weightValues = this.getWeightValues(this.summaryStatisticsOptions);
        SummaryStatistics summaryStatistics = new SummaryStatistics(this.summaryStatisticsOptions);
        var.getSumStatMap().put(summaryStatistics.getId(), summaryStatistics);
        if (this.summaryStatisticsOptions.getIncludedVariables().size() == 0 && !this.summaryStatisticsOptions.getExcludedVariables().contains(var) || this.summaryStatisticsOptions.getIncludedVariables().contains(var)) {
            switch (var.getDataType()) {
                case NUMERIC: {
                    this.updateSummaryStatistics(var, this.summaryStatisticsOptions, weightValues);
                    break;
                }
                case DATETIME: 
                case TEXT: {
                    this.updateTextSummaryStatistics(var, this.summaryStatisticsOptions, weightValues);
                }
            }
            if (var.getSummaryStatistics(this.summaryStatisticsOptions.getId()).isSecondRun()) {
                this.secondRun(var, this.summaryStatisticsOptions, weightValues);
            }
        }
        if (!this.initiallyContainedInvalid && this.summaryStatisticsOptions.getStats().contains(SummaryStatisticsOptions.STATS.INVALID)) {
            this.summaryStatisticsOptions.removeStat(SummaryStatisticsOptions.STATS.INVALID);
        }
        if (!this.initiallyContainedValid && this.summaryStatisticsOptions.getStats().contains(SummaryStatisticsOptions.STATS.VALID)) {
            this.summaryStatisticsOptions.removeStat(SummaryStatisticsOptions.STATS.VALID);
        }
        if (!this.initiallyContainedMean && this.summaryStatisticsOptions.getStats().contains(SummaryStatisticsOptions.STATS.MEAN)) {
            this.summaryStatisticsOptions.removeStat(SummaryStatisticsOptions.STATS.MEAN);
        }
    }

    /*
     * Unable to fully structure code
     */
    int partition(ArrayList<Double> values, int left, int right) {
        i = left;
        j = right;
        pivot = values.get((left + right) / 2);
        ** GOTO lbl19
        {
            ++i;
            do {
                if (values.get(i) < pivot) continue block0;
                while (values.get(j) > pivot) {
                    --j;
                }
                if (i > j) continue;
                tmp = values.get(i);
                values.set(i, values.get(j));
                values.set(j, tmp);
                ++i;
                --j;
lbl19:
                // 3 sources

            } while (i <= j);
        }
        return i;
    }

    ArrayList<Double> quickSort(ArrayList<Double> values, int left, int right) {
        int index = this.partition(values, left, right);
        if (left < index - 1) {
            this.quickSort(values, left, index - 1);
        }
        if (index < right) {
            this.quickSort(values, index, right);
        }
        return values;
    }

    public double roundDouble(double value) {
        DecimalFormat decimal = new DecimalFormat("0.###");
        String transferStr = decimal.format(value);
        double roundedValue = Double.parseDouble(transferStr);
        return roundedValue;
    }

    public void secondRun(Variable var, SummaryStatisticsOptions summaryOptions, LinkedHashMap<Long, Double> weightValues) throws Exception {
        switch (var.getDataType()) {
            case NUMERIC: {
                for (SummaryStatisticsOptions.STATS stat : summaryOptions.stats) {
                    switch (stat) {
                        case MODE: {
                            this.computeNumericMode(var, summaryOptions);
                            break;
                        }
                        case MEDIAN: {
                            this.computeMedian(var, summaryOptions);
                            break;
                        }
                        case STDEV: {
                            if (summaryOptions.getWeightVariables().size() > 0) {
                                this.computeWeightedStandardDeviation(var, summaryOptions, weightValues);
                                break;
                            }
                            this.computeUnweightedStandardDeviation(var, summaryOptions);
                        }
                    }
                }
                break;
            }
            case DATETIME: 
            case TEXT: {
                if (!summaryOptions.stats.contains(SummaryStatisticsOptions.STATS.MODE)) break;
                this.computeTextMode(var, summaryOptions);
            }
        }
    }

    public void updateSummaryStatistics(Variable var, SummaryStatisticsOptions summaryOptions, LinkedHashMap<Long, Double> weightValues) throws Exception {
        Double max = var.getSummaryStatistics(summaryOptions.getId()).getMax();
        Double min = var.getSummaryStatistics(summaryOptions.getId()).getMin();
        double meanValTotal = var.getSummaryStatistics(summaryOptions.getId()).getMeanValTotal();
        double weight = 1.0;
        double valid = 0.0;
        double invalid = 0.0;
        long i = 0L;
        while (i < this.dataFile.getRecordCount()) {
            Double value;
            Object dataValue = this.dataFile.getDataSource().getValue(var, Long.valueOf(i));
            if (weightValues.get(i) != null) {
                weight = weightValues.get(i);
            }
            if (dataValue != null && !dataValue.toString().equals("")) {
                String valueStr = dataValue.toString();
                value = (double)Double.valueOf(valueStr);
            } else {
                value = null;
            }
            if (value != null && !value.equals(Double.NaN)) {
                valid += weight;
                for (SummaryStatisticsOptions.STATS stat : summaryOptions.getStats()) {
                    Double weightedValue = value * weight;
                    switch (stat) {
                        case MAX: {
                            if (!(value > max)) break;
                            max = value;
                            break;
                        }
                        case MIN: {
                            if (!(value < min)) break;
                            min = value;
                            break;
                        }
                        case MEAN: {
                            meanValTotal += weightedValue.doubleValue();
                            break;
                        }
                        case MEDIAN: {
                            var.getSummaryStatistics(summaryOptions.getId()).getValues().add(value);
                            break;
                        }
                        case FREQ: 
                        case MODE: {
                            Double f = (Double)var.getSummaryStatistics(summaryOptions.getId()).getFrequencies().get(value);
                            if (f == null) {
                                f = 0.0;
                            }
                            f = f + weight;
                            var.getSummaryStatistics(summaryOptions.getId()).getFrequencies().put(value, f);
                        }
                    }
                }
            } else {
                invalid += weight;
            }
            if (this.secondRun) {
                if (summaryOptions.getWeightVariables().size() > 0) {
                    var.getSummaryStatistics(summaryOptions.getId()).addToDevValueList(value);
                } else {
                    Double f = (Double)var.getSummaryStatistics(summaryOptions.getId()).getDevValueMap().get(value);
                    if (f == null) {
                        f = 0.0;
                    }
                    f = f + 1.0;
                    var.getSummaryStatistics(summaryOptions.getId()).getDevValueMap().put(value, f);
                }
            }
            ++i;
        }
        var.getSummaryStatistics(summaryOptions.getId()).setMax(max.doubleValue());
        var.getSummaryStatistics(summaryOptions.getId()).setMin(min.doubleValue());
        var.getSummaryStatistics(summaryOptions.getId()).setMean(meanValTotal / valid);
        var.getSummaryStatistics(summaryOptions.getId()).setSecondRun(this.secondRun);
        var.getSummaryStatistics(summaryOptions.getId()).setValid(valid);
        var.getSummaryStatistics(summaryOptions.getId()).setInvalid(invalid);
    }

    public void updateTextSummaryStatistics(Variable var, SummaryStatisticsOptions summaryOptions, LinkedHashMap<Long, Double> weightValues) throws Exception {
        double weight = 1.0;
        double valid = 0.0;
        double invalid = 0.0;
        long i = 0L;
        while (i < this.dataFile.getRecordCount()) {
            Object dataValue = this.dataFile.getDataSource().getValue(var, Long.valueOf(i));
            if (weightValues.get(i) != null) {
                weight = weightValues.get(i);
            }
            String strValue = dataValue != null ? dataValue.toString() : null;
            for (SummaryStatisticsOptions.STATS stat : summaryOptions.stats) {
                switch (stat) {
                    case FREQ: 
                    case MODE: {
                        Double f = (Double)var.getSummaryStatistics(summaryOptions.getId()).getFrequencies().get(strValue);
                        if (f == null) {
                            f = 0.0;
                        }
                        f = f + weight;
                        var.getSummaryStatistics(summaryOptions.getId()).getFrequencies().put(strValue, f);
                    }
                }
            }
            ++i;
        }
        var.getSummaryStatistics(summaryOptions.getId()).setMax(0.0);
        var.getSummaryStatistics(summaryOptions.getId()).setMin(0.0);
        var.getSummaryStatistics(summaryOptions.getId()).setSecondRun(this.secondRun);
    }

    public DataFile getDataFile() {
        return this.dataFile;
    }

    public void setDataFile(DataFile dataFile) {
        this.dataFile = dataFile;
    }

    public SummaryStatisticsOptions getSummaryStatisticsOptions() {
        return this.summaryStatisticsOptions;
    }

    public void setSummaryStatisticsOptions(SummaryStatisticsOptions summaryStatisticsOptions) {
        this.summaryStatisticsOptions = summaryStatisticsOptions;
    }

    public LinkedHashMap<Long, Double> getWeightValues(SummaryStatisticsOptions summaryOptions) throws Exception {
        LinkedHashMap<Long, Double> weightList = new LinkedHashMap<Long, Double>();
        for (Variable weightVar : summaryOptions.getWeightVariables()) {
            ArrayList weightData = this.dataFile.getDataSource().getValues(weightVar);
            Long i = 0L;
            while (i < (long)weightData.size()) {
                if (weightData.get(i.intValue()) != null) {
                    String weightStr = weightData.get(i.intValue()).toString();
                    Double weightDouble = 1.0;
                    if (weightVar.getDataType() == Variable.DATA_TYPE.NUMERIC) {
                        weightDouble = (double)Double.valueOf(weightStr);
                    }
                    if (weightList.get(i) == null) {
                        weightList.put(i, weightDouble);
                    } else if (weightList.get(i) != null) {
                        weightList.put(i, weightList.get(i) * weightDouble);
                    } else {
                        weightList.put(i, weightDouble);
                    }
                } else {
                    weightList.put(i, null);
                }
                i = i + 1L;
            }
        }
        return weightList;
    }
}

