/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.store.repository.basex.impl;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.basex.core.BaseXException;
import org.basex.core.Command;
import org.basex.core.Context;
import org.basex.core.MainProp;
import org.basex.core.Prop;
import org.basex.core.cmd.CreateDB;
import org.basex.core.cmd.Set;
import org.openmetadata.store.repository.basex.CommandExecutor;

public class ContextCommandExecutor
implements CommandExecutor {
    protected Log logger = LogFactory.getLog(this.getClass());
    private static final Context context = new Context();

    public ContextCommandExecutor(String db) {
        this(db, null);
    }

    public ContextCommandExecutor(String db, String path) {
        try {
            if (path != null) {
                ContextCommandExecutor.context.mprop.set(MainProp.DBPATH, path);
            }
            if (!ContextCommandExecutor.context.mprop.dbexists(db)) {
                this.logger.debug((Object)("Creating BaseX database: " + db));
                new CreateDB(db).execute(context);
                new Set((Object)Prop.CHOP, (Object)"OFF").execute(context);
            }
        }
        catch (BaseXException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String executeCommand(Command command) {
        try {
            return command.execute(context);
        }
        catch (BaseXException e) {
            this.logger.error((Object)e);
            throw new RuntimeException(e);
        }
    }
}

