/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.store.repository.basex.impl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.XmlBeans;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.openmetadata.cache.Cache;
import org.openmetadata.cache.impl.SoftCache;
import org.openmetadata.store.query.Criteria;
import org.openmetadata.store.repository.basex.DatabaseManager;
import org.openmetadata.store.repository.basex.xquery.ConditionSet;
import org.openmetadata.store.repository.basex.xquery.Sort;
import org.openmetadata.store.repository.basex.xquery.XQueryComponents;
import org.openmetadata.store.xml.xmlbeans.catalog.CatalogDocument;
import org.openmetadata.store.xml.xmlbeans.history.SnapshotDocument;
import org.openmetadata.store.xml.xmlbeans.result.ResultType;
import org.openmetadata.store.xml.xmlbeans.result.SearchResultDocument;

public class ContainerDatabaseManager<Xml extends XmlObject>
implements DatabaseManager<Xml>,
Cache<Xml> {
    protected final String DB;
    protected final String DEFAULT_CONTEXT = "ROOT_CONTEXT";
    protected final String WS = "workspace";
    protected final String SS = "snapshot";
    protected final String CONT = "contents";
    protected final String OBJ = "object";
    protected final Class<Xml> xmlClass;
    protected final SchemaType baseSchemaType;
    protected final Map<String, String> contextMap;
    private Cache<Xml> cache;
    private boolean caching = false;
    private CatalogDocument defaultCatalog;

    public ContainerDatabaseManager(String db, Class<Xml> xmlClass) {
        this.DB = db;
        this.xmlClass = xmlClass;
        this.cache = this.constructCache();
        this.baseSchemaType = XmlBeans.typeForClass(xmlClass);
        this.contextMap = new HashMap<String, String>();
        this.contextMap.put("ROOT_CONTEXT", "");
        this.defaultCatalog = CatalogDocument.Factory.newInstance();
        this.defaultCatalog.addNewCatalog();
    }

    @Override
    public String getDatabaseName() {
        return this.DB;
    }

    @Override
    public String getDefaultContext() {
        return "ROOT_CONTEXT";
    }

    @Override
    public String buildContainsXQuery(String id) {
        StringBuilder sb = new StringBuilder();
        sb.append("if(" + this.buildWorkspaceOpenStatement() + this.getSelector(id) + "[" + this.getIdentifierXPath(id) + "='" + id + "'])\n");
        sb.append("then 'true'\n");
        sb.append("else 'false'\n");
        return sb.toString();
    }

    @Override
    public String buildSelectXQuery(String id) {
        return String.valueOf(this.buildWorkspaceOpenStatement()) + this.getSelector(id) + "[" + this.getIdentifierXPath(id) + "='" + id + "']";
    }

    @Override
    public String buildSelectXQuery(Set<String> ids) {
        StringBuilder sb = new StringBuilder();
        sb.append("declare variable $ids as xs:string* := (");
        if (ids.size() > 0) {
            for (String id : ids) {
                sb.append("'" + id + "',");
            }
            sb.deleteCharAt(sb.length() - 1);
        }
        sb.append(");\n");
        sb.append("let $results:=" + this.buildWorkspaceOpenStatement() + this.getSelector(ids) + "[" + this.getIdentifierXPath(ids) + "=$ids]\n");
        sb.append("return\n");
        sb.append("<ResultSet xmlns=\"http://openmetadata.org/store/result\">\n");
        sb.append("{for $result in $results return $result}\n");
        sb.append("</ResultSet>\n");
        return sb.toString();
    }

    @Override
    public String buildRelatedObjectXQuery(String id) {
        StringBuilder sb = new StringBuilder();
        sb.append("let $context := substring-before(base-uri(" + this.buildWorkspaceOpenStatement() + this.getSelector(id) + "[" + this.getIdentifierXPath(id) + "='" + id + "']),'" + this.buildDocumentPath(id) + "')\n");
        sb.append("let $results := db:open('" + this.DB + "',concat($context,'/" + "contents" + "'))/* | db:open('" + this.DB + "',concat($context,'/" + "object" + "'))/*\n");
        sb.append("return\n");
        sb.append("<ResultSet xmlns=\"http://openmetadata.org/store/result\">\n");
        sb.append("{for $result in $results\n");
        sb.append("where $result[" + this.getIdentifierXPath(id) + "!='" + id + "']\n");
        sb.append("return $result}\n");
        sb.append("</ResultSet>\n");
        return sb.toString();
    }

    @Override
    public final String buildUpdateXQuery(String transactionId, String contextId, Xml xml, DatabaseManager.Action action) {
        switch (action) {
            case ADD: {
                return this.buildSnapshotAdd(transactionId, contextId, xml);
            }
            case DELETE: {
                return this.buildSnapshotDelete(transactionId, xml);
            }
            case UPDATE: {
                return this.buildSnapshotUpdate(transactionId, xml);
            }
        }
        throw new RuntimeException("Action (" + (Object)((Object)action) + ") not supported.");
    }

    @Override
    public final String buildCommitXQuery(String transactionId, boolean retainSnapshot) {
        StringBuilder sb = new StringBuilder();
        sb.append("let $working := 'workspace/'\n");
        sb.append("let $snapshot := 'snapshot/" + transactionId + "/'\n");
        sb.append("for $doc in db:list('" + this.DB + "',$snapshot)\n");
        sb.append("let $name := substring-after($doc,$snapshot)\n");
        sb.append("let $wsname := concat($working,$name)\n");
        sb.append("return\n");
        if (retainSnapshot) {
            sb.append("db:replace('" + this.DB + "',concat($working,$name),document{db:open('" + this.DB + "',$doc)/*})\n");
        } else {
            sb.append("(\n");
            sb.append("db:delete('" + this.DB + "',$wsname),\n");
            sb.append("db:rename('" + this.DB + "',$doc,$wsname)\n");
            sb.append(")\n");
        }
        sb.append(",db:optimize('" + this.getDatabaseName() + "',true())");
        return sb.toString();
    }

    @Override
    public final String buildRollbackXQuery(String transactionId) {
        StringBuilder sb = new StringBuilder();
        sb.append("db:delete(");
        sb.append("'" + this.DB + "',");
        sb.append("'snapshot/" + transactionId + "'");
        sb.append(")");
        return sb.toString();
    }

    @Override
    public String buildSearchXQuery(String contextId, Criteria<?> criteria) {
        if (!this.contextMap.containsKey(contextId)) {
            throw new RuntimeException("Context (" + contextId + ") not found.");
        }
        String contextPath = this.contextMap.get(contextId);
        XQueryComponents components = this.buildXQueryComponents(criteria);
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> ns : components.getNamespacePrefixMap().entrySet()) {
            sb.append("declare namespace " + ns.getKey() + " = '" + ns.getValue() + "';\n");
        }
        sb.append("declare namespace omr = 'http://openmetadata.org/store/result';\n");
        sb.append("let $contexts :=");
        sb.append("db:open('" + this.DB + "','" + "workspace" + "/" + contextPath);
        if (criteria.searchChildContexts()) {
            sb.append("')");
        } else {
            sb.append("/contents')");
            Iterator<Object> iterator = this.contextMap.values().iterator();
            block1: while (iterator.hasNext()) {
                String candidateChild;
                String parentPath = candidateChild = (String)iterator.next();
                while (parentPath.contains("/")) {
                    if (!this.contextMap.containsKey(parentPath = parentPath.substring(0, parentPath.lastIndexOf("/")))) continue;
                    if (!parentPath.equals(contextPath)) continue block1;
                    sb.append(" | db:open('" + this.DB + "','" + "workspace" + "/" + candidateChild + "/" + "object" + "')");
                }
            }
        }
        if (criteria.searchParentContexts()) {
            String parentPath = contextPath;
            while (parentPath.contains("/")) {
                if (!this.contextMap.containsValue(parentPath = parentPath.substring(0, parentPath.lastIndexOf("/")))) continue;
                sb.append(" | db:open('" + this.DB + "','" + "workspace" + "/" + parentPath + "/" + "contents" + "')");
                sb.append(" | db:open('" + this.DB + "','" + "workspace" + "/" + parentPath + "/" + "object" + "')");
            }
        }
        sb.append("\n");
        String[] stringArray = components.getLets();
        int parentPath = stringArray.length;
        int n = 0;
        while (n < parentPath) {
            String let = stringArray[n];
            sb.append("let " + let + "\n");
            ++n;
        }
        sb.append("let $selection := $contexts" + components.getSelection() + "\n");
        sb.append("return\n");
        sb.append("<omr:SearchResult xmlns:xhtml=\"http://www.w3.org/1999/xhtml\">\n");
        sb.append("{\n");
        sb.append("for $item in $selection\n");
        ConditionSet conditions = components.getConditionSet();
        if (conditions != null) {
            sb.append("where");
            this.appendCondition(conditions, sb);
            sb.append("\n");
        }
        if (components.getSorts().length > 0) {
            sb.append("order by ");
            int i = 0;
            while (i < components.getSorts().length) {
                Sort sort = components.getSorts()[i];
                if (i > 0) {
                    sb.append(",");
                }
                sb.append(" $item" + sort.getSelector());
                if (sort.getOrder().equals((Object)Sort.Order.DESC)) {
                    sb.append(" descending");
                }
                ++i;
            }
            sb.append("\n");
        }
        sb.append("return\n");
        sb.append("<omr:Result id=\"{data($item/" + this.getIdentifierXPath(criteria) + ")}\">\n");
        if (components.includeName()) {
            sb.append("<omr:Name>{data($item/" + components.getNameSelector() + ")}</omr:Name>\n");
        }
        if (components.includeDetail()) {
            sb.append("<omr:Detail>\n{\n" + components.getDetailComponent() + "\n}\n</omr:Detail>\n");
        }
        sb.append("</omr:Result>\n");
        sb.append("}\n");
        sb.append("</omr:SearchResult>\n");
        return sb.toString();
    }

    private void appendCondition(ConditionSet conditions, StringBuilder sb) {
        String join = conditions.getJoin().equals((Object)ConditionSet.Join.AND) ? "and" : "or";
        int i = 0;
        while (i < conditions.getConditions().length) {
            if (i > 0) {
                sb.append(" " + join);
            }
            sb.append(" $item" + conditions.getConditions()[i]);
            ++i;
        }
        int j = 0;
        while (j < conditions.getConditionSets().length) {
            if (i > 0 || j > 0) {
                sb.append(" " + join);
            }
            sb.append("(");
            this.appendCondition(conditions.getConditionSets()[j], sb);
            sb.append(")");
            ++j;
        }
    }

    @Override
    public final String buildAddSnapshotInformation(String transactionId, SnapshotDocument xml) {
        StringBuilder sb = new StringBuilder();
        sb.append("db:add('" + this.DB + "'");
        sb.append(",document { " + xml.xmlText() + " }");
        sb.append(",'snapshot/" + transactionId + "'");
        sb.append(")");
        return sb.toString();
    }

    @Override
    public final String buildSnapshotHistoryXQuery() {
        StringBuilder sb = new StringBuilder();
        sb.append("declare default element namespace 'http://openmetadata.org/store/history';\n");
        sb.append("<SnapshotHistory>\n");
        sb.append("{\n");
        sb.append("let $snapshots := db:open('" + this.DB + "','" + "snapshot" + "')/Snapshot\n");
        sb.append("for $snapshot in $snapshots\n");
        sb.append("order by $snapshot/@date ascending\n");
        sb.append("return $snapshot\n");
        sb.append("}\n");
        sb.append("</SnapshotHistory>");
        return sb.toString();
    }

    @Override
    public String buildSnapshotXQuery(String snapshotId, String id) {
        return String.valueOf(this.buildSnapshotOpenStatement()) + "//*[" + this.getIdentifierXPath(id) + "='" + id + "']";
    }

    @Override
    public final String buildRestoreXQuery(String snapshotId, String ... ids) {
        StringBuilder sb = new StringBuilder();
        if (ids.length > 0) {
            sb.append("declare variable $ids as xs:string* := (");
            String[] stringArray = ids;
            int n = ids.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                sb.append("'" + id + "',");
                ++n2;
            }
            sb.deleteCharAt(sb.length() - 1);
            sb.append(");\n");
        }
        sb.append("let $working := 'workspace/'\n");
        sb.append("let $snapshot := 'snapshot/" + snapshotId + "/'\n");
        if (ids.length > 0) {
            sb.append("for $name in $ids\n");
        } else {
            sb.append("for $doc in db:list('" + this.DB + "',$snapshot)\n");
            sb.append("let $name := substring-after($doc,$snapshot)\n");
        }
        sb.append("let $wsname := concat($working,$name)\n");
        sb.append("return\n");
        sb.append("db:replace('" + this.DB + "',concat($working,$name),document{db:open('" + this.DB + "',$doc)/*})\n");
        return sb.toString();
    }

    @Override
    public String buildRawCatalogXQuery() {
        StringBuilder sb = new StringBuilder();
        sb.append("declare namespace cat = \"http://openmetadata.org/store/catalog\";\n");
        sb.append("let $contexts := (");
        for (String context : this.contextMap.values()) {
            sb.append("'" + context + "',");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(")\n");
        sb.append("let $defaultContext := 'ROOT_CONTEXT'\n");
        sb.append("let $defaultPath := '" + this.contextMap.get("ROOT_CONTEXT") + "'\n");
        sb.append("return\n");
        sb.append("<cat:Catalog isPartial=\"true\">\n");
        sb.append("{\n");
        sb.append("for $context in $contexts\n");
        sb.append("order by string-length($context), $context\n");
        sb.append("return\n");
        sb.append("if (db:open('" + this.DB + "',concat('" + "workspace" + "/',$context, '/" + "object" + "'))/*)\n");
        sb.append("then\n");
        sb.append("(\n");
        sb.append("let $item := db:open('" + this.DB + "',concat('" + "workspace" + "/',$context, '/" + "object" + "'))/*\n");
        sb.append("return");
        sb.append("<cat:Node isContext=\"true\" contextId=\"{$context}\" type=\"org.openmetadata.beans.IdentifiableBean\">\n");
        sb.append("{$item/" + this.getGlobalIdentifierXPath() + "}\n");
        sb.append("<cat:Name>{data($item/" + this.getGlobalIdentifierXPath() + ")}</cat:Name>\n");
        sb.append("{\n");
        sb.append("let $items := db:open('" + this.DB + "',concat('" + "workspace" + "/',$context, '/" + "contents" + "'))/*\n");
        sb.append("for $item in $items\n");
        sb.append("order by $item/" + this.getGlobalIdentifierXPath() + "\n");
        sb.append("return\n");
        sb.append("<cat:Node type=\"org.openmetadata.beans.IdentifiableBean\">\n");
        sb.append("{$item/" + this.getGlobalIdentifierXPath() + "}\n");
        sb.append("<cat:Name>{data($item/" + this.getGlobalIdentifierXPath() + ")}</cat:Name>\n");
        sb.append("</cat:Node>\n");
        sb.append("}\n");
        sb.append("</cat:Node>\n");
        sb.append(")\n");
        sb.append("else\n");
        sb.append("(\n");
        sb.append("let $items := db:open('" + this.DB + "',concat('" + "workspace" + "/',$context, '/" + "contents" + "'))/*\n");
        sb.append("return(\n");
        sb.append("if ($context=$defaultPath)\n");
        sb.append("then\n");
        sb.append("(\n");
        sb.append("for $item in $items\n");
        sb.append("order by $item/" + this.getGlobalIdentifierXPath() + "\n");
        sb.append("return\n");
        sb.append("<cat:Node type=\"org.openmetadata.beans.IdentifiableBean\">\n");
        sb.append("{$item/@id}\n");
        sb.append("<cat:Name>{data($item/" + this.getGlobalIdentifierXPath() + ")}</cat:Name>\n");
        sb.append("</cat:Node>\n");
        sb.append(")\n");
        sb.append("else\n");
        sb.append("(\n");
        sb.append("<cat:Level isContext=\"true\" contextId=\"{$context}\">\n");
        sb.append("{\n");
        sb.append("for $item in $items\n");
        sb.append("order by $item/" + this.getGlobalIdentifierXPath() + "\n");
        sb.append("return\n");
        sb.append("<cat:Node type=\"org.openmetadata.beans.IdentifiableBean\">\n");
        sb.append("{$item/" + this.getGlobalIdentifierXPath() + ",\n");
        sb.append("attribute context {if ($context=$defaultPath) then ($defaultContext) else ($context)} }\n");
        sb.append("<cat:Name>{data($item/" + this.getGlobalIdentifierXPath() + ")}</cat:Name>\n");
        sb.append("</cat:Node>\n");
        sb.append("}\n");
        sb.append("</cat:Level>\n");
        sb.append(")\n");
        sb.append(")\n");
        sb.append(")\n");
        sb.append("}\n");
        sb.append("</cat:Catalog>\n");
        return sb.toString();
    }

    @Override
    public CatalogDocument getDefaultCatalog() {
        return this.defaultCatalog;
    }

    @Override
    public String buildContextListQuery() {
        StringBuilder sb = new StringBuilder();
        sb.append("let $paths := db:list('" + this.DB + "','" + "workspace" + "')\n");
        sb.append("return\n");
        sb.append("<SearchResult xmlns=\"http://openmetadata.org/store/result\">\n");
        sb.append("{\n");
        sb.append("for $path in $paths\n");
        sb.append("return <Result id=\"{$path}\"/>\n");
        sb.append("}\n");
        sb.append("</SearchResult>\n");
        return sb.toString();
    }

    @Override
    public void populateContexts(SearchResultDocument searchDocument) {
        for (ResultType result : searchDocument.getSearchResult().getResultList()) {
            String path = result.getId();
            if ((path = path.substring(path.indexOf("workspace/") + "workspace/".length())).contains("/contents")) {
                path = path.substring(0, path.indexOf("/contents"));
            } else {
                if (!path.contains("/object")) continue;
                path = path.substring(0, path.indexOf("/object"));
            }
            if (this.contextMap.containsKey(path)) continue;
            this.contextMap.put(path, path);
        }
    }

    @Override
    public String getId(Xml xml) {
        XmlCursor cursor = xml.newCursor();
        cursor.toFirstChild();
        return cursor.getAttributeText(new QName("id"));
    }

    public void add(Xml xml) {
        if (this.caching) {
            this.cache.add(xml);
            this.cacheContainedObjects(xml);
        }
    }

    public boolean contains(String id) {
        if (this.caching) {
            return this.cache.contains(id);
        }
        return false;
    }

    public Xml get(String id) {
        if (this.caching) {
            return (Xml)((XmlObject)this.cache.get(id));
        }
        return null;
    }

    public void remove(Xml xml) {
        if (this.caching) {
            this.cache.remove(xml);
            this.removeContainedObjects(xml);
        }
    }

    @Override
    public void resetCache() {
        this.cache = this.constructCache();
    }

    @Override
    public final Cache<Xml> getCache() {
        return this;
    }

    public void setDefaultCatalog(CatalogDocument catalog) {
        this.defaultCatalog = catalog;
    }

    public void addDefaultContext(String id, String path) {
        this.contextMap.put(id, path);
    }

    public void setCaching(boolean caching) {
        this.caching = caching;
    }

    protected final String buildSnapshotAdd(String transactionId, String contextId, Xml xml) {
        if (!this.contextMap.containsKey(contextId = this.adjustContext(xml, contextId))) {
            throw new RuntimeException("Context (" + contextId + ") not found.");
        }
        String contextPath = this.contextMap.get(contextId);
        StringBuilder sb = new StringBuilder();
        sb.append("db:add('" + this.DB + "'");
        sb.append(",document { " + xml.xmlText(new XmlOptions().setSaveOuter()) + " }");
        sb.append(",'snapshot/" + transactionId + "/" + contextPath + "/" + this.buildDocumentPath(this.getId(xml)) + "'");
        sb.append(")");
        return sb.toString();
    }

    protected final String buildSnapshotDelete(String transactionId, Xml xml) {
        StringBuilder sb = new StringBuilder();
        String id = this.getId(xml);
        sb.append("let $path := substring-after(base-uri(db:open('" + this.DB + "','" + "workspace" + "')/*[" + this.getIdentifierXPath(id) + "='" + id + "']),'" + "workspace" + "')\n");
        sb.append("return\n");
        sb.append("db:add('" + this.DB + "'");
        sb.append(",document { '' }");
        sb.append(",concat('snapshot/" + transactionId + "', $path)");
        sb.append(")");
        return sb.toString();
    }

    protected final String buildSnapshotUpdate(String transactionId, Xml xml) {
        StringBuilder sb = new StringBuilder();
        String id = this.getId(xml);
        sb.append("let $path := substring-after(base-uri(db:open('" + this.DB + "','" + "workspace" + "')/*[" + this.getIdentifierXPath(id) + "='" + id + "']),'" + "workspace" + "')\n");
        sb.append("return\n");
        sb.append("db:add('" + this.DB + "'");
        sb.append(",document { " + xml.xmlText(new XmlOptions().setSaveOuter()) + " }");
        sb.append(",concat('snapshot/" + transactionId + "', $path)");
        sb.append(")");
        return sb.toString();
    }

    protected Cache<Xml> constructCache() {
        return new SoftCache<Xml>(){

            protected String extractId(Xml xml) {
                return ContainerDatabaseManager.this.getId(xml);
            }
        };
    }

    protected void cacheContainedObjects(Xml xml) {
        XmlObject[] children;
        XmlObject[] xmlObjectArray = children = this.getContainedObjects(xml);
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            XmlObject child = xmlObjectArray[n2];
            if (this.baseSchemaType.isAssignableFrom(child.schemaType())) {
                this.cache.add((Object)((XmlObject)this.xmlClass.cast(child.changeType(this.baseSchemaType))));
            }
            ++n2;
        }
    }

    protected void removeContainedObjects(Xml xml) {
        XmlObject[] children;
        XmlObject[] xmlObjectArray = children = this.getContainedObjects(xml);
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            XmlObject child = xmlObjectArray[n2];
            if (this.baseSchemaType.isAssignableFrom(child.schemaType())) {
                this.cache.remove((Object)((XmlObject)this.xmlClass.cast(child.changeType(this.baseSchemaType))));
            }
            ++n2;
        }
    }

    protected XmlObject[] getContainedObjects(Xml xml) {
        return xml.selectPath("/*//*[@id]");
    }

    protected String buildWorkspaceOpenStatement() {
        return "db:open('" + this.DB + "','" + "workspace" + "')";
    }

    protected String buildSnapshotOpenStatement() {
        return this.buildSnapshotOpenStatement("");
    }

    protected String buildSnapshotOpenStatement(String snapshotId) {
        return "db:open('" + this.DB + "','" + "snapshot" + "/" + snapshotId + "')";
    }

    protected String buildDocumentPathIdPart(String id) {
        return id;
    }

    protected String getGlobalIdentifierXPath() {
        return "@id";
    }

    protected String getGlobalSelector() {
        return "/*";
    }

    protected String getSelector(String id) {
        return this.getGlobalSelector();
    }

    protected String getIdentifierXPath(String id) {
        return this.getGlobalIdentifierXPath();
    }

    protected String getSelector(Set<String> ids) {
        return this.getGlobalSelector();
    }

    protected String getIdentifierXPath(Set<String> ids) {
        return this.getGlobalIdentifierXPath();
    }

    protected String getIdentifierXPath(Criteria<?> criteria) {
        return this.getGlobalIdentifierXPath();
    }

    protected String adjustContext(Xml xml, String contextId) {
        return contextId;
    }

    protected boolean isContextObject(String id) {
        return false;
    }

    protected XQueryComponents buildXQueryComponents(Criteria<?> criteria) {
        return new XQueryComponents(){

            @Override
            public Map<String, String> getNamespacePrefixMap() {
                return new HashMap<String, String>();
            }

            @Override
            public String[] getLets() {
                return new String[0];
            }

            @Override
            public String getSelection() {
                return "/*";
            }

            @Override
            public ConditionSet getConditionSet() {
                return new ConditionSet(){

                    @Override
                    public ConditionSet.Join getJoin() {
                        return ConditionSet.Join.AND;
                    }

                    @Override
                    public String[] getConditions() {
                        return new String[]{"[contains(@id, 'test')]", "[contains(@id, 'ch')]"};
                    }

                    @Override
                    public ConditionSet[] getConditionSets() {
                        return new ConditionSet[0];
                    }
                };
            }

            @Override
            public Sort[] getSorts() {
                return new Sort[]{new Sort(){

                    @Override
                    public Sort.Order getOrder() {
                        return Sort.Order.ASC;
                    }

                    @Override
                    public String getSelector() {
                        return "/@id";
                    }
                }, new Sort(){

                    @Override
                    public Sort.Order getOrder() {
                        return Sort.Order.DESC;
                    }

                    @Override
                    public String getSelector() {
                        return "/parent::item/@id";
                    }
                }};
            }

            @Override
            public boolean includeName() {
                return false;
            }

            @Override
            public String getNameSelector() {
                return null;
            }

            @Override
            public boolean includeDetail() {
                return false;
            }

            @Override
            public String getDetailComponent() {
                return null;
            }
        };
    }

    private String buildDocumentPath(String id) {
        if (this.isContextObject(id)) {
            return String.valueOf(this.buildDocumentPathIdPart(id)) + "/" + "object";
        }
        return "contents/" + this.buildDocumentPathIdPart(id);
    }
}

