/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.store.repository.basex;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.basex.core.BaseXException;
import org.basex.core.Command;
import org.basex.core.Prop;
import org.basex.core.cmd.Close;
import org.basex.core.cmd.Flush;
import org.basex.core.cmd.Open;
import org.basex.core.cmd.Set;
import org.basex.core.cmd.XQuery;
import org.openmetadata.cache.Cache;
import org.openmetadata.store.catalog.Catalog;
import org.openmetadata.store.catalog.xml.XmlCatalog;
import org.openmetadata.store.exceptions.InvalidCriteriaException;
import org.openmetadata.store.exceptions.ObjectNotFoundException;
import org.openmetadata.store.exceptions.StoreException;
import org.openmetadata.store.query.Criteria;
import org.openmetadata.store.query.Result;
import org.openmetadata.store.query.SearchResult;
import org.openmetadata.store.query.impl.ResultImpl;
import org.openmetadata.store.query.impl.SearchResultImpl;
import org.openmetadata.store.repository.SnapshotRepository;
import org.openmetadata.store.repository.basex.CommandExecutor;
import org.openmetadata.store.repository.basex.DatabaseManager;
import org.openmetadata.store.repository.notification.SaveEvent;
import org.openmetadata.store.repository.notification.SaveListener;
import org.openmetadata.store.repository.notification.impl.SaveEventImpl;
import org.openmetadata.store.snapshot.SnapshotHistory;
import org.openmetadata.store.snapshot.impl.XmlSnapshotHistory;
import org.openmetadata.store.xml.xmlbeans.catalog.CatalogDocument;
import org.openmetadata.store.xml.xmlbeans.catalog.LevelType;
import org.openmetadata.store.xml.xmlbeans.catalog.NodeType;
import org.openmetadata.store.xml.xmlbeans.history.SnapshotDocument;
import org.openmetadata.store.xml.xmlbeans.history.SnapshotHistoryDocument;
import org.openmetadata.store.xml.xmlbeans.result.ResultSetDocument;
import org.openmetadata.store.xml.xmlbeans.result.ResultType;
import org.openmetadata.store.xml.xmlbeans.result.SearchResultDocument;
import org.openmetadata.util.xmlbeans.XhtmlUtilities;
import org.openmetadata.util.xmlbeans.XmlObjectCaster;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AXmlSnapshotRepository<Xml extends XmlObject>
implements SnapshotRepository<Xml> {
    protected Log logger = LogFactory.getLog(this.getClass());
    protected final Class<Xml> xmlBeanClass;
    protected final CopyOnWriteArrayList<SaveListener> saveListeners;
    private final DatabaseManager<Xml> manager;
    private java.util.Set<String> relatedCacheList;
    private String name;
    private boolean managerInitialized;
    protected boolean enableSmartCache;
    private XmlOptions loadXmlOptions;

    public AXmlSnapshotRepository(Class<Xml> xmlBeanClass, DatabaseManager<Xml> manager) {
        this.xmlBeanClass = xmlBeanClass;
        this.manager = manager;
        this.name = manager.getDatabaseName();
        this.saveListeners = new CopyOnWriteArrayList();
        this.relatedCacheList = new HashSet<String>();
        this.managerInitialized = false;
        this.enableSmartCache = false;
    }

    public String getBaseContext() {
        return this.manager.getDefaultContext();
    }

    public boolean contains(String id) {
        try {
            String result = this.executeQuery(this.getDatabaseManager().buildContainsXQuery(id), this.getCommandExecutor());
            return Boolean.parseBoolean(result);
        }
        catch (BaseXException e) {
            throw new RuntimeException(e);
        }
    }

    public Xml get(String id) throws ObjectNotFoundException {
        this.logger.debug((Object)("Getting XML object: " + id));
        Cache<Xml> cache = this.getDatabaseManager().getCache();
        if (cache.contains(id)) {
            return (Xml)((XmlObject)cache.get(id));
        }
        try {
            String result = this.executeQuery(this.getDatabaseManager().buildSelectXQuery(id), this.getCommandExecutor());
            return this.processGetResult(id, result);
        }
        catch (BaseXException e) {
            throw new RuntimeException(e);
        }
    }

    protected Xml processGetResult(String id, String result) throws ObjectNotFoundException {
        try {
            Cache<Xml> cache = this.getDatabaseManager().getCache();
            if (result.isEmpty()) {
                throw new ObjectNotFoundException(new String[]{id});
            }
            Xml xml = this.parseResult(result);
            cache.add((Object)XmlObjectCaster.cast(this.xmlBeanClass, xml));
            if (this.enableSmartCache) {
                new Thread(new SmartCacher(this, xml)).start();
            }
            return xml;
        }
        catch (XmlException e) {
            throw new RuntimeException(e);
        }
    }

    public java.util.Set<Xml> get(java.util.Set<String> ids) throws ObjectNotFoundException {
        this.logger.debug((Object)("Getting XML object: " + Arrays.toString(ids.toArray())));
        DatabaseManager<Xml> manager = this.getDatabaseManager();
        Cache<Xml> cache = manager.getCache();
        HashSet<Object> results = new HashSet<Object>();
        HashSet<String> checkIds = new HashSet<String>(ids);
        for (String id : new HashSet<String>(ids)) {
            if (!cache.contains(id)) continue;
            results.add((XmlObject)cache.get(id));
            checkIds.remove(id);
        }
        if (checkIds.size() > 0) {
            try {
                String result = this.executeQuery(manager.buildSelectXQuery(checkIds), this.getCommandExecutor());
                results.addAll(this.processGetResults(checkIds, result));
            }
            catch (BaseXException e) {
                throw new RuntimeException(e);
            }
        }
        return results;
    }

    protected java.util.Set<Xml> processGetResults(java.util.Set<String> checkIds, String result) throws ObjectNotFoundException {
        try {
            HashSet<Xml> results = new HashSet<Xml>();
            results.addAll(this.parseResultSet(ResultSetDocument.Factory.parse((String)result)));
            for (XmlObject xml : results) {
                checkIds.remove(this.manager.getId(xml));
            }
            if (!checkIds.isEmpty()) {
                throw new ObjectNotFoundException(checkIds.toArray(new String[0]));
            }
            return results;
        }
        catch (XmlException e) {
            throw new RuntimeException(e);
        }
    }

    public SearchResult query(String contextId, Criteria<?> criteria) throws InvalidCriteriaException {
        this.logger.debug((Object)"Searching based on criteria");
        try {
            String result = this.executeQuery(this.getDatabaseManager().buildSearchXQuery(contextId, criteria), this.getCommandExecutor());
            SearchResultDocument results = SearchResultDocument.Factory.parse((String)result);
            this.logger.debug((Object)"Results:");
            this.logger.debug((Object)results.xmlText());
            ArrayList<ResultImpl> resultItems = new ArrayList<ResultImpl>();
            for (ResultType resultXml : results.getSearchResult().getResultList()) {
                resultItems.add(new ResultImpl(resultXml.getId(), resultXml.getName(), XhtmlUtilities.getMixedContent((XmlObject)resultXml.getDetail())));
            }
            return new SearchResultImpl(true, resultItems.toArray(new Result[0]));
        }
        catch (BaseXException e) {
            throw new RuntimeException(e);
        }
        catch (XmlException e) {
            throw new RuntimeException(e);
        }
    }

    public synchronized String save(String contextId, java.util.Set<Xml> additions, java.util.Set<Xml> updates, java.util.Set<Xml> deletions) throws StoreException {
        return this._save(contextId, additions, updates, deletions, null);
    }

    public synchronized String save(String contextId, java.util.Set<Xml> additions, java.util.Set<Xml> updates, java.util.Set<Xml> deletions, String comment) throws StoreException {
        comment = comment == null ? "" : comment;
        return this._save(contextId, additions, updates, deletions, comment);
    }

    public Xml getSnapshot(String snapshotId, String id) throws ObjectNotFoundException {
        this.logger.debug((Object)("Getting historical XML object: " + id + "(" + snapshotId + ")"));
        try {
            String result = this.executeQuery(this.getDatabaseManager().buildSnapshotXQuery(snapshotId, id), this.getCommandExecutor());
            if (result.isEmpty()) {
                throw new ObjectNotFoundException(new String[]{id});
            }
            return this.parseResult(result);
        }
        catch (BaseXException e) {
            throw new RuntimeException(e);
        }
        catch (XmlException e) {
            throw new RuntimeException(e);
        }
    }

    public void restoreSnapshot(String snapshotId, String ... itemIds) {
        this.logger.debug((Object)("Restoring snapshots: " + snapshotId + " " + Arrays.toString(itemIds)));
        DatabaseManager<Xml> manager = this.getDatabaseManager();
        try {
            this.executeQuery(manager.buildRestoreXQuery(snapshotId, itemIds), this.getCommandExecutor());
            manager.resetCache();
        }
        catch (BaseXException e) {
            throw new RuntimeException(e);
        }
    }

    public SnapshotHistory getSnapshotHistory() {
        this.logger.debug((Object)"Getting History.");
        try {
            String result = this.executeQuery(this.getDatabaseManager().buildSnapshotHistoryXQuery(), this.getCommandExecutor());
            SnapshotHistoryDocument xml = SnapshotHistoryDocument.Factory.parse((String)result);
            return new XmlSnapshotHistory(xml);
        }
        catch (BaseXException e) {
            throw new RuntimeException(e);
        }
        catch (XmlException e) {
            throw new RuntimeException(e);
        }
    }

    public void addSaveListener(SaveListener saveListener) {
        if (!this.saveListeners.contains(saveListener)) {
            this.saveListeners.add(saveListener);
        }
    }

    public void removeSaveListener(SaveListener saveListener) {
        this.saveListeners.remove(saveListener);
    }

    public void setEnableSmartCache(boolean enable) {
        this.enableSmartCache = enable;
    }

    public void setLoadXmlOptions(XmlOptions loadXmlOptions) {
        if (this.loadXmlOptions != null && !this.loadXmlOptions.equals(loadXmlOptions)) {
            throw new RuntimeException("LoadXmlOptions cannot be reset.");
        }
        this.loadXmlOptions = loadXmlOptions;
    }

    protected abstract CommandExecutor getCommandExecutor();

    protected final String getDatabaseName() {
        if (this.name == null) {
            this.name = "DB";
        }
        return this.name;
    }

    protected final DatabaseManager<Xml> getDatabaseManager() {
        if (this.manager == null) {
            throw new RuntimeException("DatabaseManager has not been set.");
        }
        if (!this.managerInitialized) {
            this.initializeManager();
        }
        return this.manager;
    }

    protected final XmlOptions getLoadXmlOptions() {
        if (this.loadXmlOptions == null) {
            this.loadXmlOptions = new XmlOptions();
        }
        return this.loadXmlOptions;
    }

    protected String executeQuery(String xQuery, CommandExecutor executor) throws BaseXException {
        this.logger.debug((Object)("Building XQuery:\n" + xQuery));
        return executor.executeCommand((Command)new XQuery(xQuery));
    }

    protected Xml parseResult(String result) throws XmlException {
        XmlObject xml = XmlObject.Factory.parse((String)result);
        if (XmlObjectCaster.canCast(this.xmlBeanClass, (XmlObject)xml, (boolean)false)) {
            return (Xml)((XmlObject)this.xmlBeanClass.cast(XmlObjectCaster.cast(this.xmlBeanClass, (XmlObject)xml)));
        }
        throw new RuntimeException("Retrieved object type (" + xml.schemaType().toString() + ") cannot be cast to the expect target type (" + this.xmlBeanClass.getCanonicalName() + ")");
    }

    protected Xml parseResult(Node result) throws XmlException {
        return (Xml)((XmlObject)this.xmlBeanClass.cast(XmlObjectCaster.cast(this.xmlBeanClass, (XmlObject)XmlObject.Factory.parse((Node)result))));
    }

    protected void cache(Xml xml) {
        this.getDatabaseManager().getCache().add(xml);
    }

    protected java.util.Set<Xml> parseResultSet(ResultSetDocument result) throws XmlException {
        this.logger.debug((Object)"Parsing result set: ");
        this.logger.debug((Object)result.xmlText(new XmlOptions().setSavePrettyPrint()));
        LinkedHashSet<Xml> results = new LinkedHashSet<Xml>();
        NodeList nodes = result.getResultSet().getDomNode().getChildNodes();
        int i = 0;
        while (i < nodes.getLength()) {
            Node node = nodes.item(i);
            if (node.getNodeType() == 1) {
                results.add(this.parseResult(node));
            }
            ++i;
        }
        return results;
    }

    protected synchronized String _save(String contextId, java.util.Set<Xml> additions, java.util.Set<Xml> updates, java.util.Set<Xml> deletions, String comment) throws StoreException {
        DatabaseManager<XmlObject> manager = this.getDatabaseManager();
        Cache<Xml> cache = manager.getCache();
        String transactionId = UUID.randomUUID().toString();
        ArrayList<String> ids = new ArrayList<String>();
        ArrayList<String> deleteIds = new ArrayList<String>();
        CommandExecutor executor = this.getCommandExecutor();
        try {
            executor.executeCommand((Command)new Open(this.getDatabaseName()));
            executor.executeCommand((Command)new Set((Object)Prop.AUTOFLUSH, (Object)false));
            executor.executeCommand((Command)new Set((Object)Prop.CHOP, (Object)false));
            for (XmlObject xml : additions) {
                this.executeQuery(manager.buildUpdateXQuery(transactionId, contextId, xml, DatabaseManager.Action.ADD), executor);
                ids.add(manager.getId(xml));
                cache.add((Object)XmlObjectCaster.cast(this.xmlBeanClass, (XmlObject)xml));
            }
            for (XmlObject xml : updates) {
                this.executeQuery(manager.buildUpdateXQuery(transactionId, contextId, xml, DatabaseManager.Action.UPDATE), executor);
                ids.add(manager.getId(xml));
                cache.add((Object)XmlObjectCaster.cast(this.xmlBeanClass, (XmlObject)xml));
            }
            for (XmlObject xml : deletions) {
                this.executeQuery(manager.buildUpdateXQuery(transactionId, contextId, xml, DatabaseManager.Action.DELETE), executor);
                ids.add(manager.getId(xml));
                deleteIds.add(manager.getId(xml));
                cache.remove((Object)xml);
            }
            executor.executeCommand((Command)new Flush());
            executor.executeCommand((Command)new Close());
            if (comment == null) {
                this.executeQuery(manager.buildCommitXQuery(transactionId, false), executor);
            } else {
                SnapshotDocument snapshot = SnapshotDocument.Factory.newInstance();
                snapshot.addNewSnapshot();
                snapshot.getSnapshot().setId2(transactionId);
                snapshot.getSnapshot().setDate(Calendar.getInstance());
                snapshot.getSnapshot().setComment(comment);
                for (String id : ids) {
                    if (deleteIds.contains(id)) continue;
                    snapshot.getSnapshot().addId(id);
                }
                this.executeQuery(manager.buildAddSnapshotInformation(transactionId, snapshot), executor);
                this.executeQuery(manager.buildCommitXQuery(transactionId, true), executor);
            }
            new Thread(new Notifier((SaveEvent)new SaveEventImpl(transactionId, ids.toArray(new String[0])))).start();
            String string = transactionId;
            return string;
        }
        catch (BaseXException bxe) {
            this.logger.error((Object)bxe);
            try {
                this.executeQuery(manager.buildRollbackXQuery(transactionId), executor);
                executor.executeCommand((Command)new Flush());
            }
            catch (BaseXException e) {
                this.logger.error((Object)e);
            }
            throw new StoreException((Exception)((Object)bxe));
        }
        finally {
            executor.executeCommand((Command)new Close());
        }
    }

    protected void load(java.util.Set<Xml> items) {
        CommandExecutor executor = this.getCommandExecutor();
        DatabaseManager<XmlObject> manager = this.getDatabaseManager();
        Cache<Xml> cache = manager.getCache();
        String transactionId = UUID.randomUUID().toString();
        try {
            try {
                executor.executeCommand((Command)new Open(this.getDatabaseName()));
                executor.executeCommand((Command)new Set((Object)Prop.AUTOFLUSH, (Object)false));
                for (XmlObject xml : items) {
                    this.executeQuery(manager.buildUpdateXQuery(transactionId, this.getBaseContext(), xml, DatabaseManager.Action.ADD), executor);
                    cache.add((Object)XmlObjectCaster.cast(this.xmlBeanClass, (XmlObject)xml));
                }
                executor.executeCommand((Command)new Flush());
                this.executeQuery(manager.buildCommitXQuery(transactionId, false), executor);
                this.executeQuery("db:optimize('" + this.getDatabaseName() + "',true())", executor);
            }
            catch (BaseXException bxe) {
                this.logger.error((Object)bxe);
                try {
                    this.executeQuery(manager.buildRollbackXQuery(transactionId), executor);
                    executor.executeCommand((Command)new Flush());
                }
                catch (BaseXException e) {
                    this.logger.error((Object)e);
                }
                throw new RuntimeException(bxe);
            }
        }
        finally {
            executor.executeCommand((Command)new Close());
        }
    }

    protected void clear(java.util.Set<Xml> items) {
        CommandExecutor executor = this.getCommandExecutor();
        DatabaseManager<XmlObject> manager = this.getDatabaseManager();
        Cache<Xml> cache = manager.getCache();
        String transactionId = UUID.randomUUID().toString();
        try {
            try {
                executor.executeCommand((Command)new Open(this.getDatabaseName()));
                executor.executeCommand((Command)new Set((Object)Prop.AUTOFLUSH, (Object)false));
                for (XmlObject xml : items) {
                    this.executeQuery(manager.buildUpdateXQuery(transactionId, this.getBaseContext(), xml, DatabaseManager.Action.DELETE), executor);
                    cache.add((Object)XmlObjectCaster.cast(this.xmlBeanClass, (XmlObject)xml));
                }
                executor.executeCommand((Command)new Flush());
                this.executeQuery(manager.buildCommitXQuery(transactionId, false), executor);
                this.executeQuery("db:optimize('" + this.getDatabaseName() + "',true())", executor);
            }
            catch (BaseXException bxe) {
                this.logger.error((Object)bxe);
                try {
                    this.executeQuery(manager.buildRollbackXQuery(transactionId), executor);
                    executor.executeCommand((Command)new Flush());
                }
                catch (BaseXException e) {
                    this.logger.error((Object)e);
                }
                throw new RuntimeException(bxe);
            }
        }
        finally {
            executor.executeCommand((Command)new Close());
        }
    }

    final boolean peformRelatedObjectCache(String id) {
        return !this.relatedCacheList.contains(id);
    }

    final void notifyRelatedObjectCaching(Xml xml) {
        this.relatedCacheList.add(this.getDatabaseManager().getId(xml));
    }

    private void initializeManager() {
        try {
            String result = this.executeQuery(this.manager.buildContextListQuery(), this.getCommandExecutor());
            SearchResultDocument results = SearchResultDocument.Factory.parse((String)result);
            this.manager.populateContexts(results);
            this.managerInitialized = true;
        }
        catch (BaseXException e) {
            throw new RuntimeException(e);
        }
        catch (XmlException e) {
            throw new RuntimeException(e);
        }
    }

    private synchronized void raiseSaveEvent(SaveEvent saveEvent) {
        for (SaveListener saveListener : this.saveListeners) {
            saveListener.notifySave(saveEvent);
        }
    }

    public Catalog getCatalog() {
        try {
            DatabaseManager<Xml> manager = this.getDatabaseManager();
            CatalogDocument catalog = (CatalogDocument)manager.getDefaultCatalog().copy();
            HashMap<String, NodeType> nodeMap = new HashMap<String, NodeType>();
            HashMap<String, LevelType> levelMap = new HashMap<String, LevelType>();
            String result = this.executeQuery(manager.buildRawCatalogXQuery(), this.getCommandExecutor());
            CatalogDocument raw = CatalogDocument.Factory.parse((String)result);
            for (LevelType level : catalog.getCatalog().getLevelList()) {
                this.mapLevel(level, levelMap, nodeMap);
            }
            for (NodeType node : catalog.getCatalog().getNodeList()) {
                this.mapNode(node, levelMap, nodeMap);
            }
            for (LevelType level : raw.getCatalog().getLevelList()) {
                if (levelMap.containsKey(level.getContextId())) {
                    this.mergeLevel(level, levelMap, nodeMap);
                    continue;
                }
                catalog.getCatalog().getLevelList().add(level);
            }
            for (NodeType node : raw.getCatalog().getNodeList()) {
                if (nodeMap.containsKey(node.getContextId())) {
                    this.mergeNode(node, levelMap, nodeMap);
                    continue;
                }
                catalog.getCatalog().getNodeList().add(node);
            }
            return new XmlCatalog(catalog);
        }
        catch (BaseXException e) {
            throw new RuntimeException(e);
        }
        catch (XmlException e) {
            throw new RuntimeException(e);
        }
    }

    private void mapLevel(LevelType level, Map<String, LevelType> levelMap, Map<String, NodeType> nodeMap) {
        levelMap.put(level.getContextId(), level);
        for (LevelType child : level.getLevelList()) {
            this.mapLevel(child, levelMap, nodeMap);
        }
        for (LevelType child : level.getNodeList()) {
            this.mapNode((NodeType)child, levelMap, nodeMap);
        }
    }

    private void mergeLevel(LevelType level, Map<String, LevelType> levelMap, Map<String, NodeType> nodeMap) {
        LevelType merge = levelMap.get(level.getContextId());
        for (LevelType child : level.getLevelList()) {
            if (levelMap.containsKey(child.getContextId())) {
                this.mergeLevel(child, levelMap, nodeMap);
            }
            merge.getLevelList().add(child);
        }
        for (LevelType child : level.getNodeList()) {
            if (nodeMap.containsKey(child.getId())) {
                this.mergeNode((NodeType)child, levelMap, nodeMap);
            }
            merge.getNodeList().add(child);
        }
    }

    private void mergeNode(NodeType node, Map<String, LevelType> levelMap, Map<String, NodeType> nodeMap) {
        NodeType merge = nodeMap.get(node.getId());
        for (LevelType child : node.getLevelList()) {
            if (levelMap.containsKey(child.getContextId())) {
                this.mergeLevel(child, levelMap, nodeMap);
            }
            merge.getLevelList().add(child);
        }
        for (LevelType child : node.getNodeList()) {
            if (nodeMap.containsKey(child.getId())) {
                this.mergeNode((NodeType)child, levelMap, nodeMap);
            }
            merge.getNodeList().add(child);
        }
    }

    private void mapNode(NodeType node, Map<String, LevelType> levelMap, Map<String, NodeType> nodeMap) {
        nodeMap.put(node.getId(), node);
        for (LevelType child : node.getLevelList()) {
            this.mapLevel(child, levelMap, nodeMap);
        }
        for (LevelType child : node.getNodeList()) {
            this.mapNode((NodeType)child, levelMap, nodeMap);
        }
    }

    private final class Notifier
    implements Runnable {
        private final SaveEvent saveEvent;

        private Notifier(SaveEvent saveEvent) {
            this.saveEvent = saveEvent;
        }

        @Override
        public void run() {
            AXmlSnapshotRepository.this.raiseSaveEvent(this.saveEvent);
        }
    }

    public static final class SmartCacher
    implements Runnable {
        private final Xml xml;
        final /* synthetic */ AXmlSnapshotRepository this$0;

        public SmartCacher(Xml xml) {
            this.this$0 = var1_1;
            this.xml = xml;
        }

        @Override
        public synchronized void run() {
            DatabaseManager manager = this.this$0.getDatabaseManager();
            String id = manager.getId(this.xml);
            if (this.this$0.peformRelatedObjectCache(id)) {
                this.this$0.notifyRelatedObjectCaching(this.xml);
                this.this$0.logger.debug((Object)("Caching related objects for: " + id));
                try {
                    String result = this.this$0.executeQuery(manager.buildRelatedObjectXQuery(id), this.this$0.getCommandExecutor());
                    Cache cache = manager.getCache();
                    for (XmlObject xml : this.this$0.parseResultSet(ResultSetDocument.Factory.parse((String)result))) {
                        cache.add((Object)XmlObjectCaster.cast(this.this$0.xmlBeanClass, (XmlObject)xml));
                        this.this$0.notifyRelatedObjectCaching(xml);
                    }
                }
                catch (XmlException xe) {
                    this.this$0.logger.error((Object)xe);
                    throw new RuntimeException(xe);
                }
                catch (BaseXException bxe) {
                    this.this$0.logger.error((Object)bxe);
                    throw new RuntimeException(bxe);
                }
            }
        }
    }
}

