/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.store.catalog.xml;

import java.util.ArrayList;
import org.apache.xmlbeans.XmlObject;
import org.openmetadata.store.catalog.CatalogItem;
import org.openmetadata.store.catalog.Level;
import org.openmetadata.store.catalog.Node;
import org.openmetadata.store.catalog.xml.XmlLevel;
import org.openmetadata.store.catalog.xml.XmlNode;
import org.openmetadata.store.xml.xmlbeans.catalog.CatalogItemType;
import org.openmetadata.store.xml.xmlbeans.catalog.LevelType;
import org.openmetadata.store.xml.xmlbeans.catalog.NodeType;
import org.openmetadata.util.xmlbeans.XhtmlUtilities;

public abstract class XmlCatalogItem
implements CatalogItem {
    private final Level parentLevel;
    private final Node parentNode;
    private final boolean isContext;
    private final String contextId;
    private final String name;
    private final String description;
    private final ArrayList<Node> nodes;
    private final ArrayList<Level> levels;

    protected XmlCatalogItem(CatalogItemType item, CatalogItem parent) {
        if (parent == null) {
            this.parentNode = null;
            this.parentLevel = null;
        } else {
            this.parentNode = parent instanceof Node ? (Node)parent : null;
            this.parentLevel = parent instanceof Level ? (Level)parent : null;
        }
        this.isContext = item.getIsContext();
        this.contextId = item.getContextId();
        this.name = item.getName();
        this.description = item.isSetDescription() ? XhtmlUtilities.getMixedContent((XmlObject)item.getDescription()) : "";
        this.nodes = new ArrayList();
        this.levels = new ArrayList();
        for (NodeType child : item.getNodeList()) {
            this.nodes.add(new XmlNode(child, (CatalogItem)this));
        }
        for (LevelType level : item.getLevelList()) {
            this.levels.add(new XmlLevel(level, (CatalogItem)this));
        }
    }

    public boolean isContext() {
        return this.isContext;
    }

    public String getContextId() {
        return this.contextId;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Node[] getNodes() {
        return this.nodes.toArray(new Node[0]);
    }

    public Level[] getLevels() {
        return this.levels.toArray(new Level[0]);
    }

    public boolean hasParentNode() {
        return this.parentNode != null;
    }

    public Node getParentNode() {
        return this.parentNode;
    }

    public boolean hasParentLevel() {
        return this.parentLevel != null;
    }

    public Level getParentLevel() {
        return this.parentLevel;
    }
}

