/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.dmp.ws.repository;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlOptions;
import org.basex.core.Command;
import org.basex.core.cmd.Close;
import org.basex.core.cmd.Open;
import org.openmetadata.dmp.store.repository.basex.DmpBaseXRepository;
import org.openmetadata.dmp.store.repository.basex.DmpDatabaseManager;
import org.openmetadata.dmp.ws.repository.DmpSharedDatabaseManager;
import org.openmetadata.store.repository.basex.CommandExecutor;
import org.openmetadata.store.repository.basex.impl.SessionCommandExecutor;
import org.openmetadata.store.repository.basex.impl.SessionConfiguration;
import org.openmetadata.store.xml.xmlbeans.catalog.CatalogDocument;
import org.openmetadata.store.xml.xmlbeans.lock.LockInformationType;
import org.openmetadata.store.xml.xmlbeans.result.ResultSetDocument;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DmpSharedBaseXRepository
extends DmpBaseXRepository {
    protected Log logger = LogFactory.getLog(this.getClass());
    private SessionConfiguration sessionConfiguration;
    private final DmpSharedDatabaseManager manager;

    public DmpSharedBaseXRepository(DmpSharedDatabaseManager manager) {
        super((DmpDatabaseManager)manager);
        this.manager = manager;
    }

    protected void optimizeDb() {
        new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
    }

    public LockInformationType getLock(String id) {
        try {
            String result = this.executeQuery(this.manager.buildGetLockXQuery(id), this.getCommandExecutor());
            if (result.isEmpty()) {
                return null;
            }
            return LockInformationType.Factory.parse((String)result);
        }
        catch (XmlException e) {
            this.logger.error((Object)e);
            throw new RuntimeException(e);
        }
    }

    public void addLock(LockInformationType xml) {
        CommandExecutor executor = this.getCommandExecutor();
        executor.executeCommand((Command)new Open(this.getDatabaseName()));
        this.executeQuery(this.manager.buildAddLockXQuery(xml), executor);
        executor.executeCommand((Command)new Close());
    }

    public void releaseLock(LockInformationType xml) {
        this.executeQuery(this.manager.buildRemoveLockXQuery(xml), this.getCommandExecutor());
    }

    public LockInformationType[] getAllLocks() {
        try {
            HashSet results = new HashSet();
            String result = this.executeQuery(this.manager.buildGetLocksXQuery(), this.getCommandExecutor());
            results.addAll(this.parseLocksResultSet(ResultSetDocument.Factory.parse((String)result)));
            return results.toArray(new LockInformationType[0]);
        }
        catch (XmlException e) {
            throw new RuntimeException(e);
        }
    }

    public CatalogDocument getXmlCatalog() {
        try {
            String result = this.executeQuery(this.manager.buildRawCatalogXQuery(), this.getCommandExecutor());
            return CatalogDocument.Factory.parse((String)result);
        }
        catch (XmlException e) {
            this.logger.error((Object)e);
            throw new RuntimeException(e);
        }
    }

    public void setSessionConfiguration(SessionConfiguration sessionConfiguration) {
        if (this.sessionConfiguration != null && !this.sessionConfiguration.equals(sessionConfiguration)) {
            throw new RuntimeException("Session Configuration cannot be reset.");
        }
        this.sessionConfiguration = sessionConfiguration;
    }

    protected synchronized CommandExecutor getCommandExecutor() {
        return new SessionCommandExecutor(this.getSessionConfiguration());
    }

    protected SessionConfiguration getSessionConfiguration() {
        if (this.sessionConfiguration == null) {
            this.logger.debug((Object)"Session Configuration not set;  default implementation will be used.");
            this.sessionConfiguration = new SessionConfiguration();
        }
        return this.sessionConfiguration;
    }

    protected Set<LockInformationType> parseLocksResultSet(ResultSetDocument result) throws XmlException {
        this.logger.debug((Object)"Parsing result set: ");
        this.logger.debug((Object)result.xmlText(new XmlOptions().setSavePrettyPrint()));
        LinkedHashSet<LockInformationType> results = new LinkedHashSet<LockInformationType>();
        NodeList nodes = result.getResultSet().getDomNode().getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (node.getNodeType() != 1) continue;
            results.add(LockInformationType.Factory.parse((Node)node));
        }
        return results;
    }

    static /* synthetic */ String access$000(DmpSharedBaseXRepository x0) {
        return x0.getDatabaseName();
    }
}

