<%@ page language="java" contentType="text/html; charset=UTF-8"
	pageEncoding="UTF-8"%>
<%@ page import="java.io.*"%>
<%@ page import="java.util.*"%>
<%@ page import="org.openmetadata.xml.core.*"%>
<%@ page import="org.openmetadata.xml.report.*"%>
<%@ page import="org.openmetadata.xml.report.definition.*"%>
<%@ page import="org.openmetadata.util.xmlbeans.*"%>
<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<link rel="stylesheet" type="text/css" href="resources/css/dmp.css"/>
<link href="//ajax.googleapis.com/ajax/libs/jqueryui/1.8/themes/base/jquery-ui.css" rel="stylesheet" type="text/css"/>
<script src="//ajax.googleapis.com/ajax/libs/jquery/1.8/jquery.min.js">
</script>
<script src="//ajax.googleapis.com/ajax/libs/jqueryui/1.8/jquery-ui.min.js">
</script>
<script src="resources/js/dmp.js">
</script>
<title>MRC DMP Portal</title>
</head>
<body>
	<jsp:include page="menu.jsp" />
	<%
		org.openmetadata.xml.report.ReportDocument report = (org.openmetadata.xml.report.ReportDocument) request
				.getAttribute("report");
		org.openmetadata.xml.report.definition.ReportDocument definition = (org.openmetadata.xml.report.definition.ReportDocument) request
				.getAttribute("definition");
		Map<String, org.openmetadata.xml.report.definition.TopicType> topicMap = new HashMap<String, org.openmetadata.xml.report.definition.TopicType>();
		mapDefinitionTopics(definition.getReport().getTopicList(), topicMap);
		if (report!=null) {
			%>
			<h2 class="page-heading"><%= XhtmlUtilities.getMixedContent(report.getReport().getNameArray(0)) %></h2>
			<% 
				ContextualTextType abstractXml = null;
				for (ContextualTextType ctt : report.getReport().getDocumentationList()) {
					if (ctt.getType().equals("ABSTRACT")) {
						abstractXml = ctt;
						break;
					}
				}
				if(abstractXml!=null) {
			%>
			<div class="view-report-abstract">
			<h4 class="section-title">Abstract <a class="detail-toggle" id="abstract">[hide]</a></h4>
			<div class="contents"><%= XhtmlUtilities.getMixedContent(abstractXml) %></div>
			</div>
			<%							
				}

				for (org.openmetadata.xml.report.TopicType topic : report.getReport().getTopicList()) {
					out.print(buildTopic(topic, 1, topicMap));
				}
			}else if (definition!=null) {
				%>
				<h2 class="page-heading"><%= XhtmlUtilities.getMixedContent(definition.getReport().getNameArray(0)) %></h2>
				<% 
				if (definition.getReport().getDocumentationList().size()>0) {
					%>
					<div class="documentation">
					<h4 class="section-title">Documentation <a class="detail-toggle" id="abstract">[hide]</a></h4>
					<div class="contents">
					<%
						for (ContextualTextType ctt : definition.getReport().getDocumentationList()) {
					%>
						<table class="documentation">
							<thead><tr><th class="type"> <%= ctt.getType() %> </th></tr></thead>
							<tbody><tr><td class="text">
							<%= XhtmlUtilities.getMixedContent(ctt) %>
							</td></tr></tbody>
						</table>
					<%
						}
					%>
					</div>
					</div>
					<%
					}
					%>
				</div>
			</div>
			<%
			int topicNumber = 0;
			for (org.openmetadata.xml.report.definition.TopicType topic : definition.getReport().getTopicList()) {
				topicNumber++;
				out.print(buildDefinitionTopic(topic, String.valueOf(topicNumber)));
			}
		}
	%>

	<%!public String buildTopic(
			org.openmetadata.xml.report.TopicType topic,
			int level,
			Map<String, org.openmetadata.xml.report.definition.TopicType> topicMap) {
		org.openmetadata.xml.report.definition.TopicType definition = topicMap
				.get(topic.getTopicDefinition());
		ContextualTextType guidance = null;
		for (ContextualTextType ctt : definition.getDocumentationList()) {
			if (ctt.getType().equals("GUIDANCE")) {
				guidance = ctt;
				break;
			}
		}
		StringBuilder sb = new StringBuilder();
		String divClass = "view-report-"
				+ (topic.getType().equals(
						org.openmetadata.xml.report.TopicTypes.HEADING) ? "header"
						: "field");
		String topicId= topic.getId().replaceAll("\\.", "-").replaceAll(":","-");
		String definitionId = definition.getId().replaceAll("\\.", "-").replaceAll(":","-");
		sb.append("<div class=\"" + divClass + "\" id=\"" + topicId
				+ "\">\n");
		if (guidance != null) {
			sb.append("<div class=\"definition-guidance\" id=\"" + definitionId + "\">" + XhtmlUtilities.getMixedContent(guidance) + "</div>\n");
		}
		if (topic.getType().equals(
				org.openmetadata.xml.report.TopicTypes.HEADING)) {
			sb.append("<h2 class=\"name\">"
					+ XhtmlUtilities.getMixedContent(definition.getNameArray(0)) + (guidance!=null?" <a href=\""+definitionId+"\" class=\"guidance-link\">(?)</a>":"") + "</h2>\n");
			
			sb.append("<div class=\"section-content\">\n");
			for (org.openmetadata.xml.report.TopicType child : XmlObjectCaster
					.cast(org.openmetadata.xml.report.HeadingType.class, topic)
					.getTopicList()) {
				sb.append(buildTopic(child, level + 1, topicMap));
			}
			sb.append("</div>\n");
		} else {
			sb.append("<table class=\"view-report-field\">\n");
			sb.append("<thead><tr><th class=\"name\">" + XhtmlUtilities.getMixedContent(definition.getNameArray(0))  + (guidance!=null?" <a href=\""+definitionId+"\" class=\"guidance-link\">(?)</a>":"") +  "</th></tr></thead>\n");
			sb.append("<tbody><tr><td class=\"value\">\n");
			org.openmetadata.xml.report.FieldType field = XmlObjectCaster.cast(
					org.openmetadata.xml.report.FieldType.class, topic);
			if (field.getContentList().size()>0) {
				sb.append(XhtmlUtilities.getMixedContent(field
						.getContentArray(0)));				
			}
			sb.append("</td></tr></tbody>\n");
			sb.append("</table>\n");
		}
		sb.append("</div>\n");
		return sb.toString();
	}%>
	<%!public String buildDefinitionTopic(
			org.openmetadata.xml.report.definition.TopicType definition,
			String number) {
		String definitionId = definition.getId().replaceAll("\\.", "-").replaceAll(":","-");
		StringBuilder sb = new StringBuilder();
		String divClass = "view-definition-"
				+ (definition.getType().equals(
						org.openmetadata.xml.report.definition.TopicTypes.HEADING) ? "header"
						: "field");
		sb.append("<div class=\"" + divClass + "\" id=\"" + definitionId
				+ "\">");
		sb.append("<h2 class=\"name\">" + number + ")&nbsp;&nbsp;"
				+ XhtmlUtilities.getMixedContent(definition.getNameArray(0)) + "</h2>");
		sb.append("<div class=\"section-content\">");
		sb.append("<div class=\"occurs\">Occurs: ");
		sb.append(definition.isSetMinOccurs()?definition.getMinOccurs():"1");
		sb.append("..");
		sb.append(definition.isSetMaxOccurs()?(definition.getMaxOccurs().equals("unbounded")?"n":definition.getMaxOccurs()):"1");
		sb.append("</div>");
		if (definition.getType().equals(
				org.openmetadata.xml.report.definition.TopicTypes.FIELD)) {
			org.openmetadata.xml.report.definition.FieldType field = XmlObjectCaster.cast(
					org.openmetadata.xml.report.definition.FieldType.class, definition);
			sb.append("<div class=\"representation\">Representation: ");
			sb.append(field.isSetRepresentation()?field.getRepresentation():"string");
			sb.append("</div>");
		}
		if (definition.getDocumentationList().size()>0) {
			sb.append("<div class=\"documentation\">");
			sb.append("<h4 class=\"section-title\">Documentation <a class=\"detail-toggle\" id=\"abstract\">[hide]</a></h4>");
			sb.append("<div class=\"contents\">");
			for (ContextualTextType ctt : definition.getDocumentationList()) {
				sb.append("<table class=\"documentation\">");
				sb.append("<thead><tr><th class=\"type\">" + ctt.getType() + "</th></tr></thead>");
				sb.append("<tbody><tr><td class=\"text\">");
				sb.append(XhtmlUtilities.getMixedContent(ctt));				
				sb.append("</td></tr></tbody>");
				sb.append("</table>");				
			}
			sb.append("</div>");
			sb.append("</div>");
		}
		if (definition.getType().equals(
				org.openmetadata.xml.report.definition.TopicTypes.HEADING)) {
			int childNumber = 0;
			for (org.openmetadata.xml.report.definition.TopicType child : XmlObjectCaster
					.cast(org.openmetadata.xml.report.definition.HeadingType.class, definition)
					.getTopicList()) {
				childNumber++;
				sb.append(buildDefinitionTopic(child, number + "." + childNumber));
			}
		}
		sb.append("</div>");
		sb.append("</div>");
		return sb.toString();
	}%>
	<%!public void mapDefinitionTopics(
			List<org.openmetadata.xml.report.definition.TopicType> topics,
			Map<String, org.openmetadata.xml.report.definition.TopicType> topicMap) {
		for (org.openmetadata.xml.report.definition.TopicType topic : topics) {
			topicMap.put(topic.getId(), topic);
			mapDefinitionTopics(topic.getTopicList(), topicMap);
		}
	}%>
</body>
</html>
