<%@ page language="java" contentType="text/html; charset=UTF-8"
	pageEncoding="UTF-8"%>
<%@ page import="java.io.*"%>
<%@ page import="org.openmetadata.store.catalog.*"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<link rel="stylesheet" type="text/css" href="resources/css/dmp.css" />
<script src="//ajax.googleapis.com/ajax/libs/jquery/1.8/jquery.min.js">
	
</script>
<script src="<c:url value="/portal/resources/js/dmp.js"/>"></script>
<title>Data Management Plan Catalog</title>
</head>
<body>
	<jsp:include page="menu.jsp" />
	<h2 class="page-heading">Portal Catalog</h2>
	<c:forEach items="${catalog.getLevels()}" var="level">
		<c:if test="${not empty level.getNodes()}">
			<div class="catalog-level">

				<h3 class="name">
					${level.getName().getDefault().getValue()} <a class="detail-toggle">[hide]</a>
				</h3>
				<div class="contents">
					<c:forEach items="${level.getNodes()}" var="node">
						<div id="${node.getPrimaryIdentifier()}" class="node">
							<a class="name"
								href="<c:url value="/portal/view?urn=${node.getPrimaryIdentifier()}"/>">${node.getName().getDefault().getValue()}</a>
							<a
								href="<c:url value="/services/${node.getPrimaryIdentifier()}"/>"
								class="search-result-link-xml" target="_new">[open xml]</a>
							<div class="description">${node.getDescription().getDefault().getValue()}</div>
						</div>

					</c:forEach>
				</div>
			</div>
		</c:if>
	</c:forEach>
</body>
</html>