/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.dmp.ws.repository;

import org.apache.xmlbeans.XmlOptions;
import org.openmetadata.dmp.store.repository.basex.DmpDatabaseManager;
import org.openmetadata.dmp.ws.DmpSharedBaseXConfiguration;
import org.openmetadata.store.xml.xmlbeans.lock.LockInformationType;

public class DmpSharedDatabaseManager
extends DmpDatabaseManager {
    protected final String LOCKS = "locks";

    public DmpSharedDatabaseManager(DmpSharedBaseXConfiguration config) {
        super(config.getDb());
    }

    public String buildAddLockXQuery(LockInformationType xml) {
        StringBuilder sb = new StringBuilder();
        sb.append("db:add('" + this.DB + "'");
        sb.append(",document { " + xml.xmlText(new XmlOptions().setSaveOuter()) + " }");
        sb.append(",'locks'");
        sb.append(")");
        return sb.toString();
    }

    public String buildGetLockXQuery(String id) {
        StringBuilder sb = new StringBuilder();
        sb.append("declare namespace lock = \"http://openmetadata.org/store/lock\";\n");
        sb.append("db:open('" + this.DB + "','" + "locks" + "')/*[lock:ObjectURN='" + id + "']");
        return sb.toString();
    }

    public String buildRemoveLockXQuery(LockInformationType xml) {
        StringBuilder sb = new StringBuilder();
        sb.append("declare namespace lock = \"http://openmetadata.org/store/lock\";\n");
        sb.append("delete node db:open('" + this.DB + "','" + "locks" + "')/*[lock:ObjectURN='" + xml.getObjectURN() + "']");
        return sb.toString();
    }

    public String buildGetLocksXQuery() {
        StringBuilder sb = new StringBuilder();
        sb.append("let $results:= db:open('" + this.DB + "','" + "locks" + "')/*\n");
        sb.append("return\n");
        sb.append("<ResultSet xmlns=\"http://openmetadata.org/store/result\">\n");
        sb.append("{for $result in $results return $result}\n");
        sb.append("</ResultSet>\n");
        return sb.toString();
    }
}

