/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.dmp.portal;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlbeans.XmlError;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.openmetadata.dmp.portal.PortalController;
import org.openmetadata.dmp.portal.upload.FileUpload;
import org.openmetadata.dmp.ws.repository.DmpSharedBaseXRepository;
import org.openmetadata.dmp.xml.utilities.ReportValidator;
import org.openmetadata.dmp.xml.utilities.XmlUpgrader;
import org.openmetadata.store.catalog.Catalog;
import org.openmetadata.store.exceptions.InvalidCriteriaException;
import org.openmetadata.store.exceptions.ObjectNotFoundException;
import org.openmetadata.store.exceptions.StoreException;
import org.openmetadata.store.query.Criteria;
import org.openmetadata.store.query.SearchResult;
import org.openmetadata.store.query.TextSearch;
import org.openmetadata.store.query.impl.TextSearchImpl;
import org.openmetadata.util.xmlbeans.XmlObjectCaster;
import org.openmetadata.xml.report.ReportDocument;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.validation.ObjectError;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.commons.CommonsMultipartFile;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class PortalController {
    protected Log logger = LogFactory.getLog(this.getClass());
    private DmpSharedBaseXRepository repository;
    private SearchResult result;

    @RequestMapping(method={RequestMethod.GET}, value={"/search"})
    public String search(Model model, HttpServletRequest request, @RequestParam(required=false) String text, @RequestParam(required=false) String scope, @RequestParam(required=false) String page) throws InvalidCriteriaException {
        String string = scope = scope == null || scope.equals("all") ? this.repository.getBaseContext() : scope;
        if (page == null && text != null) {
            this.result = this.repository.query(scope, (Criteria)new TextSearchCriteria(this, (TextSearch)new TextSearchImpl(new HashSet(), new HashSet(), text)));
            request.getSession().setAttribute("result", (Object)this.result);
        } else if (page == null) {
            System.out.println("=============clear attribute==================");
            request.getSession().removeAttribute("result");
            this.result = null;
        }
        return "search";
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/catalog"})
    public String getCatalog(Model model, HttpServletRequest request) {
        Catalog catalog = this.repository.getCatalog();
        model.addAttribute("catalog", (Object)catalog);
        return "catalog";
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/view"})
    public String view(Model model, HttpServletRequest request, @RequestParam String urn) throws ObjectNotFoundException {
        XmlObject xml = this.repository.get(urn);
        XmlObject definition = null;
        if (XmlObjectCaster.canCast(ReportDocument.class, (XmlObject)xml, (boolean)false)) {
            ReportDocument report = (ReportDocument)XmlObjectCaster.cast(ReportDocument.class, (XmlObject)xml);
            model.addAttribute("report", (Object)report);
            definition = this.repository.get(report.getReport().getDefinition().getId());
        } else if (XmlObjectCaster.canCast(org.openmetadata.xml.report.definition.ReportDocument.class, (XmlObject)xml, (boolean)false)) {
            definition = xml;
        }
        if (definition != null) {
            model.addAttribute("definition", (Object)XmlObjectCaster.cast(org.openmetadata.xml.report.definition.ReportDocument.class, (XmlObject)definition));
        }
        return "view";
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/{page}"})
    public String getPage(@PathVariable String page) {
        return page;
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/upload"})
    public String getUploadPage(Model model) {
        FileUpload uploadItem = new FileUpload();
        if (!model.containsAttribute("fileUpload")) {
            model.addAttribute("fileUpload", (Object)uploadItem);
        }
        return "upload";
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/upload"})
    public ModelAndView uploadFile(@ModelAttribute FileUpload fileUpload, BindingResult result) {
        ModelAndView mav = new ModelAndView("upload");
        mav.setViewName("upload");
        mav.addObject("fileUpload", (Object)fileUpload);
        ArrayList<String> errors = new ArrayList<String>();
        if (result.hasErrors()) {
            for (ObjectError error : result.getAllErrors()) {
                String msg = "Binding Error: " + error.getCode() + " - " + error.getDefaultMessage();
                this.logger.error((Object)msg);
                errors.add(msg);
            }
            mav.addObject("errors", errors);
            return mav;
        }
        CommonsMultipartFile file = fileUpload.getFile();
        mav.addObject("fileName", (Object)file.getOriginalFilename());
        XmlObject xml = null;
        try {
            xml = XmlObject.Factory.parse((InputStream)file.getInputStream(), (XmlOptions)new XmlOptions().setLoadLineNumbers());
            if (XmlObjectCaster.canCast(org.openmetadata.xml.report.definition.ReportDocument.class, (XmlObject)xml, (boolean)false)) {
                org.openmetadata.xml.report.definition.ReportDocument definition = (org.openmetadata.xml.report.definition.ReportDocument)XmlObjectCaster.cast(org.openmetadata.xml.report.definition.ReportDocument.class, (XmlObject)xml);
                if (this.validateDefinition(definition, errors, fileUpload.isForceUpdate())) {
                    this.uploadObject((XmlObject)definition);
                }
            } else if (XmlObjectCaster.canCast(ReportDocument.class, (XmlObject)xml, (boolean)false)) {
                ReportDocument plan = (ReportDocument)XmlObjectCaster.cast(ReportDocument.class, (XmlObject)xml);
                if (this.validatePlan(plan, errors, fileUpload.isForceUpdate())) {
                    this.uploadObject((XmlObject)plan);
                }
            } else {
                errors.add("Upload is not a DMP definition or a plan.");
            }
        }
        catch (XmlException e) {
            this.logger.error((Object)e);
            errors.add("File could not be parsed as XML: " + e.getMessage());
        }
        catch (IOException e) {
            this.logger.error((Object)e);
            errors.add("File could not be parsed as XML: " + e.getMessage());
        }
        catch (StoreException e) {
            this.logger.error((Object)e);
            errors.add("Save operation failed: " + e.getMessage());
        }
        mav.addObject("success", (Object)errors.isEmpty());
        mav.addObject("errors", errors);
        if (xml != null) {
            mav.addObject("xml", (Object)xml.xmlText(new XmlOptions().setSavePrettyPrint()));
        }
        return mav;
    }

    public void setRepository(DmpSharedBaseXRepository repository) {
        this.repository = repository;
    }

    protected void uploadObject(XmlObject xml) throws StoreException {
        HashSet<XmlObject> additions = new HashSet<XmlObject>();
        additions.add(xml);
        this.repository.save(this.repository.getBaseContext(), additions, new HashSet(), new HashSet());
    }

    private boolean validateDefinition(org.openmetadata.xml.report.definition.ReportDocument definition, List<String> errors, boolean forceUpdate) {
        XmlUpgrader.upgrade((org.openmetadata.xml.report.definition.ReportDocument)definition);
        if (!this.validateXml((XmlObject)definition, errors)) {
            return false;
        }
        return forceUpdate || !this.repository.contains(definition.getReport().getId());
    }

    private boolean validatePlan(ReportDocument plan, List<String> errors, boolean forceUpdate) {
        XmlUpgrader.upgrade((ReportDocument)plan);
        if (!this.validateXml((XmlObject)plan, errors)) {
            return false;
        }
        if (this.repository.contains(plan.getReport().getId()) && !forceUpdate) {
            errors.add("A plan with the identifier [" + plan.getReport().getId() + "] already exists.");
        } else {
            String definitionId = plan.getReport().getDefinition().getId();
            try {
                XmlObject definition = this.repository.get(definitionId);
                if (XmlObjectCaster.canCast(org.openmetadata.xml.report.definition.ReportDocument.class, (XmlObject)definition, (boolean)false)) {
                    return ReportValidator.validateTopicDefintions((ReportDocument)plan, (org.openmetadata.xml.report.definition.ReportDocument)((org.openmetadata.xml.report.definition.ReportDocument)XmlObjectCaster.cast(org.openmetadata.xml.report.definition.ReportDocument.class, (XmlObject)definition)), errors);
                }
                errors.add("The definition reference [" + definitionId + "] does not refer to an definition document. Type is: " + definition.schemaType().getName().toString());
            }
            catch (ObjectNotFoundException e) {
                errors.add("The definition [" + definitionId + "] was not found for the plan.");
            }
        }
        return false;
    }

    private boolean validateXml(XmlObject xml, List<String> errors) {
        ArrayList xmlErrors = new ArrayList();
        boolean result = xml.validate(new XmlOptions().setErrorListener(xmlErrors).setValidateTreatLaxAsSkip());
        if (!result) {
            errors.add("Validation of XML failed");
            for (XmlError error : xmlErrors) {
                errors.add(XmlError.severityAsString((int)error.getSeverity()) + ": [" + error.getLine() + ", " + error.getColumn() + "]: " + error.getMessage());
            }
            return false;
        }
        return true;
    }
}

