<%@ page language="java" contentType="text/html; charset=UTF-8"
	pageEncoding="UTF-8"%>
<%@ page import="java.io.*"%>
<%@ page import="java.util.*"%>
<%@ page import="org.springframework.ui.*"%>
<%@ taglib prefix="form" uri="http://www.springframework.org/tags/form"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<html>
<head>
<link rel="stylesheet" type="text/css" href="resources/css/dmp.css" />
<META http-equiv="Content-Type" content="text/html;charset=UTF-8">
<title>DMP Portal Upload</title>
</head>
<body>
	<jsp:include page="menu.jsp" />
	<form:form modelAttribute="fileUpload" method="post"
		enctype="multipart/form-data" class="upload-form">
		<fieldset class="upload">
			<form:input path="file" type="file" class="file-select" />
			<div class="submit-controls">
			<input type="submit" class="upload-submit" /><form:checkbox path="forceUpdate" />
			<form:label for="forceUpdate" path="forceUpdate" class="update-option">Force Update</form:label>
			</div>
		</fieldset>
	</form:form>
	<c:if test="${not empty success}">
		<div class="upload-results">
			<c:choose>
				<c:when test="${success}">
					<p class="upload-status">Upload of ${fileName} was successful.</p>
				</c:when>
				<c:otherwise>
					<p class="upload-status">Upload of ${fileName} failed.</p>
					<div class="error-messages">
					<c:forEach items="${errors}" var="error">
						<p class="error-msg">${error}</p>
					</c:forEach>
					</div>
				</c:otherwise>
			</c:choose>
		</div>
	</c:if>
</body>
</html>