/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.dmp.portal;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlbeans.XmlError;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.openmetadata.dmp.portal.PortalController;
import org.openmetadata.dmp.portal.upload.FileUpload;
import org.openmetadata.dmp.ws.repository.DmpSharedBaseXRepository;
import org.openmetadata.store.catalog.Catalog;
import org.openmetadata.store.exceptions.InvalidCriteriaException;
import org.openmetadata.store.exceptions.ObjectNotFoundException;
import org.openmetadata.store.exceptions.StoreException;
import org.openmetadata.store.query.Criteria;
import org.openmetadata.store.query.SearchResult;
import org.openmetadata.store.query.TextSearch;
import org.openmetadata.store.query.impl.TextSearchImpl;
import org.openmetadata.util.xmlbeans.XmlObjectCaster;
import org.openmetadata.xml.report.HeadingType;
import org.openmetadata.xml.report.ReportDocument;
import org.openmetadata.xml.report.TopicType;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.validation.ObjectError;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.commons.CommonsMultipartFile;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class PortalController {
    protected Log logger = LogFactory.getLog(this.getClass());
    private DmpSharedBaseXRepository repository;
    private SearchResult result;

    @RequestMapping(method={RequestMethod.GET}, value={"/search"})
    public String search(Model model, HttpServletRequest request, @RequestParam(required=false) String text, @RequestParam(required=false) String scope, @RequestParam(required=false) String page) throws InvalidCriteriaException {
        String string = scope = scope == null || scope.equals("all") ? this.repository.getBaseContext() : scope;
        if (page == null && text != null) {
            this.result = this.repository.query(scope, (Criteria)new TextSearchCriteria(this, (TextSearch)new TextSearchImpl(new HashSet(), new HashSet(), text)));
            request.getSession().setAttribute("result", (Object)this.result);
        } else if (page == null) {
            System.out.println("=============clear attribute==================");
            request.getSession().removeAttribute("result");
            this.result = null;
        }
        return "search";
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/catalog"})
    public String getCatalog(Model model, HttpServletRequest request) {
        Catalog catalog = this.repository.getCatalog();
        model.addAttribute("catalog", (Object)catalog);
        return "catalog";
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/view"})
    public String view(Model model, HttpServletRequest request, @RequestParam String urn) throws ObjectNotFoundException {
        XmlObject xml = this.repository.get(urn);
        XmlObject definition = null;
        if (XmlObjectCaster.canCast(ReportDocument.class, (XmlObject)xml, (boolean)false)) {
            ReportDocument report = (ReportDocument)XmlObjectCaster.cast(ReportDocument.class, (XmlObject)xml);
            model.addAttribute("report", (Object)report);
            definition = this.repository.get(report.getReport().getDefinition().getId());
        } else if (XmlObjectCaster.canCast(org.openmetadata.xml.report.definition.ReportDocument.class, (XmlObject)xml, (boolean)false)) {
            definition = xml;
        }
        if (definition != null) {
            model.addAttribute("definition", (Object)XmlObjectCaster.cast(org.openmetadata.xml.report.definition.ReportDocument.class, (XmlObject)definition));
        }
        return "view";
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/{page}"})
    public String getPage(@PathVariable String page) {
        return page;
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/upload"})
    public String getUploadPage(Model model) {
        FileUpload uploadItem = new FileUpload();
        if (!model.containsAttribute("fileUpload")) {
            model.addAttribute("fileUpload", (Object)uploadItem);
        }
        return "upload";
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/upload"})
    public ModelAndView uploadFile(@ModelAttribute FileUpload fileUpload, BindingResult result) {
        XmlObject xml;
        ArrayList<String> errors;
        ModelAndView mav;
        block19: {
            mav = new ModelAndView("upload");
            mav.setViewName("upload");
            mav.addObject("fileUpload", (Object)fileUpload);
            errors = new ArrayList<String>();
            if (result.hasErrors()) {
                for (ObjectError error : result.getAllErrors()) {
                    String msg = "Binding Error: " + error.getCode() + " - " + error.getDefaultMessage();
                    this.logger.error((Object)msg);
                    errors.add(msg);
                }
                mav.addObject("errors", errors);
                return mav;
            }
            CommonsMultipartFile file = fileUpload.getFile();
            mav.addObject("fileName", (Object)file.getOriginalFilename());
            xml = null;
            try {
                xml = XmlObject.Factory.parse((InputStream)file.getInputStream(), (XmlOptions)new XmlOptions().setLoadLineNumbers());
                ArrayList xmlErrors = new ArrayList();
                if (XmlObjectCaster.canCast(org.openmetadata.xml.report.definition.ReportDocument.class, (XmlObject)xml, (boolean)false) || XmlObjectCaster.canCast(ReportDocument.class, (XmlObject)xml, (boolean)false)) {
                    if (this.validateXml(xml, xmlErrors)) {
                        if (XmlObjectCaster.canCast(org.openmetadata.xml.report.definition.ReportDocument.class, (XmlObject)xml, (boolean)false)) {
                            org.openmetadata.xml.report.definition.ReportDocument definition = (org.openmetadata.xml.report.definition.ReportDocument)XmlObjectCaster.cast(org.openmetadata.xml.report.definition.ReportDocument.class, (XmlObject)xml);
                            this.logger.debug((Object)("Uploaded definition: " + definition.getReport().getId()));
                            if (this.repository.contains(definition.getReport().getId()) && !fileUpload.isForceUpdate()) {
                                errors.add("A definition with the identifier [" + definition.getReport().getId() + "] already exists.");
                            } else {
                                try {
                                    this.uploadObject((XmlObject)definition);
                                }
                                catch (StoreException e) {
                                    errors.add(e.getMessage());
                                    this.logger.error((Object)e);
                                }
                            }
                            break block19;
                        }
                        if (!XmlObjectCaster.canCast(ReportDocument.class, (XmlObject)xml, (boolean)false)) break block19;
                        ReportDocument plan = (ReportDocument)XmlObjectCaster.cast(ReportDocument.class, (XmlObject)xml);
                        this.logger.debug((Object)("Uploaded plan: " + plan.getReport().getId()));
                        String definitionId = plan.getReport().getDefinition().getId();
                        if (this.repository.contains(plan.getReport().getId()) && !fileUpload.isForceUpdate()) {
                            errors.add("A plan with the identifier [" + plan.getReport().getId() + "] already exists.");
                            break block19;
                        }
                        if (!this.repository.contains(definitionId)) {
                            errors.add("The definition [" + definitionId + "] was not found for the plan.");
                            break block19;
                        }
                        try {
                            if (this.validatePlan(plan, (org.openmetadata.xml.report.definition.ReportDocument)XmlObjectCaster.cast(org.openmetadata.xml.report.definition.ReportDocument.class, (XmlObject)this.repository.get(definitionId)), errors)) {
                                this.uploadObject((XmlObject)plan);
                            }
                            break block19;
                        }
                        catch (StoreException e) {
                            errors.add(e.getMessage());
                            this.logger.error((Object)e);
                        }
                        break block19;
                    }
                    errors.add("Validation of XML failed");
                    for (XmlError error : xmlErrors) {
                        errors.add(XmlError.severityAsString((int)error.getSeverity()) + ": [" + error.getLine() + ", " + error.getColumn() + "]: " + error.getMessage());
                    }
                    break block19;
                }
                errors.add("Upload is not a DMP definition or a plan.");
            }
            catch (XmlException e) {
                this.logger.error((Object)e);
                errors.add("File could not be parsed as XML: " + e.getMessage());
            }
            catch (IOException e) {
                this.logger.error((Object)e);
                errors.add("File could not be parsed as XML: " + e.getMessage());
            }
        }
        mav.addObject("success", (Object)errors.isEmpty());
        mav.addObject("errors", errors);
        if (xml != null) {
            mav.addObject("xml", (Object)xml.xmlText(new XmlOptions().setSavePrettyPrint()));
        }
        return mav;
    }

    public void setRepository(DmpSharedBaseXRepository repository) {
        this.repository = repository;
    }

    protected boolean validateXml(XmlObject xml, List<XmlError> xmlErrors) {
        return xml.validate(new XmlOptions().setErrorListener(xmlErrors).setValidateTreatLaxAsSkip());
    }

    protected boolean validatePlan(ReportDocument plan, org.openmetadata.xml.report.definition.ReportDocument definition, List<String> errors) {
        Set definitionTopicIds = this.getDefinitionTopics(definition);
        this.validatePlanTopics(plan.getReport().getTopicList(), definitionTopicIds, errors);
        return errors.isEmpty();
    }

    private void validatePlanTopics(List<TopicType> topics, Set<String> definitionTopicIds, List<String> errors) {
        for (TopicType topic : topics) {
            if (definitionTopicIds.contains(topic.getTopicDefinition())) continue;
            errors.add("Definition topic [" + topic.getTopicDefinition() + "] for topic [" + topic.getId() + "] does not exist in the definition.");
            if (!XmlObjectCaster.canCast(HeadingType.class, (XmlObject)topic, (boolean)false)) continue;
            this.validatePlanTopics(((HeadingType)XmlObjectCaster.cast(HeadingType.class, (XmlObject)topic)).getTopicList(), definitionTopicIds, errors);
        }
    }

    protected void uploadObject(XmlObject xml) throws StoreException {
        HashSet<XmlObject> additions = new HashSet<XmlObject>();
        additions.add(xml);
        this.repository.save(this.repository.getBaseContext(), additions, new HashSet(), new HashSet());
    }

    private Set<String> getDefinitionTopics(org.openmetadata.xml.report.definition.ReportDocument report) {
        HashSet<String> ids = new HashSet<String>();
        this.populateDefinitionTopics(report.getReport().getTopicList(), ids);
        return ids;
    }

    private void populateDefinitionTopics(List<org.openmetadata.xml.report.definition.TopicType> topics, Set<String> ids) {
        for (org.openmetadata.xml.report.definition.TopicType topic : topics) {
            ids.add(topic.getId());
            if (!XmlObjectCaster.canCast(org.openmetadata.xml.report.definition.HeadingType.class, (XmlObject)topic, (boolean)false)) continue;
            this.populateDefinitionTopics(((org.openmetadata.xml.report.definition.HeadingType)XmlObjectCaster.cast(org.openmetadata.xml.report.definition.HeadingType.class, (XmlObject)topic)).getTopicList(), ids);
        }
    }
}

