/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.dmp.ws;

import java.util.Calendar;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlbeans.XmlObject;
import org.ddialliance.ddi_3_1.xml.xmlbeans.studyunit.StudyUnitType;
import org.openmetadata.dmp.ws.repository.DmpSharedBaseXRepository;
import org.openmetadata.dmp.xml.xmlbeans.services.CommitChangesRequestDocument;
import org.openmetadata.dmp.xml.xmlbeans.services.CommitChangesRequestType;
import org.openmetadata.dmp.xml.xmlbeans.services.CommitChangesResponseDocument;
import org.openmetadata.dmp.xml.xmlbeans.services.CommitChangesResponseType;
import org.openmetadata.dmp.xml.xmlbeans.services.GetDefinitionsRequestDocument;
import org.openmetadata.dmp.xml.xmlbeans.services.GetDefinitionsRequestType;
import org.openmetadata.dmp.xml.xmlbeans.services.GetDefinitionsResponseDocument;
import org.openmetadata.dmp.xml.xmlbeans.services.GetDefinitionsResponseType;
import org.openmetadata.dmp.xml.xmlbeans.services.GetItemsRequestDocument;
import org.openmetadata.dmp.xml.xmlbeans.services.GetItemsRequestType;
import org.openmetadata.dmp.xml.xmlbeans.services.GetItemsResponseDocument;
import org.openmetadata.dmp.xml.xmlbeans.services.GetItemsResponseType;
import org.openmetadata.dmp.xml.xmlbeans.services.GetPlansRequestDocument;
import org.openmetadata.dmp.xml.xmlbeans.services.GetPlansRequestType;
import org.openmetadata.dmp.xml.xmlbeans.services.GetPlansResponseDocument;
import org.openmetadata.dmp.xml.xmlbeans.services.GetPlansResponseType;
import org.openmetadata.dmp.xml.xmlbeans.services.GetStudiesRequestDocument;
import org.openmetadata.dmp.xml.xmlbeans.services.GetStudiesRequestType;
import org.openmetadata.dmp.xml.xmlbeans.services.GetStudiesResponseDocument;
import org.openmetadata.dmp.xml.xmlbeans.services.GetStudiesResponseType;
import org.openmetadata.store.exceptions.ObjectNotFoundException;
import org.openmetadata.store.exceptions.StoreException;
import org.openmetadata.store.xml.xmlbeans.lock.LockInformationType;
import org.openmetadata.store.xml.xmlbeans.services.GetCatalogRequestDocument;
import org.openmetadata.store.xml.xmlbeans.services.GetCatalogResponseDocument;
import org.openmetadata.store.xml.xmlbeans.services.GetCatalogResponseType;
import org.openmetadata.store.xml.xmlbeans.services.LockRequestDocument;
import org.openmetadata.store.xml.xmlbeans.services.LockRequestType;
import org.openmetadata.store.xml.xmlbeans.services.LockResponseDocument;
import org.openmetadata.store.xml.xmlbeans.services.LockResponseType;
import org.openmetadata.store.xml.xmlbeans.services.LockValidityType;
import org.openmetadata.store.xml.xmlbeans.services.ReleaseLockRequestDocument;
import org.openmetadata.store.xml.xmlbeans.services.ReleaseLockRequestType;
import org.openmetadata.store.xml.xmlbeans.services.ReleaseLockResponseDocument;
import org.openmetadata.store.xml.xmlbeans.services.ReleaseLockResponseType;
import org.openmetadata.store.xml.xmlbeans.services.VerifyLocksRequestDocument;
import org.openmetadata.store.xml.xmlbeans.services.VerifyLocksResponseDocument;
import org.openmetadata.store.xml.xmlbeans.services.VerifyLocksResponseType;
import org.openmetadata.store.xml.xmlbeans.services.VerifyUserRequestDocument;
import org.openmetadata.store.xml.xmlbeans.services.VerifyUserResponseDocument;
import org.openmetadata.store.xml.xmlbeans.services.VerifyUserResponseType;
import org.openmetadata.store.xml.xmlbeans.services.ViewLockRequestDocument;
import org.openmetadata.store.xml.xmlbeans.services.ViewLockRequestType;
import org.openmetadata.store.xml.xmlbeans.services.ViewLockResponseDocument;
import org.openmetadata.store.xml.xmlbeans.services.ViewLockResponseType;
import org.openmetadata.store.xml.xmlbeans.services.ViewLocksRequestDocument;
import org.openmetadata.store.xml.xmlbeans.services.ViewLocksResponseDocument;
import org.openmetadata.store.xml.xmlbeans.services.ViewLocksResponseType;
import org.openmetadata.store.xml.xmlbeans.user.UserType;
import org.openmetadata.util.xmlbeans.XmlObjectCaster;
import org.openmetadata.ws.core.IdentifierType;
import org.openmetadata.xml.report.ReportType;
import org.springframework.ws.server.endpoint.annotation.Endpoint;
import org.springframework.ws.server.endpoint.annotation.PayloadRoot;

@Endpoint
public class WebServiceEndpoint {
    protected Log logger = LogFactory.getLog(this.getClass());
    private DmpSharedBaseXRepository repository;

    @PayloadRoot(localPart="VerifyUserRequest", namespace="http://openmetadata.org/store/services")
    public VerifyUserResponseDocument verifyUser(VerifyUserRequestDocument request) {
        VerifyUserResponseDocument response = VerifyUserResponseDocument.Factory.newInstance();
        VerifyUserResponseType responseXml = response.addNewVerifyUserResponse();
        responseXml.addNewSuccess();
        return response;
    }

    @PayloadRoot(localPart="LockRequest", namespace="http://openmetadata.org/store/services")
    public LockResponseDocument requestLock(LockRequestDocument request) {
        LockRequestType requestXml = request.getLockRequest();
        String id = requestXml.getItemID();
        LockResponseDocument response = LockResponseDocument.Factory.newInstance();
        LockResponseType responseXml = response.addNewLockResponse();
        if (this.repository.contains(id)) {
            LockInformationType lockInfo = this.repository.getLock(id);
            if (lockInfo == null) {
                lockInfo = LockInformationType.Factory.newInstance();
                lockInfo.setObjectURN(id);
                lockInfo.setUser(requestXml.getUser());
                lockInfo.setTimestamp(Calendar.getInstance());
                this.repository.addLock(lockInfo);
                responseXml.setGranted(lockInfo);
            } else {
                UserType lockUser = lockInfo.getUser();
                UserType requestUser = requestXml.getUser();
                if (lockUser.getId().equals(requestUser.getId()) && lockUser.getLocation().equals(requestUser.getLocation())) {
                    responseXml.setGranted(lockInfo);
                } else {
                    responseXml.setAlreadyLocked(lockInfo);
                }
            }
        } else {
            responseXml.setFailure("Object (" + id + ") does not exist,");
        }
        return response;
    }

    @PayloadRoot(localPart="ReleaseLockRequest", namespace="http://openmetadata.org/store/services")
    public ReleaseLockResponseDocument releaseLock(ReleaseLockRequestDocument request) {
        ReleaseLockRequestType requestXml = request.getReleaseLockRequest();
        LockInformationType requestLock = requestXml.getLockInformation();
        ReleaseLockResponseDocument response = ReleaseLockResponseDocument.Factory.newInstance();
        ReleaseLockResponseType responseXml = response.addNewReleaseLockResponse();
        LockInformationType actualLock = this.repository.getLock(requestLock.getObjectURN());
        if (actualLock == null) {
            responseXml.addNewSuccess();
        } else {
            UserType requestUser = requestLock.getUser();
            UserType lockUser = actualLock.getUser();
            if (lockUser.getId().equals(requestUser.getId()) && lockUser.getLocation().equals(requestUser.getLocation())) {
                this.repository.releaseLock(actualLock);
                responseXml.addNewSuccess();
            } else {
                responseXml.addNewSuccess();
            }
        }
        return response;
    }

    @PayloadRoot(localPart="ViewLockRequest", namespace="http://openmetadata.org/store/services")
    public ViewLockResponseDocument viewLock(ViewLockRequestDocument request) {
        ViewLockRequestType requestXml = request.getViewLockRequest();
        ViewLockResponseDocument response = ViewLockResponseDocument.Factory.newInstance();
        ViewLockResponseType responseXml = response.addNewViewLockResponse();
        LockInformationType lock = this.repository.getLock(requestXml.getItemID());
        if (lock == null) {
            responseXml.setFailure("Item (" + requestXml.getItemID() + ") is not locked.");
        } else {
            responseXml.setLockInformation(lock);
        }
        return response;
    }

    @PayloadRoot(localPart="ViewLocksRequest", namespace="http://openmetadata.org/store/services")
    public ViewLocksResponseDocument viewLocks(ViewLocksRequestDocument request) {
        ViewLocksResponseDocument response = ViewLocksResponseDocument.Factory.newInstance();
        ViewLocksResponseType responseXml = response.addNewViewLocksResponse();
        LockInformationType[] locks = this.repository.getAllLocks();
        if (locks.length == 0) {
            responseXml.addNewNone();
        } else {
            LockInformationType[] lockInformationTypeArray = locks;
            int n = locks.length;
            int n2 = 0;
            while (n2 < n) {
                LockInformationType lock = lockInformationTypeArray[n2];
                responseXml.getLockInformationList().add(lock);
                ++n2;
            }
        }
        return response;
    }

    @PayloadRoot(localPart="VerifyLocksRequest", namespace="http://openmetadata.org/store/services")
    public VerifyLocksResponseDocument verifyLocks(VerifyLocksRequestDocument request) {
        VerifyLocksResponseDocument response = VerifyLocksResponseDocument.Factory.newInstance();
        VerifyLocksResponseType responseXml = response.addNewVerifyLocksResponse();
        for (LockInformationType lock : request.getVerifyLocksRequest().getLockInformationList()) {
            LockValidityType vLock = (LockValidityType)lock.changeType(LockValidityType.type);
            vLock.setValid(this.verifyLock(vLock.getObjectURN(), vLock.getUser()));
            responseXml.getLockValidityList().add(vLock);
        }
        return response;
    }

    @PayloadRoot(localPart="GetCatalogRequest", namespace="http://openmetadata.org/store/services")
    public GetCatalogResponseDocument getCatalog(GetCatalogRequestDocument request) {
        GetCatalogResponseDocument response = GetCatalogResponseDocument.Factory.newInstance();
        GetCatalogResponseType responseXml = response.addNewGetCatalogResponse();
        responseXml.setCatalog(this.repository.getXmlCatalog().getCatalog());
        return response;
    }

    @PayloadRoot(localPart="GetItemsRequest", namespace="http://openmetadata.org/dmp/services")
    public GetItemsResponseDocument getItems(GetItemsRequestDocument request) {
        GetItemsRequestType requestXml = request.getGetItemsRequest();
        GetItemsResponseDocument response = GetItemsResponseDocument.Factory.newInstance();
        GetItemsResponseType responseXml = response.addNewGetItemsResponse();
        HashSet<String> ids = new HashSet<String>();
        String type = null;
        boolean typeChange = false;
        for (IdentifierType identifierType : requestXml.getIdentifierList()) {
            ids.add(identifierType.getStringValue());
            if (type == null) {
                type = identifierType.getType();
                continue;
            }
            if (type.equals(identifierType.getType())) continue;
            typeChange = true;
        }
        try {
            if (typeChange) {
                for (String string : ids) {
                    this.addXmlToItems(this.repository.get(string), responseXml);
                }
            } else {
                Set set = this.repository.get(ids);
                for (XmlObject xml : set) {
                    this.addXmlToItems(xml, responseXml);
                }
            }
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            responseXml.setFailure(objectNotFoundException.getMessage());
        }
        return response;
    }

    @PayloadRoot(localPart="GetPlansRequest", namespace="http://openmetadata.org/dmp/services")
    public GetPlansResponseDocument getPlans(GetPlansRequestDocument request) {
        GetPlansResponseDocument response = GetPlansResponseDocument.Factory.newInstance();
        GetPlansResponseType responseXml = response.addNewGetPlansResponse();
        GetPlansRequestType requestXml = request.getGetPlansRequest();
        try {
            if (requestXml.getIdentifierList().size() > 0) {
                HashSet<String> ids = new HashSet<String>();
                for (IdentifierType id : requestXml.getIdentifierList()) {
                    ids.add(id.getStringValue());
                }
                Set results = this.repository.get(ids);
                if (results.size() > 0) {
                    for (XmlObject xml : results) {
                        if (XmlObjectCaster.canCast(ReportType.class, (XmlObject)xml, (boolean)false)) {
                            responseXml.getReportList().add((ReportType)XmlObjectCaster.cast(ReportType.class, (XmlObject)xml));
                            continue;
                        }
                        throw new RuntimeException("Unexpected result type (" + xml.schemaType().getName().toString() + ").");
                    }
                } else {
                    responseXml.addNewNone();
                }
            }
        }
        catch (ObjectNotFoundException e) {
            responseXml.setFailure(e.getMessage());
        }
        return response;
    }

    @PayloadRoot(localPart="GetDefinitionsRequest", namespace="http://openmetadata.org/dmp/services")
    public GetDefinitionsResponseDocument getDefinitions(GetDefinitionsRequestDocument request) {
        GetDefinitionsResponseDocument response = GetDefinitionsResponseDocument.Factory.newInstance();
        GetDefinitionsResponseType responseXml = response.addNewGetDefinitionsResponse();
        GetDefinitionsRequestType requestXml = request.getGetDefinitionsRequest();
        try {
            if (requestXml.getIdentifierList().size() > 0) {
                HashSet<String> ids = new HashSet<String>();
                for (IdentifierType id : requestXml.getIdentifierList()) {
                    ids.add(id.getStringValue());
                }
                Set results = this.repository.get(ids);
                if (results.size() > 0) {
                    for (XmlObject xml : results) {
                        if (XmlObjectCaster.canCast(org.openmetadata.xml.report.definition.ReportType.class, (XmlObject)xml, (boolean)false)) {
                            responseXml.getReportList().add((org.openmetadata.xml.report.definition.ReportType)XmlObjectCaster.cast(org.openmetadata.xml.report.definition.ReportType.class, (XmlObject)xml));
                            continue;
                        }
                        throw new RuntimeException("Unexpected result type (" + xml.schemaType().getName().toString() + ").");
                    }
                } else {
                    responseXml.addNewNone();
                }
            }
        }
        catch (ObjectNotFoundException e) {
            responseXml.setFailure(e.getMessage());
        }
        return response;
    }

    @PayloadRoot(localPart="GetStudiesRequest", namespace="http://openmetadata.org/dmp/services")
    public GetStudiesResponseDocument getStudies(GetStudiesRequestDocument request) {
        GetStudiesResponseDocument response = GetStudiesResponseDocument.Factory.newInstance();
        GetStudiesResponseType responseXml = response.addNewGetStudiesResponse();
        GetStudiesRequestType requestXml = request.getGetStudiesRequest();
        try {
            if (requestXml.getIdentifierList().size() > 0) {
                HashSet<String> ids = new HashSet<String>();
                for (IdentifierType id : requestXml.getIdentifierList()) {
                    ids.add(id.getStringValue());
                }
                Set results = this.repository.get(ids);
                if (results.size() > 0) {
                    for (XmlObject xml : results) {
                        if (XmlObjectCaster.canCast(StudyUnitType.class, (XmlObject)xml, (boolean)false)) {
                            responseXml.getStudyUnitList().add((StudyUnitType)XmlObjectCaster.cast(StudyUnitType.class, (XmlObject)xml));
                            continue;
                        }
                        throw new RuntimeException("Unexpected result type (" + xml.schemaType().getName().toString() + ").");
                    }
                } else {
                    responseXml.addNewNone();
                }
            }
        }
        catch (ObjectNotFoundException e) {
            responseXml.setFailure(e.getMessage());
        }
        return response;
    }

    @PayloadRoot(localPart="CommitChangesRequest", namespace="http://openmetadata.org/dmp/services")
    public CommitChangesResponseDocument commitChanges(CommitChangesRequestDocument request) {
        String id;
        CommitChangesResponseDocument response = CommitChangesResponseDocument.Factory.newInstance();
        CommitChangesResponseType responseXml = response.addNewCommitChangesResponse();
        CommitChangesRequestType requestXml = request.getCommitChangesRequest();
        UserType user = requestXml.getUser();
        HashSet<String> ids = new HashSet<String>();
        HashSet<Object> additions = new HashSet<Object>();
        HashSet<XmlObject> deletions = new HashSet<XmlObject>();
        HashSet<Object> updates = new HashSet<Object>();
        boolean failure = false;
        Calendar updateDate = Calendar.getInstance();
        if (requestXml.isSetAdditions()) {
            for (ReportType report : requestXml.getAdditions().getReport2List()) {
                report.setVersionDate(updateDate);
                additions.add(report);
                id = report.getId();
                ids.add(id);
            }
            for (ReportType report : requestXml.getAdditions().getReportList()) {
                report.setVersionDate(updateDate);
                additions.add(report);
                id = report.getId();
                ids.add(id);
            }
            for (StudyUnitType study : requestXml.getAdditions().getStudyUnitList()) {
                study.setVersionDate((Object)updateDate);
                additions.add(study);
                id = study.getId();
                ids.add(id);
            }
            for (String id2 : ids) {
                if (!this.repository.contains(id2)) continue;
                if (!failure) {
                    responseXml.setFailure("");
                    failure = true;
                }
                responseXml.setFailure(String.valueOf(responseXml.getFailure()) + "\nAdded Item (" + id2 + ") alread exists.");
            }
        }
        if (requestXml.isSetUpdates()) {
            for (ReportType report : requestXml.getUpdates().getReport2List()) {
                report.setVersionDate(updateDate);
                updates.add(report);
                id = report.getId();
                ids.add(id);
                if (this.verifyLock(id, user)) continue;
                if (failure) {
                    responseXml.setFailure(String.valueOf(responseXml.getFailure()) + "\nItem (" + id + ") is not locked by the user.");
                    continue;
                }
                failure = true;
                responseXml.setFailure("Item (" + id + ") is not locked by the user.");
            }
            for (ReportType report : requestXml.getUpdates().getReportList()) {
                report.setVersionDate(updateDate);
                updates.add(report);
                id = report.getId();
                ids.add(id);
                if (this.verifyLock(id, user)) continue;
                if (failure) {
                    responseXml.setFailure(String.valueOf(responseXml.getFailure()) + "\nItem (" + id + ") is not locked by the user.");
                    continue;
                }
                failure = true;
                responseXml.setFailure("Item (" + id + ") is not locked by the user.");
            }
            for (StudyUnitType study : requestXml.getUpdates().getStudyUnitList()) {
                study.setVersionDate((Object)updateDate);
                updates.add(study);
                id = study.getUrn();
                ids.add(id);
                if (this.verifyLock(id, user)) continue;
                if (failure) {
                    responseXml.setFailure(String.valueOf(responseXml.getFailure()) + "\nItem (" + id + ") is not locked by the user.");
                    continue;
                }
                failure = true;
                responseXml.setFailure("Item (" + id + ") is not locked by the user.");
            }
        }
        for (String id2 : requestXml.getDeletionList()) {
            try {
                deletions.add(this.repository.get(id2));
            }
            catch (ObjectNotFoundException e) {
                if (!failure) {
                    responseXml.setFailure("");
                    failure = true;
                }
                responseXml.setFailure(String.valueOf(responseXml.getFailure()) + "\nAdded Item (" + id2 + ") alread exists.");
                responseXml.setFailure("Deleted Item (" + id2 + ") does not exis.");
            }
            if (this.verifyLock(id2, user)) continue;
            if (!failure) {
                responseXml.setFailure("");
                failure = true;
            }
            responseXml.setFailure(String.valueOf(responseXml.getFailure()) + "\nAdded Item (" + id2 + ") alread exists.");
            responseXml.setFailure("Item (" + id2 + ") is not locked by the user.");
        }
        if (!failure) {
            try {
                this.repository.save(requestXml.getContextId(), additions, updates, deletions);
                this.updateCommitResponseItems(additions, responseXml);
                this.updateCommitResponseItems(updates, responseXml);
            }
            catch (StoreException e) {
                throw new RuntimeException(e);
            }
        }
        return response;
    }

    public void setRepository(DmpSharedBaseXRepository repository) {
        this.repository = repository;
    }

    protected boolean verifyLock(String id, UserType user) {
        UserType lockUser;
        LockInformationType lock = this.repository.getLock(id);
        return lock != null && (lockUser = lock.getUser()).getId().equals(user.getId()) && lockUser.getLocation().equals(lockUser.getLocation());
    }

    protected void addXmlToItems(XmlObject xml, GetItemsResponseType responseXml) {
        if (XmlObjectCaster.canCast(ReportType.class, (XmlObject)xml, (boolean)false)) {
            responseXml.getReport2List().add((ReportType)XmlObjectCaster.cast(ReportType.class, (XmlObject)xml));
        } else if (XmlObjectCaster.canCast(org.openmetadata.xml.report.definition.ReportType.class, (XmlObject)xml, (boolean)false)) {
            responseXml.getReportList().add((org.openmetadata.xml.report.definition.ReportType)XmlObjectCaster.cast(org.openmetadata.xml.report.definition.ReportType.class, (XmlObject)xml));
        } else if (XmlObjectCaster.canCast(StudyUnitType.class, (XmlObject)xml, (boolean)false)) {
            responseXml.getStudyUnitList().add((StudyUnitType)XmlObjectCaster.cast(StudyUnitType.class, (XmlObject)xml));
        } else {
            this.logger.error((Object)("Unknown object type (" + xml.schemaType().getName().toString() + ")"));
        }
    }

    protected void updateCommitResponseItems(Set<XmlObject> items, CommitChangesResponseType responseXml) {
        for (XmlObject item : items) {
            if (XmlObjectCaster.canCast(ReportType.class, (XmlObject)item, (boolean)false)) {
                responseXml.getReport2List().add((ReportType)XmlObjectCaster.cast(ReportType.class, (XmlObject)item));
                continue;
            }
            if (XmlObjectCaster.canCast(org.openmetadata.xml.report.definition.ReportType.class, (XmlObject)item, (boolean)false)) {
                responseXml.getReportList().add((org.openmetadata.xml.report.definition.ReportType)XmlObjectCaster.cast(org.openmetadata.xml.report.definition.ReportType.class, (XmlObject)item));
                continue;
            }
            if (XmlObjectCaster.canCast(StudyUnitType.class, (XmlObject)item, (boolean)false)) {
                responseXml.getStudyUnitList().add((StudyUnitType)XmlObjectCaster.cast(StudyUnitType.class, (XmlObject)item));
                continue;
            }
            throw new RuntimeException("Unexcepted exception casting items for response document.");
        }
    }
}

