/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.dmp.ws;

import java.io.IOException;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.basex.BaseXServer;
import org.basex.core.BaseXException;
import org.basex.core.Context;
import org.basex.core.MainProp;
import org.basex.core.Prop;
import org.basex.core.cmd.CreateDB;
import org.basex.core.cmd.Set;
import org.openmetadata.dmp.ws.DmpSharedBaseXConfiguration;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class WebServiceContextListener
implements ServletContextListener {
    protected Log logger = LogFactory.getLog(this.getClass());
    private static BaseXServer server;

    public void contextDestroyed(ServletContextEvent arg0) {
        if (server != null) {
            try {
                this.logger.info((Object)"Stopping BaseX Server.");
                server.stop();
            }
            catch (IOException e) {
                this.logger.error((Object)e);
                throw new RuntimeException(e);
            }
        }
    }

    public void contextInitialized(ServletContextEvent sce) {
        try {
            ServletContext ctx = sce.getServletContext();
            WebApplicationContext springContext = WebApplicationContextUtils.getWebApplicationContext((ServletContext)ctx);
            DmpSharedBaseXConfiguration config = (DmpSharedBaseXConfiguration)springContext.getBean("config");
            if (config == null) {
                throw new RuntimeException("Cannot find config bean.");
            }
            String db = config.getDb();
            String path = config.getPath();
            this.logger.info((Object)"Context initialized.");
            Context context = new Context();
            try {
                try {
                    if (path != null) {
                        new Set((Object)MainProp.DBPATH, (Object)path).execute(context);
                    }
                    if (!context.mprop.dbexists(db)) {
                        new Set((Object)Prop.FTINDEX, (Object)true).execute(context);
                        new Set((Object)Prop.STEMMING, (Object)true).execute(context);
                        new Set((Object)Prop.CHOP, (Object)false).execute(context);
                        this.logger.info((Object)("Creating BaseX database: " + db));
                        new CreateDB(db).execute(context);
                    }
                    this.logger.info((Object)"Starting BaseX Server.");
                    server = new BaseXServer(new String[0]);
                }
                catch (BaseXException e) {
                    throw new RuntimeException(e);
                }
            }
            finally {
                context.close();
            }
        }
        catch (IOException e) {
            this.logger.error((Object)e);
            throw new RuntimeException(e);
        }
    }
}

