/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.dmp.store.manager;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import org.openmetadata.beans.notification.IdentifiableChangeEvent;
import org.openmetadata.dmp.beans.DmpIDUtils;
import org.openmetadata.store.change.ChangeSet;
import org.openmetadata.store.change.impl.ChangeSetImpl;
import org.openmetadata.store.managers.ChangeManager;

public class DmpChangeManager
implements ChangeManager {
    private final HashSet<String> additions;
    private final HashSet<String> deletions;
    private final HashSet<String> updates;
    private final HashMap<String, ChangeSetImpl<String>> itemMap;
    private final String rootContext;

    public DmpChangeManager(String rootContext) {
        this.rootContext = rootContext;
        this.additions = new HashSet();
        this.deletions = new HashSet();
        this.updates = new HashSet();
        this.itemMap = new HashMap();
    }

    public void notifyChangeEvent(IdentifiableChangeEvent event) {
        String beanId = event.getBean().getPrimaryIdentifier();
        String containerId = DmpIDUtils.getContainerID((String)beanId);
        ChangeSetImpl items = this.itemMap.get(containerId);
        if (items == null) {
            items = new ChangeSetImpl();
        }
        if (!containerId.equals(beanId)) {
            if (!items.getAdditions().contains(containerId)) {
                items.addUpdate((Object)containerId);
            }
            switch (event.getType()) {
                case CREATE: {
                    items.addAddition((Object)beanId);
                    break;
                }
                case DELETE: {
                    if (items.getAdditions().contains(beanId)) {
                        items.getAdditions().remove(beanId);
                        break;
                    }
                    if (items.getUpdates().contains(beanId)) {
                        items.getUpdates().remove(beanId);
                        items.addDeletion((Object)beanId);
                        break;
                    }
                    items.addDeletion((Object)beanId);
                    break;
                }
                case UPDATE: {
                    if (items.getAdditions().contains(beanId)) break;
                    items.addUpdate((Object)beanId);
                }
            }
        }
        switch (event.getType()) {
            case CREATE: {
                if (beanId.equals(containerId)) {
                    this.additions.add(containerId);
                    items.addAddition((Object)containerId);
                    break;
                }
            }
            case DELETE: {
                if (beanId.equals(containerId)) {
                    if (this.additions.contains(containerId)) {
                        this.additions.remove(containerId);
                        items.getAdditions().remove(containerId);
                        break;
                    }
                    if (this.updates.contains(containerId)) {
                        this.updates.remove(containerId);
                        items.getUpdates().remove(containerId);
                        this.deletions.add(containerId);
                        items.addDeletion((Object)containerId);
                        break;
                    }
                    this.deletions.add(containerId);
                    items.addDeletion((Object)containerId);
                    break;
                }
            }
            case UPDATE: {
                if (this.additions.contains(containerId)) break;
                items.addUpdate((Object)containerId);
                this.updates.add(containerId);
            }
        }
        this.itemMap.put(containerId, (ChangeSetImpl<String>)items);
    }

    public ChangeSet<String> getUnsavedChanges() {
        ChangeSetImpl changeSet = new ChangeSetImpl();
        changeSet.addAdditions(this.additions);
        changeSet.addDeletions(this.deletions);
        changeSet.addUpdates(this.updates);
        return changeSet;
    }

    public void notifySave(String id) {
        if (id.equals(this.rootContext)) {
            this.additions.clear();
            this.deletions.clear();
            this.updates.clear();
            this.itemMap.clear();
        } else {
            this.additions.remove(id);
            this.deletions.remove(id);
            this.updates.remove(id);
            this.itemMap.remove(id);
        }
    }

    public void notifyDiscard(String id) {
        if (id.equals(this.rootContext)) {
            this.additions.clear();
            this.deletions.clear();
            this.updates.clear();
            this.itemMap.clear();
        } else {
            this.additions.remove(id);
            this.deletions.remove(id);
            this.updates.remove(id);
            this.itemMap.remove(id);
        }
    }

    public ChangeSet<String> getSaveSet(String id) {
        ChangeSetImpl changeSet = new ChangeSetImpl();
        if (id.equals(this.rootContext)) {
            changeSet.addAdditions(this.additions);
            changeSet.addDeletions(this.deletions);
            changeSet.addUpdates(this.updates);
        } else if (this.deletions.contains(id)) {
            changeSet.addDeletion((Object)id);
        } else if (this.additions.contains(id)) {
            changeSet.addAddition((Object)id);
        } else if (this.updates.contains(id)) {
            changeSet.addUpdate((Object)id);
        }
        return changeSet;
    }

    public ChangeSet<String> getDiscardSet(String id) {
        return this.getSaveSet(id);
    }

    public ChangeSet<String> getAllSaveItems(String id) {
        if (id.equals(this.rootContext)) {
            ChangeSetImpl changeSet = new ChangeSetImpl();
            for (ChangeSetImpl<String> set : this.itemMap.values()) {
                changeSet.addAdditions((Collection)set.getAdditions());
                changeSet.addDeletions((Collection)set.getDeletions());
                changeSet.addUpdates((Collection)set.getUpdates());
            }
            return changeSet;
        }
        return (ChangeSet)this.itemMap.get(id);
    }

    public ChangeSet<String> getAllDiscardItems(String id) {
        return this.getAllSaveItems(id);
    }
}

