/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.dmp.store;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.xmlbeans.XmlObject;
import org.openmetadata.beans.IdentifiableBean;
import org.openmetadata.beans.notification.IdentifiableChangeEvent;
import org.openmetadata.dmp.beans.DataManagementPlanBean;
import org.openmetadata.dmp.beans.HeadingBean;
import org.openmetadata.dmp.beans.StringBeanList;
import org.openmetadata.dmp.beans.TextBean;
import org.openmetadata.dmp.beans.TextBeanList;
import org.openmetadata.dmp.beans.TopicBean;
import org.openmetadata.dmp.beans.TopicList;
import org.openmetadata.dmp.beans.definitions.FieldDefinitionBean;
import org.openmetadata.dmp.beans.definitions.HeadingDefinitionBean;
import org.openmetadata.dmp.beans.definitions.TopicDefinitionBean;
import org.openmetadata.dmp.beans.definitions.TopicDefinitionList;
import org.openmetadata.dmp.beans.field.value.BooleanValueBean;
import org.openmetadata.dmp.beans.field.value.DateValueBean;
import org.openmetadata.dmp.beans.field.value.IntegerValueBean;
import org.openmetadata.dmp.beans.field.value.LongStringValueBean;
import org.openmetadata.dmp.beans.field.value.StringValueBean;
import org.openmetadata.dmp.store.repository.client.DmpClientWorkspaceRepository;
import org.openmetadata.store.ClientWorkspace;
import org.openmetadata.store.cache.LockingBeanCache;
import org.openmetadata.store.change.ChangeSet;
import org.openmetadata.store.exceptions.InsufficientRightsException;
import org.openmetadata.store.exceptions.ObjectNotFoundException;
import org.openmetadata.store.exceptions.StoreException;
import org.openmetadata.store.impl.WorkspaceImpl;
import org.openmetadata.store.managers.LocalLockManager;
import org.openmetadata.store.repository.WorkspaceRepository;

public class DmpClientWorkspace
extends WorkspaceImpl<XmlObject>
implements ClientWorkspace {
    private final DmpClientWorkspaceRepository repository;
    private boolean suppressChanges;

    public DmpClientWorkspace(String contextId, boolean mustDeserialize, DmpClientWorkspaceRepository repository) {
        super(contextId, mustDeserialize);
        this.repository = repository;
        this.setWorksapceRepository((WorkspaceRepository)repository);
    }

    public <B extends IdentifiableBean> B getBean(Class<B> beanClass, String id) throws ObjectNotFoundException, InsufficientRightsException {
        IdentifiableBean bean = super.getBean(beanClass, id);
        if (beanClass.equals(DataManagementPlanBean.class)) {
            this.getBeanFactory();
            this.suppressChanges = true;
            this.initializeDmpBean((DataManagementPlanBean)bean);
            this.suppressChanges = false;
        }
        return (B)bean;
    }

    public void notifyChangeEvent(IdentifiableChangeEvent event) {
        if (!this.suppressChanges) {
            super.notifyChangeEvent(event);
        }
    }

    public LocalLockManager getLockManager() {
        return this.repository.getLockManager();
    }

    public ChangeSet<String> getUncommittedChange() {
        return this.repository.getUncommitedChanges();
    }

    public void commitChanges(String id) throws StoreException {
        this.addSaveOperation(this.repository.commitChanges(id));
        this.revertBean(id);
    }

    public void commitAllChanges() throws StoreException {
        Set<String> revertIds = this.getRevertFullSet();
        this.addSaveOperation(this.repository.commitAllChanges());
        for (String id : revertIds) {
            this.revertBean(id);
        }
    }

    public void revertChanges(String id) {
        this.addSaveOperation(this.repository.revertChanges(id));
        this.revertBean(id);
    }

    public void revertAllChanges() {
        Set<String> revertIds = this.getRevertFullSet();
        this.addSaveOperation(this.repository.revertAllChanges());
        for (String id : revertIds) {
            this.revertBean(id);
        }
    }

    protected void revertBean(String id) {
        LockingBeanCache cache = this.getLockingBeanCache();
        if (id.startsWith("urn:dmp:plan:") && cache.contains(id)) {
            DataManagementPlanBean plan = (DataManagementPlanBean)cache.get(id);
            this.clearPlanFromCache((TopicBean[])plan.getTopics().toArray());
            cache.remove((Object)plan);
        }
    }

    protected Set<String> getRevertFullSet() {
        ChangeSet changes = this.repository.getUncommitedChanges();
        HashSet<String> revertIds = new HashSet<String>();
        revertIds.addAll(changes.getAdditions());
        revertIds.addAll(changes.getDeletions());
        revertIds.addAll(changes.getUpdates());
        return revertIds;
    }

    private void clearPlanFromCache(TopicBean[] topics) {
        LockingBeanCache cache = this.getLockingBeanCache();
        TopicBean[] topicBeanArray = topics;
        int n = topics.length;
        int n2 = 0;
        while (n2 < n) {
            TopicBean topic = topicBeanArray[n2];
            if (topic.isHeading()) {
                this.clearPlanFromCache((TopicBean[])((HeadingBean)topic).getTopicList().toArray());
            }
            cache.remove((Object)topic);
            ++n2;
        }
    }

    private void initializeDmpBean(DataManagementPlanBean dmpBean) {
        this.initializeBeanList(dmpBean.getTopics(), dmpBean.getDefinition().getTopics());
    }

    private void initializeBeanList(TopicList planList, TopicDefinitionList defList) {
        Iterator planIter = planList.iterator();
        Iterator defIter = defList.iterator();
        block0: while (planIter.hasNext()) {
            TopicBean planTopic = (TopicBean)planIter.next();
            TopicDefinitionBean defTopic = (TopicDefinitionBean)defIter.next();
            if (planTopic.getDefinition().getPrimaryIdentifier().equals(defTopic.getPrimaryIdentifier())) {
                if (!defTopic.isHeadingDefinition() || !(planTopic instanceof HeadingBean)) continue;
                this.initializeBeanList(((HeadingBean)planTopic).getTopicList(), ((HeadingDefinitionBean)defTopic).getTopicDefinitionList());
                continue;
            }
            this.addTopic(planList, defTopic, planTopic);
            planIter = planList.iterator();
            while (planIter.hasNext()) {
                if (((TopicBean)planIter.next()).getDefinition().getPrimaryIdentifier().equals(defTopic.getPrimaryIdentifier())) continue block0;
            }
        }
        while (defIter.hasNext()) {
            this.addTopic(planList, (TopicDefinitionBean)defIter.next(), null);
        }
    }

    private void addTopic(TopicList topicList, TopicDefinitionBean defTopic, TopicBean before) {
        HeadingBean topic = null;
        if (defTopic instanceof FieldDefinitionBean) {
            if (((FieldDefinitionBean)defTopic).getRepresentation().equals(StringValueBean.class)) {
                FieldDefinitionBean fieldDef = (FieldDefinitionBean)defTopic;
                topic = topicList.addNewField(fieldDef.getPrimaryIdentifier(), fieldDef.getRepresentation());
            } else if (((FieldDefinitionBean)defTopic).getRepresentation().equals(LongStringValueBean.class)) {
                FieldDefinitionBean fieldDef = (FieldDefinitionBean)defTopic;
                topic = topicList.addNewField(fieldDef.getPrimaryIdentifier(), fieldDef.getRepresentation());
            } else if (((FieldDefinitionBean)defTopic).getRepresentation().equals(TextBean.class)) {
                FieldDefinitionBean fieldDef = (FieldDefinitionBean)defTopic;
                topic = topicList.addNewField(fieldDef.getPrimaryIdentifier(), fieldDef.getRepresentation());
            } else if (((FieldDefinitionBean)defTopic).getRepresentation().equals(TextBeanList.class)) {
                FieldDefinitionBean fieldDef = (FieldDefinitionBean)defTopic;
                topic = topicList.addNewField(fieldDef.getPrimaryIdentifier(), fieldDef.getRepresentation());
            } else if (((FieldDefinitionBean)defTopic).getRepresentation().equals(StringBeanList.class)) {
                FieldDefinitionBean fieldDef = (FieldDefinitionBean)defTopic;
                topic = topicList.addNewField(fieldDef.getPrimaryIdentifier(), fieldDef.getRepresentation());
            } else if (((FieldDefinitionBean)defTopic).getRepresentation().equals(IntegerValueBean.class)) {
                FieldDefinitionBean fieldDef = (FieldDefinitionBean)defTopic;
                topic = topicList.addNewField(fieldDef.getPrimaryIdentifier(), fieldDef.getRepresentation());
            } else if (((FieldDefinitionBean)defTopic).getRepresentation().equals(BooleanValueBean.class)) {
                FieldDefinitionBean fieldDef = (FieldDefinitionBean)defTopic;
                topic = topicList.addNewField(fieldDef.getPrimaryIdentifier(), fieldDef.getRepresentation());
            } else if (((FieldDefinitionBean)defTopic).getRepresentation().equals(DateValueBean.class)) {
                FieldDefinitionBean fieldDef = (FieldDefinitionBean)defTopic;
                topic = topicList.addNewField(fieldDef.getPrimaryIdentifier(), fieldDef.getRepresentation());
            }
        } else if (defTopic instanceof HeadingDefinitionBean) {
            HeadingDefinitionBean headingDef = (HeadingDefinitionBean)defTopic;
            topic = topicList.addNewHeading(headingDef.getPrimaryIdentifier());
            this.initializeHeadingBean(topic);
        }
        if (topic != null && before != null) {
            topicList.moveBefore((Object)topic, (Object)before);
        }
    }

    private void initializeHeadingBean(HeadingBean hb) {
        for (TopicDefinitionBean headingChildDefBean : hb.getDefinition().getTopicDefinitionList()) {
            if (headingChildDefBean instanceof FieldDefinitionBean) {
                FieldDefinitionBean fieldDef;
                if (((FieldDefinitionBean)headingChildDefBean).getRepresentation().equals(StringValueBean.class)) {
                    fieldDef = (FieldDefinitionBean)headingChildDefBean;
                    hb.getTopicList().addNewField(fieldDef.getPrimaryIdentifier(), fieldDef.getRepresentation());
                    continue;
                }
                if (((FieldDefinitionBean)headingChildDefBean).getRepresentation().equals(LongStringValueBean.class)) {
                    fieldDef = (FieldDefinitionBean)headingChildDefBean;
                    hb.getTopicList().addNewField(fieldDef.getPrimaryIdentifier(), fieldDef.getRepresentation());
                    continue;
                }
                if (((FieldDefinitionBean)headingChildDefBean).getRepresentation().equals(TextBean.class)) {
                    fieldDef = (FieldDefinitionBean)headingChildDefBean;
                    hb.getTopicList().addNewField(fieldDef.getPrimaryIdentifier(), fieldDef.getRepresentation());
                    continue;
                }
                if (((FieldDefinitionBean)headingChildDefBean).getRepresentation().equals(TextBeanList.class)) {
                    fieldDef = (FieldDefinitionBean)headingChildDefBean;
                    hb.getTopicList().addNewField(fieldDef.getPrimaryIdentifier(), fieldDef.getRepresentation());
                    continue;
                }
                if (((FieldDefinitionBean)headingChildDefBean).getRepresentation().equals(StringBeanList.class)) {
                    fieldDef = (FieldDefinitionBean)headingChildDefBean;
                    hb.getTopicList().addNewField(fieldDef.getPrimaryIdentifier(), fieldDef.getRepresentation());
                    continue;
                }
                if (((FieldDefinitionBean)headingChildDefBean).getRepresentation().equals(IntegerValueBean.class)) {
                    fieldDef = (FieldDefinitionBean)headingChildDefBean;
                    hb.getTopicList().addNewField(fieldDef.getPrimaryIdentifier(), fieldDef.getRepresentation());
                    continue;
                }
                if (((FieldDefinitionBean)headingChildDefBean).getRepresentation().equals(BooleanValueBean.class)) {
                    fieldDef = (FieldDefinitionBean)headingChildDefBean;
                    hb.getTopicList().addNewField(fieldDef.getPrimaryIdentifier(), fieldDef.getRepresentation());
                    continue;
                }
                if (!((FieldDefinitionBean)headingChildDefBean).getRepresentation().equals(DateValueBean.class)) continue;
                fieldDef = (FieldDefinitionBean)headingChildDefBean;
                hb.getTopicList().addNewField(fieldDef.getPrimaryIdentifier(), fieldDef.getRepresentation());
                continue;
            }
            if (!(headingChildDefBean instanceof HeadingDefinitionBean)) continue;
            HeadingDefinitionBean headingDef = (HeadingDefinitionBean)headingChildDefBean;
            HeadingBean hcb = hb.getTopicList().addNewHeading(headingDef.getPrimaryIdentifier());
            this.initializeHeadingBean(hcb);
        }
    }
}

