/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.dmp.store.repository.client.ws.impl;

import org.openmetadata.dmp.store.repository.client.exception.ConfigurationException;
import org.openmetadata.dmp.store.repository.client.ws.DmpWebServiceClient;
import org.openmetadata.dmp.store.repository.client.ws.ServiceConfiguration;
import org.openmetadata.dmp.xml.xmlbeans.services.CommitChangesRequestDocument;
import org.openmetadata.dmp.xml.xmlbeans.services.CommitChangesResponseDocument;
import org.openmetadata.dmp.xml.xmlbeans.services.GetDefinitionsRequestDocument;
import org.openmetadata.dmp.xml.xmlbeans.services.GetDefinitionsResponseDocument;
import org.openmetadata.dmp.xml.xmlbeans.services.GetItemsRequestDocument;
import org.openmetadata.dmp.xml.xmlbeans.services.GetItemsResponseDocument;
import org.openmetadata.dmp.xml.xmlbeans.services.GetPlansRequestDocument;
import org.openmetadata.dmp.xml.xmlbeans.services.GetPlansResponseDocument;
import org.openmetadata.dmp.xml.xmlbeans.services.GetStudiesRequestDocument;
import org.openmetadata.dmp.xml.xmlbeans.services.GetStudiesResponseDocument;
import org.openmetadata.store.xml.xmlbeans.services.GetCatalogRequestDocument;
import org.openmetadata.store.xml.xmlbeans.services.GetCatalogResponseDocument;
import org.openmetadata.store.xml.xmlbeans.services.LockRequestDocument;
import org.openmetadata.store.xml.xmlbeans.services.LockResponseDocument;
import org.openmetadata.store.xml.xmlbeans.services.ReleaseLockRequestDocument;
import org.openmetadata.store.xml.xmlbeans.services.ReleaseLockResponseDocument;
import org.openmetadata.store.xml.xmlbeans.services.VerifyLocksRequestDocument;
import org.openmetadata.store.xml.xmlbeans.services.VerifyLocksResponseDocument;
import org.openmetadata.store.xml.xmlbeans.services.VerifyUserRequestDocument;
import org.openmetadata.store.xml.xmlbeans.services.VerifyUserResponseDocument;
import org.openmetadata.store.xml.xmlbeans.services.ViewLockRequestDocument;
import org.openmetadata.store.xml.xmlbeans.services.ViewLockResponseDocument;
import org.openmetadata.store.xml.xmlbeans.services.ViewLocksRequestDocument;
import org.openmetadata.store.xml.xmlbeans.services.ViewLocksResponseDocument;
import org.openmetadata.store.xml.xmlbeans.user.UserType;
import org.springframework.oxm.Marshaller;
import org.springframework.oxm.Unmarshaller;
import org.springframework.oxm.xmlbeans.XmlBeansMarshaller;
import org.springframework.ws.client.core.WebServiceTemplate;
import org.springframework.ws.transport.WebServiceMessageSender;
import org.springframework.ws.transport.http.CommonsHttpMessageSender;

public class DmpWebServiceClientImpl
implements DmpWebServiceClient {
    private final XmlBeansMarshaller xbm = new XmlBeansMarshaller();
    private final WebServiceTemplate wsTemplate;
    private final String userId;

    public DmpWebServiceClientImpl(ServiceConfiguration configuration) throws ConfigurationException {
        this.userId = configuration.getUserId();
        this.wsTemplate = new WebServiceTemplate();
        this.wsTemplate.setDefaultUri(configuration.getUrl());
        CommonsHttpMessageSender messageSender = new CommonsHttpMessageSender();
        messageSender.setCredentials(configuration.getUserCredentials());
        messageSender.setReadTimeout(10000);
        messageSender.setAcceptGzipEncoding(true);
        this.wsTemplate.setMessageSender((WebServiceMessageSender)messageSender);
        this.wsTemplate.setMarshaller((Marshaller)this.xbm);
        this.wsTemplate.setUnmarshaller((Unmarshaller)this.xbm);
        try {
            messageSender.afterPropertiesSet();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        try {
            VerifyUserRequestDocument request = VerifyUserRequestDocument.Factory.newInstance();
            UserType user = request.addNewVerifyUserRequest().addNewUser();
            user.setId(this.userId);
            VerifyUserResponseDocument response = (VerifyUserResponseDocument)this.wsTemplate.marshalSendAndReceive((Object)request);
            if (response.getVerifyUserResponse().isSetFailure()) {
                throw new ConfigurationException(configuration.getUrl(), this.userId, response.getVerifyUserResponse().getFailure());
            }
        }
        catch (Exception e) {
            throw new ConfigurationException(configuration.getUrl(), this.userId, e);
        }
        messageSender.setReadTimeout(configuration.getTimeout());
        try {
            messageSender.afterPropertiesSet();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getUrl() {
        return this.wsTemplate.getDefaultUri();
    }

    @Override
    public String getUserId() {
        return this.userId;
    }

    @Override
    public VerifyUserResponseDocument verifyUser(VerifyUserRequestDocument request) {
        return (VerifyUserResponseDocument)this.wsTemplate.marshalSendAndReceive((Object)request);
    }

    @Override
    public LockResponseDocument requestLock(LockRequestDocument request) {
        return (LockResponseDocument)this.wsTemplate.marshalSendAndReceive((Object)request);
    }

    @Override
    public ReleaseLockResponseDocument releaseLock(ReleaseLockRequestDocument request) {
        return (ReleaseLockResponseDocument)this.wsTemplate.marshalSendAndReceive((Object)request);
    }

    @Override
    public ViewLockResponseDocument getLock(ViewLockRequestDocument request) {
        return (ViewLockResponseDocument)this.wsTemplate.marshalSendAndReceive((Object)request);
    }

    @Override
    public ViewLocksResponseDocument getAllLocks(ViewLocksRequestDocument request) {
        return (ViewLocksResponseDocument)this.wsTemplate.marshalSendAndReceive((Object)request);
    }

    @Override
    public VerifyLocksResponseDocument verifyLocks(VerifyLocksRequestDocument request) {
        return (VerifyLocksResponseDocument)this.wsTemplate.marshalSendAndReceive((Object)request);
    }

    @Override
    public GetCatalogResponseDocument getCatalog(GetCatalogRequestDocument request) {
        return (GetCatalogResponseDocument)this.wsTemplate.marshalSendAndReceive((Object)request);
    }

    @Override
    public GetPlansResponseDocument getPlans(GetPlansRequestDocument request) {
        return (GetPlansResponseDocument)this.wsTemplate.marshalSendAndReceive((Object)request);
    }

    @Override
    public GetDefinitionsResponseDocument getDefinitions(GetDefinitionsRequestDocument request) {
        return (GetDefinitionsResponseDocument)this.wsTemplate.marshalSendAndReceive((Object)request);
    }

    @Override
    public GetStudiesResponseDocument getStudies(GetStudiesRequestDocument request) {
        return (GetStudiesResponseDocument)this.wsTemplate.marshalSendAndReceive((Object)request);
    }

    @Override
    public GetItemsResponseDocument getItems(GetItemsRequestDocument request) {
        return (GetItemsResponseDocument)this.wsTemplate.marshalSendAndReceive((Object)request);
    }

    @Override
    public CommitChangesResponseDocument commitChanges(CommitChangesRequestDocument request) {
        return (CommitChangesResponseDocument)this.wsTemplate.marshalSendAndReceive((Object)request);
    }
}

