/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.dmp.store.clientrepository.file;

import java.io.File;
import java.util.ArrayList;
import java.util.Set;
import java.util.UUID;
import org.apache.xmlbeans.XmlObject;
import org.openmetadata.beans.IdentifiableBean;
import org.openmetadata.beans.deserialization.MutableDeserializer;
import org.openmetadata.beans.deserialization.Populator;
import org.openmetadata.beans.factory.BeanFactory;
import org.openmetadata.beans.factory.ImplementationConstructor;
import org.openmetadata.beans.impl.MutableBeanInitializer;
import org.openmetadata.beans.serialization.Serializer;
import org.openmetadata.beans.serialization.SourceCaster;
import org.openmetadata.beans.serialization.SourceInitializer;
import org.openmetadata.beans.serialization.impl.SerializerImpl;
import org.openmetadata.beans.serialization.xml.XmlObjectCaster;
import org.openmetadata.dmp.beans.DataManagementPlanBean;
import org.openmetadata.dmp.beans.definitions.DataManagementPlanDefinitionBean;
import org.openmetadata.dmp.beans.factory.DmpBeanFactory;
import org.openmetadata.dmp.beans.factory.DmpBeanFactoryImpl;
import org.openmetadata.dmp.beans.factory.DmpFactoryImplConstructorImpl;
import org.openmetadata.dmp.beans.factory.deserializer.DmpBeanDeserializer;
import org.openmetadata.dmp.beans.factory.deserializer.DmpBeanPopulatorImpl;
import org.openmetadata.dmp.beans.factory.deserializer.DmpDeserializerImplConstructorImpl;
import org.openmetadata.dmp.beans.factory.serializer.DmpXmlPopulatorImpl;
import org.openmetadata.dmp.store.clientrepository.file.DmpOfflineRepositoryManager;
import org.openmetadata.dmp.store.manager.DmpChangeManager;
import org.openmetadata.dmp.store.repository.client.DmpClientWorkspaceRepository;
import org.openmetadata.store.access.AccessRights;
import org.openmetadata.store.access.LockInformation;
import org.openmetadata.store.access.impl.FullAccess;
import org.openmetadata.store.access.impl.ReadOnlyAccess;
import org.openmetadata.store.cache.BeanCache;
import org.openmetadata.store.catalog.ClientWorkspaceCatalog;
import org.openmetadata.store.change.ChangeSet;
import org.openmetadata.store.change.impl.ChangeSetImpl;
import org.openmetadata.store.exceptions.ExistingLockException;
import org.openmetadata.store.exceptions.StoreException;
import org.openmetadata.store.managers.AccessManager;
import org.openmetadata.store.managers.ChangeManager;
import org.openmetadata.store.managers.LocalLockManager;
import org.openmetadata.store.repository.file.container.SnapshotRepositoryImpl;
import org.openmetadata.store.repository.file.container.SnapshotRepositoryManager;
import org.openmetadata.store.repository.notification.SaveEvent;
import org.openmetadata.store.repository.notification.impl.SaveEventImpl;
import org.openmetadata.xml.report.ReportDocument;
import org.openmetadata.xml.report.definition.ReportDocument;

public class OfflineFileClientWorkspaceRepository
extends SnapshotRepositoryImpl<XmlObject>
implements DmpClientWorkspaceRepository,
AccessManager,
LocalLockManager {
    private final DmpBeanFactoryImpl factory;
    private final DmpBeanDeserializer deserializer;
    private final SerializerImpl<XmlObject> serializer;
    private DmpOfflineRepositoryManager manager;

    public OfflineFileClientWorkspaceRepository(String path, BeanCache beanCache) {
        super(String.valueOf(path) + File.separator + "offline_local");
        File metadata = new File(this.root, "md");
        if (!metadata.exists() && !metadata.mkdirs()) {
            throw new RuntimeException("Cannot create repository metadata.");
        }
        this.factory = new DmpBeanFactoryImpl();
        this.factory.setImplementationConstructor((ImplementationConstructor)new DmpFactoryImplConstructorImpl((DmpBeanFactory)this.factory, (MutableBeanInitializer)this.factory));
        this.deserializer = new DmpBeanDeserializer();
        this.deserializer.setImplementationConstructor((org.openmetadata.beans.deserialization.ImplementationConstructor)new DmpDeserializerImplConstructorImpl((DmpBeanFactory)this.factory, (MutableBeanInitializer)this.deserializer));
        this.deserializer.setPopulator((Populator)new DmpBeanPopulatorImpl((DmpBeanFactory)this.factory, (MutableBeanInitializer)this.deserializer, beanCache));
        this.serializer = new SerializerImpl<XmlObject>(){

            public Class<? extends XmlObject> getSourceClass(IdentifiableBean bean) {
                if (bean instanceof DataManagementPlanBean) {
                    return ReportDocument.class;
                }
                if (bean instanceof DataManagementPlanDefinitionBean) {
                    return org.openmetadata.xml.report.definition.ReportDocument.class;
                }
                return super.getSourceClass(bean);
            }
        };
        DmpXmlPopulatorImpl xmlPopulator = new DmpXmlPopulatorImpl();
        this.serializer.setPopulator((org.openmetadata.beans.serialization.Populator)xmlPopulator);
        this.serializer.setSourceCaster((SourceCaster)new XmlObjectCaster());
        this.serializer.setSourceInitializer((SourceInitializer)new SourceInitializer<XmlObject>(){

            public XmlObject initializeSource(Class<? extends XmlObject> targetClass, IdentifiableBean bean) {
                System.out.println("Initializing source : " + targetClass + "  " + bean.getPrimaryIdentifier());
                if (targetClass.isAssignableFrom(ReportDocument.class)) {
                    return ReportDocument.Factory.newInstance();
                }
                if (targetClass.isAssignableFrom(org.openmetadata.xml.report.definition.ReportDocument.class)) {
                    return ReportDocument.Factory.newInstance();
                }
                throw new RuntimeException("Cannot initialize source for " + targetClass);
            }
        });
    }

    public ChangeManager getNewChangeManager() {
        return new DmpChangeManager(this.getBaseContext());
    }

    public BeanFactory getNewBeanFactory() {
        return this.factory;
    }

    public MutableDeserializer<XmlObject> getNewDeserializer() {
        return this.deserializer;
    }

    public Serializer<XmlObject> getSerializer() {
        return this.serializer;
    }

    public boolean mustDeserialize() {
        return true;
    }

    public AccessManager getAccessManager() {
        return this;
    }

    public boolean exists(String id) {
        return this.contains(id);
    }

    public ClientWorkspaceCatalog getCatalog() {
        return this.getDmpOfflineRepositoryManager().getCatalog(this.workspace);
    }

    public String getBaseContext() {
        return this.getMutableManager().getBaseContext();
    }

    public ChangeSet<String> getUncommitedChanges() {
        return new ChangeSetImpl();
    }

    public synchronized String commitChanges(String id) throws StoreException {
        return this.commitAllChanges();
    }

    public synchronized String commitAllChanges() throws StoreException {
        throw new RuntimeException("Commit is not allowed in offline mode.");
    }

    public synchronized String revertChanges(String id) {
        return this.revertAllChanges();
    }

    public synchronized String revertAllChanges() {
        throw new RuntimeException("Revert is not allowed in offline mode.");
    }

    public LocalLockManager getLockManager() {
        return this;
    }

    public ClientWorkspaceCatalog refreshCatalog() {
        return this.getCatalog();
    }

    public LockInformation[] getLocks() {
        return new LockInformation[0];
    }

    public LockInformation getLockInformation(String id) {
        throw new RuntimeException("Lock information is not applicable in offline mode.");
    }

    public LockInformation requestLock(String id) throws ExistingLockException, StoreException {
        throw new RuntimeException("Locking is not applicable in offline mode.");
    }

    public void releaseLock(String id) throws StoreException {
        throw new RuntimeException("Locking is not applicable in offline mode.");
    }

    public LockInformation[] getRepositoryLocks() {
        return new LockInformation[0];
    }

    public AccessRights getRights(IdentifiableBean bean) {
        if (bean.getBeanType().isAssignableFrom(DataManagementPlanBean.class)) {
            return new FullAccess();
        }
        return new ReadOnlyAccess();
    }

    public AccessRights getRights(Class<? extends IdentifiableBean> beanClass) {
        if (beanClass.isAssignableFrom(DataManagementPlanBean.class)) {
            return new FullAccess();
        }
        return new ReadOnlyAccess();
    }

    public void setDmpOfflineRepositoryManager(DmpOfflineRepositoryManager manager) {
        if (this.manager != null && !this.manager.equals(manager)) {
            throw new RuntimeException("Manager cannot be reset.");
        }
        super.setMutableRepositoryManager((SnapshotRepositoryManager)manager);
        this.manager = manager;
    }

    protected final DmpOfflineRepositoryManager getDmpOfflineRepositoryManager() {
        if (this.manager == null) {
            throw new RuntimeException("Manager has not been set.");
        }
        return this.manager;
    }

    protected synchronized String updateLocalFiles(Set<XmlObject> updates) {
        String transactionId = UUID.randomUUID().toString();
        SnapshotRepositoryManager manager = this.getMutableManager();
        ArrayList<String> notifyList = new ArrayList<String>();
        for (XmlObject update : updates) {
            String path = manager.getFilePath(this.getBaseContext(), (Object)update);
            File updateFile = new File(this.workspace, path);
            manager.save(updateFile, (Object)update);
            notifyList.add(manager.getId((Object)update));
        }
        if (!notifyList.isEmpty()) {
            new Thread((Runnable)new SnapshotRepositoryImpl.Notifier((SnapshotRepositoryImpl)this, (SaveEvent)new SaveEventImpl(transactionId, notifyList.toArray(new String[0])))).start();
        }
        return transactionId;
    }
}

