/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.dmp.store.impl;

import org.openmetadata.dmp.store.DmpClientWorkspace;
import org.openmetadata.dmp.store.DmpClientWorkspaceProvider;
import org.openmetadata.dmp.store.clientrepository.file.DmpOfflineRepositoryManager;
import org.openmetadata.dmp.store.clientrepository.file.DmpRepositoryManager;
import org.openmetadata.dmp.store.clientrepository.file.FileClientWorkspaceRepository;
import org.openmetadata.dmp.store.clientrepository.file.OfflineFileClientWorkspaceRepository;
import org.openmetadata.dmp.store.repository.client.DmpClientWorkspaceRepository;
import org.openmetadata.dmp.store.repository.client.ws.DmpWebServiceClient;
import org.openmetadata.store.ClientWorkspace;
import org.openmetadata.store.Store;
import org.openmetadata.store.Workspace;
import org.openmetadata.store.cache.BeanCache;
import org.openmetadata.store.cache.LockingBeanCache;
import org.openmetadata.store.cache.impl.SoftLockingBeanCache;
import org.openmetadata.store.catalog.ClientWorkspaceCatalog;
import org.openmetadata.store.catalog.ClientWorkspaceNode;
import org.openmetadata.store.catalog.Node;
import org.openmetadata.store.catalog.WorkspaceNode;

public class FileClientWorkspaceProvider
implements DmpClientWorkspaceProvider {
    private final DmpClientWorkspaceRepository repository;
    private final DmpClientWorkspace workspace;

    public FileClientWorkspaceProvider(String path) {
        LockingBeanCache cache = this.constructCache();
        DmpOfflineRepositoryManager manager = this.constructOfflineManager();
        OfflineFileClientWorkspaceRepository repository = this.constructRepository(path, cache);
        repository.setDmpOfflineRepositoryManager(manager);
        this.repository = repository;
        this.workspace = this.constructWorkspace(manager.getBaseContext(), repository);
        this.workspace.setLockingBeanCache(cache);
    }

    public FileClientWorkspaceProvider(DmpWebServiceClient client, String path) {
        LockingBeanCache cache = this.constructCache();
        DmpRepositoryManager manager = this.conctructManager();
        FileClientWorkspaceRepository repository = this.constructRepository(path, cache, client);
        repository.setMutableRepositoryManager(manager);
        this.repository = repository;
        this.workspace = this.constructWorkspace(manager.getBaseContext(), repository);
        this.workspace.setLockingBeanCache(cache);
    }

    public Workspace getWorkspace(WorkspaceNode node) {
        return this.workspace;
    }

    public Store getStore(Node node) {
        return this.workspace;
    }

    public ClientWorkspaceCatalog getCatalog() {
        return this.repository.getCatalog();
    }

    public ClientWorkspace getClientWorkspace(ClientWorkspaceNode node) {
        return this.workspace;
    }

    public DmpClientWorkspaceRepository getRepository() {
        return this.repository;
    }

    protected LockingBeanCache constructCache() {
        return new SoftLockingBeanCache();
    }

    protected DmpOfflineRepositoryManager constructOfflineManager() {
        return new DmpOfflineRepositoryManager();
    }

    protected DmpRepositoryManager conctructManager() {
        return new DmpRepositoryManager();
    }

    protected OfflineFileClientWorkspaceRepository constructRepository(String path, LockingBeanCache cache) {
        return new OfflineFileClientWorkspaceRepository(path, (BeanCache)cache);
    }

    protected FileClientWorkspaceRepository constructRepository(String path, LockingBeanCache cache, DmpWebServiceClient client) {
        return new FileClientWorkspaceRepository(path, (BeanCache)cache, client);
    }

    protected DmpClientWorkspace constructWorkspace(String contextId, DmpClientWorkspaceRepository repository) {
        return new DmpClientWorkspace(contextId, true, repository);
    }
}

