/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.dmp.store.clientrepository.file;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.ddialliance.ddi_3_1.xml.xmlbeans.studyunit.StudyUnitType;
import org.openmetadata.beans.IdentifiableBean;
import org.openmetadata.beans.ddi.lifecycle.studyunit.StudyUnitBean;
import org.openmetadata.dmp.beans.DataManagementPlanBean;
import org.openmetadata.dmp.store.clientrepository.file.DmpRepositoryManager;
import org.openmetadata.store.catalog.ClientWorkspaceCatalog;
import org.openmetadata.store.catalog.Node;
import org.openmetadata.store.catalog.impl.ClientWorkspaceXmlCatalog;
import org.openmetadata.store.catalog.impl.ClientWorkspaceXmlLevel;
import org.openmetadata.store.catalog.impl.ClientWorkspaceXmlNode;
import org.openmetadata.text.ContextKey;
import org.openmetadata.text.ContextKeySet;
import org.openmetadata.text.ContextualText;
import org.openmetadata.text.ContextualTextSet;
import org.openmetadata.text.xml.ContextualTextDeserializer;
import org.openmetadata.util.xmlbeans.XmlObjectCaster;
import org.openmetadata.xml.core.NamedObjectType;
import org.openmetadata.xml.report.ReportType;

public class DmpOfflineRepositoryManager
extends DmpRepositoryManager {
    public ClientWorkspaceCatalog getCatalog(File workspace) {
        File plan;
        int n;
        int n2;
        File[] fileArray;
        ClientWorkspaceXmlCatalog catalog = new ClientWorkspaceXmlCatalog();
        ClientWorkspaceXmlLevel planLevel = new ClientWorkspaceXmlLevel(this.createTextSet("Data Managent Plans"), this.createTextSet("Data Management Plans"), "plans", null, null);
        ClientWorkspaceXmlLevel definitionLevel = new ClientWorkspaceXmlLevel(this.createTextSet("Data Managent "), this.createTextSet("Data Management Definitions"), "plans", null, null);
        ClientWorkspaceXmlLevel studyLevel = new ClientWorkspaceXmlLevel(this.createTextSet("Studies"), this.createTextSet("DDI Study Units"), "plans", null, null);
        File plansDir = new File(workspace, "plans");
        File definitionsDir = new File(workspace, "definitions");
        File studiesDir = new File(workspace, "studies");
        if (plansDir.exists()) {
            fileArray = plansDir.listFiles();
            n2 = fileArray.length;
            n = 0;
            while (n < n2) {
                plan = fileArray[n];
                planLevel.addExternalNode((Node)this.getNode(plan, planLevel));
                ++n;
            }
        }
        if (definitionsDir.exists()) {
            fileArray = definitionsDir.listFiles();
            n2 = fileArray.length;
            n = 0;
            while (n < n2) {
                File definition = fileArray[n];
                definitionLevel.addExternalNode((Node)this.getNode(definition, definitionLevel));
                ++n;
            }
        }
        if (plansDir.exists()) {
            fileArray = studiesDir.listFiles();
            n2 = fileArray.length;
            n = 0;
            while (n < n2) {
                plan = fileArray[n];
                studyLevel.addExternalNode((Node)this.getNode(plan, studyLevel));
                ++n;
            }
        }
        catalog.addLevel(planLevel);
        catalog.addLevel(definitionLevel);
        catalog.addLevel(studyLevel);
        return catalog;
    }

    protected ClientWorkspaceXmlNode getNode(File f, ClientWorkspaceXmlLevel level) {
        try {
            XmlObject xml = XmlObject.Factory.parse((File)f);
            if (XmlObjectCaster.canCast(ReportType.class, (XmlObject)xml, (boolean)false)) {
                return this.getNode(DataManagementPlanBean.class, (NamedObjectType)XmlObjectCaster.cast(ReportType.class, (XmlObject)xml), level);
            }
            if (XmlObjectCaster.canCast(org.openmetadata.xml.report.definition.ReportType.class, (XmlObject)xml, (boolean)false)) {
                return this.getNode(DataManagementPlanBean.class, (NamedObjectType)XmlObjectCaster.cast(org.openmetadata.xml.report.definition.ReportType.class, (XmlObject)xml), level);
            }
            XmlObjectCaster.canCast(StudyUnitType.class, (XmlObject)xml, (boolean)false);
            throw new RuntimeException("Invalid content in the repository: " + xml.schemaType().getName().toString());
        }
        catch (XmlException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected ClientWorkspaceXmlNode getNode(Class<? extends IdentifiableBean> beanClass, NamedObjectType xml, ClientWorkspaceXmlLevel level) {
        return new ClientWorkspaceXmlNode(xml.getId(), beanClass, ContextualTextDeserializer.deserialize((Collection)xml.getNameList()), ContextualTextDeserializer.deserialize((Collection)xml.getDocumentationList()), null, level, null);
    }

    protected ClientWorkspaceXmlNode getNode(StudyUnitType xml, ClientWorkspaceXmlLevel level) {
        return new ClientWorkspaceXmlNode(xml.getUrn(), StudyUnitBean.class, this.createTextSet(xml.getCitation().getTitleArray(0).getStringValue()), new ContextualTextSet(new ContextualText[0]), null, level, null);
    }

    protected ContextualTextSet createTextSet(String value) {
        ContextualText text = new ContextualText(new ContextKeySet(new ContextKey[0]), value, false);
        ContextualTextSet textSet = new ContextualTextSet(new ContextualText[]{text});
        return textSet;
    }
}

