/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.dmp.store.impl;

import org.openmetadata.dmp.store.DmpClientWorkspace;
import org.openmetadata.dmp.store.DmpClientWorkspaceProvider;
import org.openmetadata.dmp.store.clientrepository.file.DmpRepositoryManager;
import org.openmetadata.dmp.store.clientrepository.file.FileClientWorkspaceRepository;
import org.openmetadata.dmp.store.repository.client.DmpClientWorkspaceRepository;
import org.openmetadata.dmp.store.repository.client.ws.DmpWebServiceClient;
import org.openmetadata.store.ClientWorkspace;
import org.openmetadata.store.Store;
import org.openmetadata.store.Workspace;
import org.openmetadata.store.cache.BeanCache;
import org.openmetadata.store.cache.LockingBeanCache;
import org.openmetadata.store.cache.impl.SoftLockingBeanCache;
import org.openmetadata.store.catalog.ClientWorkspaceCatalog;
import org.openmetadata.store.catalog.ClientWorkspaceNode;
import org.openmetadata.store.catalog.Node;
import org.openmetadata.store.catalog.WorkspaceNode;

public class FileClientWorkspaceProvider
implements DmpClientWorkspaceProvider {
    private final FileClientWorkspaceRepository repository;
    private final DmpRepositoryManager manager;
    private final LockingBeanCache cache = this.constructCache();
    private final DmpClientWorkspace workspace;

    public FileClientWorkspaceProvider(DmpWebServiceClient client, String path) {
        this.manager = this.conctructManager();
        this.repository = this.constructRepository(path, this.cache, client);
        this.repository.setMutableRepositoryManager(this.manager);
        this.workspace = this.constructWorkspace(this.manager.getBaseContext(), this.repository);
        this.workspace.setLockingBeanCache(this.cache);
    }

    public Workspace getWorkspace(WorkspaceNode node) {
        return this.workspace;
    }

    public Store getStore(Node node) {
        return this.workspace;
    }

    public ClientWorkspaceCatalog getCatalog() {
        return this.repository.getCatalog();
    }

    public ClientWorkspace getClientWorkspace(ClientWorkspaceNode node) {
        return this.workspace;
    }

    public DmpClientWorkspaceRepository getRepository() {
        return this.repository;
    }

    protected LockingBeanCache constructCache() {
        return new SoftLockingBeanCache();
    }

    protected DmpRepositoryManager conctructManager() {
        return new DmpRepositoryManager();
    }

    protected FileClientWorkspaceRepository constructRepository(String path, LockingBeanCache cache, DmpWebServiceClient client) {
        return new FileClientWorkspaceRepository(path, (BeanCache)cache, client);
    }

    protected DmpClientWorkspace constructWorkspace(String contextId, DmpClientWorkspaceRepository repository) {
        return new DmpClientWorkspace(contextId, true, repository);
    }
}

