/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.dmp.store.clientrepository.file;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.ddialliance.ddi_3_1.xml.xmlbeans.studyunit.StudyUnitType;
import org.openmetadata.beans.IdentifiableBean;
import org.openmetadata.beans.deserialization.MutableDeserializer;
import org.openmetadata.beans.deserialization.Populator;
import org.openmetadata.beans.factory.BeanFactory;
import org.openmetadata.beans.factory.ImplementationConstructor;
import org.openmetadata.beans.impl.MutableBeanInitializer;
import org.openmetadata.beans.serialization.Serializer;
import org.openmetadata.beans.serialization.SourceCaster;
import org.openmetadata.beans.serialization.SourceInitializer;
import org.openmetadata.beans.serialization.impl.SerializerImpl;
import org.openmetadata.crypto.Digest;
import org.openmetadata.dmp.beans.DataManagementPlanBean;
import org.openmetadata.dmp.beans.definitions.DataManagementPlanDefinitionBean;
import org.openmetadata.dmp.beans.factory.DmpBeanFactory;
import org.openmetadata.dmp.beans.factory.DmpBeanFactoryImpl;
import org.openmetadata.dmp.beans.factory.DmpFactoryImplConstructorImpl;
import org.openmetadata.dmp.beans.factory.deserializer.DmpBeanDeserializer;
import org.openmetadata.dmp.beans.factory.deserializer.DmpBeanPopulatorImpl;
import org.openmetadata.dmp.beans.factory.deserializer.DmpDeserializerImplConstructorImpl;
import org.openmetadata.dmp.beans.factory.serializer.DmpXmlPopulatorImpl;
import org.openmetadata.dmp.store.manager.DmpChangeManager;
import org.openmetadata.dmp.store.repository.client.DmpClientWorkspaceRepository;
import org.openmetadata.dmp.store.repository.client.ws.DmpWebServiceClient;
import org.openmetadata.dmp.xml.xmlbeans.services.ChangeGroupType;
import org.openmetadata.dmp.xml.xmlbeans.services.CommitChangesRequestDocument;
import org.openmetadata.dmp.xml.xmlbeans.services.CommitChangesRequestType;
import org.openmetadata.dmp.xml.xmlbeans.services.CommitChangesResponseDocument;
import org.openmetadata.dmp.xml.xmlbeans.services.CommitChangesResponseType;
import org.openmetadata.dmp.xml.xmlbeans.services.GetItemsRequestDocument;
import org.openmetadata.dmp.xml.xmlbeans.services.GetItemsRequestType;
import org.openmetadata.dmp.xml.xmlbeans.services.GetItemsResponseDocument;
import org.openmetadata.dmp.xml.xmlbeans.services.GetItemsResponseType;
import org.openmetadata.dmp.xml.xmlbeans.services.IdentifierTypeType;
import org.openmetadata.store.access.AccessRights;
import org.openmetadata.store.access.LockInformation;
import org.openmetadata.store.access.impl.FullAccess;
import org.openmetadata.store.access.impl.ReadOnlyAccess;
import org.openmetadata.store.access.impl.XmlLockInformation;
import org.openmetadata.store.cache.BeanCache;
import org.openmetadata.store.catalog.ClientWorkspaceCatalog;
import org.openmetadata.store.catalog.Node;
import org.openmetadata.store.catalog.impl.AClientWorkspaceLevelImpl;
import org.openmetadata.store.catalog.impl.AClientWorkspaceNodeImpl;
import org.openmetadata.store.catalog.impl.CatalogComparer;
import org.openmetadata.store.catalog.impl.CatalogHandler;
import org.openmetadata.store.catalog.impl.ClientWorkspaceXmlCatalog;
import org.openmetadata.store.catalog.impl.ClientWorkspaceXmlLevel;
import org.openmetadata.store.catalog.impl.ClientWorkspaceXmlNode;
import org.openmetadata.store.change.ChangeSet;
import org.openmetadata.store.change.impl.ChangeSetImpl;
import org.openmetadata.store.exceptions.ExistingLockException;
import org.openmetadata.store.exceptions.ObjectNotFoundException;
import org.openmetadata.store.exceptions.StoreException;
import org.openmetadata.store.managers.AccessManager;
import org.openmetadata.store.managers.ChangeManager;
import org.openmetadata.store.managers.LocalLockManager;
import org.openmetadata.store.repository.file.container.SnapshotRepositoryImpl;
import org.openmetadata.store.repository.file.container.SnapshotRepositoryManager;
import org.openmetadata.store.repository.notification.SaveEvent;
import org.openmetadata.store.repository.notification.impl.SaveEventImpl;
import org.openmetadata.store.xml.xmlbeans.catalog.CatalogDocument;
import org.openmetadata.store.xml.xmlbeans.catalog.CatalogType;
import org.openmetadata.store.xml.xmlbeans.change.ChangeSetDocument;
import org.openmetadata.store.xml.xmlbeans.change.ChangeSetType;
import org.openmetadata.store.xml.xmlbeans.lock.LockDetailsDocument;
import org.openmetadata.store.xml.xmlbeans.lock.LockDetailsType;
import org.openmetadata.store.xml.xmlbeans.lock.LockInformationType;
import org.openmetadata.store.xml.xmlbeans.services.GetCatalogRequestDocument;
import org.openmetadata.store.xml.xmlbeans.services.GetCatalogRequestType;
import org.openmetadata.store.xml.xmlbeans.services.GetCatalogResponseDocument;
import org.openmetadata.store.xml.xmlbeans.services.LockRequestDocument;
import org.openmetadata.store.xml.xmlbeans.services.LockRequestType;
import org.openmetadata.store.xml.xmlbeans.services.LockResponseDocument;
import org.openmetadata.store.xml.xmlbeans.services.LockResponseType;
import org.openmetadata.store.xml.xmlbeans.services.LockValidityType;
import org.openmetadata.store.xml.xmlbeans.services.ReleaseLockRequestDocument;
import org.openmetadata.store.xml.xmlbeans.services.ReleaseLockRequestType;
import org.openmetadata.store.xml.xmlbeans.services.ReleaseLockResponseDocument;
import org.openmetadata.store.xml.xmlbeans.services.ReleaseLockResponseType;
import org.openmetadata.store.xml.xmlbeans.services.VerifyLocksRequestDocument;
import org.openmetadata.store.xml.xmlbeans.services.VerifyLocksRequestType;
import org.openmetadata.store.xml.xmlbeans.services.VerifyLocksResponseDocument;
import org.openmetadata.store.xml.xmlbeans.services.VerifyLocksResponseType;
import org.openmetadata.store.xml.xmlbeans.services.ViewLockRequestDocument;
import org.openmetadata.store.xml.xmlbeans.services.ViewLockRequestType;
import org.openmetadata.store.xml.xmlbeans.services.ViewLockResponseDocument;
import org.openmetadata.store.xml.xmlbeans.services.ViewLockResponseType;
import org.openmetadata.store.xml.xmlbeans.services.ViewLocksRequestDocument;
import org.openmetadata.store.xml.xmlbeans.services.ViewLocksRequestType;
import org.openmetadata.store.xml.xmlbeans.services.ViewLocksResponseDocument;
import org.openmetadata.store.xml.xmlbeans.services.ViewLocksResponseType;
import org.openmetadata.store.xml.xmlbeans.user.UserType;
import org.openmetadata.util.xmlbeans.XhtmlUtilities;
import org.openmetadata.util.xmlbeans.XmlObjectCaster;
import org.openmetadata.ws.core.IdentifierType;
import org.openmetadata.xml.report.ReportDocument;
import org.openmetadata.xml.report.ReportType;
import org.openmetadata.xml.report.definition.ReportDocument;

public class FileClientWorkspaceRepository
extends SnapshotRepositoryImpl<XmlObject>
implements DmpClientWorkspaceRepository,
AccessManager,
LocalLockManager {
    private final File changes;
    private final File locks;
    private final File cacheCatalog;
    private final UserType user;
    private final DmpWebServiceClient client;
    private final DmpBeanFactoryImpl factory;
    private final DmpBeanDeserializer deserializer;
    private final SerializerImpl<XmlObject> serializer;
    private final ChangeSetImpl<String> uncommittedChanges;
    private final HashMap<String, XmlLockInformation> localLocks;
    private boolean locksInitialized;
    private boolean changesInitialized;
    private CatalogType sharedCatalog;

    public FileClientWorkspaceRepository(String path, BeanCache beanCache, DmpWebServiceClient client) {
        super(String.valueOf(path) + File.separator + Digest.md5((String)(String.valueOf(client.getUrl()) + client.getUserId())));
        File metadata = new File(this.root, "md");
        if (!metadata.exists() && !metadata.mkdirs()) {
            throw new RuntimeException("Cannot create repository metadata.");
        }
        this.changes = new File(metadata, "uncommitted");
        this.locks = new File(metadata, "locks");
        this.cacheCatalog = new File(metadata, "catalog");
        this.client = client;
        File userXml = new File(metadata, "user");
        try {
            String userId = client.getUserId();
            if (userXml.exists()) {
                this.user = UserType.Factory.parse((File)userXml);
                if (!this.user.getId().equals(userId)) {
                    throw new RuntimeException("User (" + userId + ") does not match the previous user for the workspace (" + this.user.getId() + ")");
                }
            } else {
                this.user = UserType.Factory.newInstance();
                this.user.setId(userId);
                this.user.setLocation(UUID.randomUUID().toString());
                this.user.save(userXml);
            }
        }
        catch (XmlException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.uncommittedChanges = new ChangeSetImpl();
        this.localLocks = new HashMap();
        this.factory = new DmpBeanFactoryImpl();
        this.factory.setImplementationConstructor((ImplementationConstructor)new DmpFactoryImplConstructorImpl((DmpBeanFactory)this.factory, (MutableBeanInitializer)this.factory));
        this.deserializer = new DmpBeanDeserializer();
        this.deserializer.setImplementationConstructor((org.openmetadata.beans.deserialization.ImplementationConstructor)new DmpDeserializerImplConstructorImpl((DmpBeanFactory)this.factory, (MutableBeanInitializer)this.deserializer));
        this.deserializer.setPopulator((Populator)new DmpBeanPopulatorImpl((DmpBeanFactory)this.factory, (MutableBeanInitializer)this.deserializer, beanCache));
        this.serializer = new SerializerImpl<XmlObject>(){

            public Class<? extends XmlObject> getSourceClass(IdentifiableBean bean) {
                if (bean instanceof DataManagementPlanBean) {
                    return ReportDocument.class;
                }
                if (bean instanceof DataManagementPlanDefinitionBean) {
                    return org.openmetadata.xml.report.definition.ReportDocument.class;
                }
                return super.getSourceClass(bean);
            }
        };
        DmpXmlPopulatorImpl xmlPopulator = new DmpXmlPopulatorImpl();
        this.serializer.setPopulator((org.openmetadata.beans.serialization.Populator)xmlPopulator);
        this.serializer.setSourceCaster((SourceCaster)new org.openmetadata.beans.serialization.xml.XmlObjectCaster());
        this.serializer.setSourceInitializer((SourceInitializer)new SourceInitializer<XmlObject>(){

            public XmlObject initializeSource(Class<? extends XmlObject> targetClass, IdentifiableBean bean) {
                System.out.println("Initializing source : " + targetClass + "  " + bean.getPrimaryIdentifier());
                if (targetClass.isAssignableFrom(ReportDocument.class)) {
                    return ReportDocument.Factory.newInstance();
                }
                if (targetClass.isAssignableFrom(org.openmetadata.xml.report.definition.ReportDocument.class)) {
                    return ReportDocument.Factory.newInstance();
                }
                throw new RuntimeException("Cannot initialize source for " + targetClass);
            }
        });
    }

    public ChangeManager getNewChangeManager() {
        return new DmpChangeManager(this.getBaseContext());
    }

    public BeanFactory getNewBeanFactory() {
        return this.factory;
    }

    public MutableDeserializer<XmlObject> getNewDeserializer() {
        return this.deserializer;
    }

    public Serializer<XmlObject> getSerializer() {
        return this.serializer;
    }

    public boolean mustDeserialize() {
        return true;
    }

    public AccessManager getAccessManager() {
        return this;
    }

    public XmlObject get(String id) throws ObjectNotFoundException {
        if (!this.contains(id)) {
            this.getServerItems(false, id);
        }
        return (XmlObject)super.get(id);
    }

    public Set<XmlObject> get(Set<String> ids) throws ObjectNotFoundException {
        HashSet<String> missingIds = new HashSet<String>();
        for (String id : ids) {
            if (this.contains(id)) continue;
            missingIds.add(id);
        }
        if (!missingIds.isEmpty()) {
            this.getServerItems(false, missingIds.toArray(new String[0]));
        }
        return super.get(missingIds);
    }

    public ClientWorkspaceCatalog getCatalog() {
        ClientWorkspaceXmlCatalog catalog;
        if (this.sharedCatalog == null) {
            this.refreshSharedCatalog();
        }
        try {
            catalog = new ClientWorkspaceXmlCatalog(this.sharedCatalog);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        ChangeSet<String> changes = this.getUncommitedChanges();
        if (changes.getAdditions().size() > 0) {
            ClientWorkspaceXmlLevel planLevel = null;
            ClientWorkspaceXmlLevel[] clientWorkspaceXmlLevelArray = catalog.getLevels();
            int n = clientWorkspaceXmlLevelArray.length;
            int n2 = 0;
            while (n2 < n) {
                ClientWorkspaceXmlLevel level = clientWorkspaceXmlLevelArray[n2];
                if (level.getContextId().equals("plans")) {
                    planLevel = level;
                    break;
                }
                ++n2;
            }
            if (planLevel == null) {
                throw new RuntimeException("Plan level not found in remote catalog.");
            }
            for (String addition : changes.getAdditions()) {
                ReportType plan;
                if (!addition.startsWith("urn:dmp:plan:")) continue;
                try {
                    plan = (ReportType)XmlObjectCaster.cast(ReportType.class, (XmlObject)this.get(addition));
                }
                catch (ObjectNotFoundException e) {
                    throw new RuntimeException(e);
                }
                planLevel.addExternalNode((Node)new ClientWorkspaceXmlNode(plan.getId(), DataManagementPlanBean.class, XhtmlUtilities.getMixedContent((XmlObject)((XmlObject)plan.getNameList().get(0))), plan.getDocumentationList().size() > 0 ? XhtmlUtilities.getMixedContent((XmlObject)((XmlObject)plan.getDocumentationList().get(0))) : null, plan.getId(), null, null));
            }
        }
        ClientWorkspaceXmlNode[] clientWorkspaceXmlNodeArray = catalog.getNodes();
        int n = clientWorkspaceXmlNodeArray.length;
        int n3 = 0;
        while (n3 < n) {
            ClientWorkspaceXmlNode node = clientWorkspaceXmlNodeArray[n3];
            CatalogHandler.processNode((AClientWorkspaceNodeImpl)node, changes, this.getLocalLocks());
            ++n3;
        }
        clientWorkspaceXmlNodeArray = catalog.getLevels();
        n = clientWorkspaceXmlNodeArray.length;
        n3 = 0;
        while (n3 < n) {
            ClientWorkspaceXmlNode level = clientWorkspaceXmlNodeArray[n3];
            CatalogHandler.processLevel((AClientWorkspaceLevelImpl)level, changes, this.getLocalLocks());
            ++n3;
        }
        return catalog;
    }

    public String getBaseContext() {
        return this.getMutableManager().getBaseContext();
    }

    public synchronized String save(String contextId, Set<XmlObject> additions, Set<XmlObject> updates, Set<XmlObject> deletions) throws StoreException {
        return this.save(contextId, additions, updates, deletions, null);
    }

    public synchronized String save(String contextId, Set<XmlObject> additions, Set<XmlObject> updates, Set<XmlObject> deletions, String comment) throws StoreException {
        String transactionId = super.save(contextId, additions, updates, deletions, comment);
        this.processChanges(additions, updates, deletions);
        return transactionId;
    }

    public ChangeSet<String> getUncommitedChanges() {
        return this.getLocalChanges();
    }

    public synchronized String commitChanges(String id) throws StoreException {
        ChangeSetImpl changes = new ChangeSetImpl();
        ChangeSet<String> localChanges = this.getLocalChanges();
        if (localChanges.getAdditions().contains(id)) {
            changes.addAddition((Object)id);
        } else if (localChanges.getDeletions().contains(id)) {
            changes.addDeletion((Object)id);
        } else if (localChanges.getUpdates().contains(id)) {
            changes.addUpdate((Object)id);
        }
        return this.commitChanges((ChangeSet<String>)changes);
    }

    public synchronized String commitAllChanges() throws StoreException {
        return this.commitChanges(this.getLocalChanges());
    }

    public synchronized String revertChanges(String id) {
        ChangeSetImpl changes = new ChangeSetImpl();
        ChangeSet<String> localChanges = this.getLocalChanges();
        if (localChanges.getAdditions().contains(id)) {
            changes.addAddition((Object)id);
        } else if (localChanges.getDeletions().contains(id)) {
            changes.addDeletion((Object)id);
        } else if (localChanges.getUpdates().contains(id)) {
            changes.addUpdate((Object)id);
        }
        return this.revertChanges((ChangeSet<String>)changes);
    }

    public synchronized String revertAllChanges() {
        return this.revertChanges(this.getLocalChanges());
    }

    public LocalLockManager getLockManager() {
        return this;
    }

    public ClientWorkspaceCatalog refreshCatalog() {
        this.refreshSharedCatalog();
        return this.getCatalog();
    }

    public LockInformation[] getLocks() {
        return this.getLocalLocks().values().toArray(new LockInformation[0]);
    }

    public LockInformation getLockInformation(String id) {
        ViewLockRequestDocument request = ViewLockRequestDocument.Factory.newInstance();
        ViewLockRequestType requestXml = request.addNewViewLockRequest();
        requestXml.setItemID(id);
        requestXml.setUser(this.user);
        ViewLockResponseDocument response = this.client.getLock(request);
        ViewLockResponseType responseXml = response.getViewLockResponse();
        if (responseXml.isSetFailure()) {
            throw new RuntimeException(responseXml.getFailure());
        }
        if (responseXml.isSetNone()) {
            throw new RuntimeException("Item (" + id + ") is not locked.");
        }
        return new XmlLockInformation(responseXml.getLockInformation());
    }

    public LockInformation requestLock(String id) throws ExistingLockException, StoreException {
        LockRequestDocument request = LockRequestDocument.Factory.newInstance();
        LockRequestType requestXml = request.addNewLockRequest();
        requestXml.setItemID(id);
        requestXml.setUser(this.user);
        LockResponseDocument response = this.client.requestLock(request);
        LockResponseType responseXml = response.getLockResponse();
        if (responseXml.isSetFailure()) {
            throw new StoreException(responseXml.getFailure());
        }
        if (responseXml.isSetAlreadyLocked()) {
            throw new ExistingLockException((LockInformation)new XmlLockInformation(responseXml.getAlreadyLocked()));
        }
        LockInformationType lockXml = responseXml.getGranted();
        XmlLockInformation lock = new XmlLockInformation(lockXml);
        this.getLocalLocks().put(lock.getPrimaryIdentifier(), lock);
        this.getServerItems(false, id);
        this.saveLocks();
        return lock;
    }

    public void releaseLock(String id) throws StoreException {
        ReleaseLockRequestDocument request = ReleaseLockRequestDocument.Factory.newInstance();
        ReleaseLockRequestType requestXml = request.addNewReleaseLockRequest();
        LockInformationType lockXml = this.getLocalLocks().get(id).getLockXml();
        requestXml.setLockInformation(lockXml);
        ReleaseLockResponseDocument response = this.client.releaseLock(request);
        ReleaseLockResponseType responseXml = response.getReleaseLockResponse();
        if (responseXml.isSetFailure()) {
            throw new StoreException(responseXml.getFailure());
        }
        this.getLocalLocks().remove(id);
        this.saveLocks();
    }

    public LockInformation[] getRepositoryLocks() {
        ViewLocksRequestDocument request = ViewLocksRequestDocument.Factory.newInstance();
        ViewLocksRequestType requestXml = request.addNewViewLocksRequest();
        requestXml.setUser(this.user);
        ViewLocksResponseDocument response = this.client.getAllLocks(request);
        ViewLocksResponseType responseXml = response.getViewLocksResponse();
        if (responseXml.isSetFailure()) {
            throw new RuntimeException(responseXml.getFailure());
        }
        if (responseXml.isSetNone()) {
            return new LockInformation[0];
        }
        ArrayList<XmlLockInformation> lockList = new ArrayList<XmlLockInformation>();
        for (LockInformationType lockXml : responseXml.getLockInformationList()) {
            lockList.add(new XmlLockInformation(lockXml));
        }
        return lockList.toArray(new LockInformation[0]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public AccessRights getRights(IdentifiableBean bean) {
        String id = bean.getContainerIdentifier();
        Map<String, XmlLockInformation> locks = this.getLocalLocks();
        ChangeSet<String> changes = this.getLocalChanges();
        if (locks.containsKey(id)) {
            LockInformation lockInfo = (LockInformation)locks.get(id);
            if (!lockInfo.isLocked()) return new ReadOnlyAccess();
            if (!lockInfo.hasExpirationTime()) return new FullAccess();
            if (!lockInfo.getExpirationTime().after(Calendar.getInstance())) return new ReadOnlyAccess();
            return new FullAccess();
        }
        if (!changes.getAdditions().contains(id) && !changes.getDeletions().contains(id) && !changes.getUpdates().contains(id)) return new ReadOnlyAccess();
        return new FullAccess();
    }

    public AccessRights getRights(Class<? extends IdentifiableBean> beanClass) {
        if (beanClass.isAssignableFrom(DataManagementPlanBean.class)) {
            return new FullAccess();
        }
        return new ReadOnlyAccess();
    }

    protected ChangeSet<String> getLocalChanges() {
        if (!this.changesInitialized && this.changes.exists()) {
            try {
                ChangeSetDocument changesDoc = ChangeSetDocument.Factory.parse((File)this.changes);
                ChangeSetType xml = changesDoc.getChangeSet();
                for (String id : xml.getAdditionsList()) {
                    this.uncommittedChanges.getAdditions().add(id);
                }
                for (String id : xml.getDeletionsList()) {
                    this.uncommittedChanges.getDeletions().add(id);
                }
                for (String id : xml.getUpdatesList()) {
                    this.uncommittedChanges.getUpdates().add(id);
                }
                this.changesInitialized = true;
            }
            catch (XmlException e) {
                throw new RuntimeException(e);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        this.changesInitialized = true;
        return this.uncommittedChanges;
    }

    protected void processChanges(Set<XmlObject> additions, Set<XmlObject> updates, Set<XmlObject> deletions) {
        String id;
        SnapshotRepositoryManager manager = this.getMutableManager();
        ChangeSet<String> changes = this.getLocalChanges();
        for (XmlObject update : updates) {
            id = manager.getId((Object)update);
            if (changes.getAdditions().contains(id)) continue;
            changes.getUpdates().add(id);
        }
        for (XmlObject addition : additions) {
            id = manager.getId((Object)addition);
            changes.getAdditions().add(id);
        }
        for (XmlObject deletion : deletions) {
            id = manager.getId((Object)deletion);
            if (changes.getAdditions().contains(id)) {
                changes.getAdditions().remove(id);
                continue;
            }
            changes.getDeletions().add(id);
        }
        this.saveLocalChanges();
    }

    protected void saveLocalChanges() {
        ChangeSet<String> changes = this.getLocalChanges();
        ChangeSetDocument doc = ChangeSetDocument.Factory.newInstance();
        ChangeSetType xml = doc.addNewChangeSet();
        for (String id : changes.getAdditions()) {
            xml.addAdditions(id);
        }
        for (String id : changes.getUpdates()) {
            xml.addUpdates(id);
        }
        for (String id : changes.getDeletions()) {
            xml.addDeletions(id);
        }
        try {
            doc.save(this.changes);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected Map<String, XmlLockInformation> getLocalLocks() {
        if (!this.locksInitialized) {
            VerifyLocksRequestDocument request = VerifyLocksRequestDocument.Factory.newInstance();
            VerifyLocksRequestType requestXml = request.addNewVerifyLocksRequest();
            LockInformationType[] lockInformationTypeArray = this.getStoredLocks();
            int n = lockInformationTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                LockInformationType lockXml = lockInformationTypeArray[n2];
                requestXml.getLockInformationList().add(lockXml);
                ++n2;
            }
            VerifyLocksResponseDocument response = this.client.verifyLocks(request);
            VerifyLocksResponseType responseXml = response.getVerifyLocksResponse();
            for (LockValidityType lockValidity : responseXml.getLockValidityList()) {
                if (!lockValidity.getValid()) continue;
                XmlLockInformation lock = new XmlLockInformation((LockInformationType)lockValidity);
                this.localLocks.put(lock.getPrimaryIdentifier(), lock);
            }
            this.locksInitialized = true;
            this.saveLocks();
        }
        return this.localLocks;
    }

    protected void saveLocks() {
        LockDetailsDocument locksDoc = LockDetailsDocument.Factory.newInstance();
        LockDetailsType locksXml = locksDoc.addNewLockDetails();
        for (XmlLockInformation lockInfo : this.getLocalLocks().values()) {
            locksXml.getLockInformationList().add(lockInfo.getLockXml());
        }
        try {
            locksDoc.save(this.locks);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected LockInformationType[] getStoredLocks() {
        if (this.locks.exists()) {
            try {
                LockDetailsDocument locksDoc = LockDetailsDocument.Factory.parse((File)this.locks);
                return locksDoc.getLockDetails().getLockInformationList().toArray(new LockInformationType[0]);
            }
            catch (XmlException e) {
                throw new RuntimeException(e);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return new LockInformationType[0];
    }

    protected synchronized String updateLocalFiles(Set<XmlObject> updates) {
        String transactionId = UUID.randomUUID().toString();
        SnapshotRepositoryManager manager = this.getMutableManager();
        ArrayList<String> notifyList = new ArrayList<String>();
        for (XmlObject update : updates) {
            String path = manager.getFilePath(this.getBaseContext(), (Object)update);
            File updateFile = new File(this.workspace, path);
            manager.save(updateFile, (Object)update);
            notifyList.add(manager.getId((Object)update));
        }
        if (!notifyList.isEmpty()) {
            new Thread((Runnable)new SnapshotRepositoryImpl.Notifier((SnapshotRepositoryImpl)this, (SaveEvent)new SaveEventImpl(transactionId, notifyList.toArray(new String[0])))).start();
        }
        return transactionId;
    }

    protected synchronized String getServerItems(boolean forceUpdate, String ... ids) {
        org.openmetadata.xml.report.definition.ReportType local;
        GetItemsRequestDocument request = GetItemsRequestDocument.Factory.newInstance();
        GetItemsRequestType requestXml = request.addNewGetItemsRequest();
        requestXml.setUser(this.user);
        String[] stringArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            IdentifierType identifier = requestXml.addNewIdentifier();
            identifier.setStringValue(id);
            if (id.startsWith("urn:dmp:plan:")) {
                identifier.setType(IdentifierTypeType.DMP.toString());
            } else if (id.startsWith("urn:dmp:definition:")) {
                identifier.setType(IdentifierTypeType.DMP.toString());
            } else if (id.startsWith("urn:ddi")) {
                identifier.setType(IdentifierTypeType.DDI.toString());
            }
            ++n2;
        }
        GetItemsResponseDocument response = this.client.getItems(request);
        GetItemsResponseType responseXml = response.getGetItemsResponse();
        if (responseXml.isSetFailure()) {
            throw new RuntimeException(responseXml.getFailure());
        }
        HashSet<XmlObject> additions = new HashSet<XmlObject>();
        for (org.openmetadata.xml.report.definition.ReportType xml : responseXml.getReportList()) {
            if (this.contains(xml.getId())) {
                try {
                    local = (org.openmetadata.xml.report.definition.ReportType)XmlObjectCaster.cast(org.openmetadata.xml.report.definition.ReportType.class, (XmlObject)this.get(xml.getId()));
                    if (!local.isSetVersionDate() || local.getVersionDate().before(xml.getVersionDate())) {
                        additions.add((XmlObject)xml);
                        continue;
                    }
                    if (!forceUpdate) continue;
                    additions.add((XmlObject)xml);
                    continue;
                }
                catch (ObjectNotFoundException e) {
                    throw new RuntimeException("Expected item not foud.", e);
                }
            }
            additions.add((XmlObject)xml);
        }
        for (org.openmetadata.xml.report.definition.ReportType xml : responseXml.getReport2List()) {
            if (this.contains(xml.getId())) {
                try {
                    local = (ReportType)XmlObjectCaster.cast(ReportType.class, (XmlObject)this.get(xml.getId()));
                    if (!local.isSetVersionDate() || local.getVersionDate().before(xml.getVersionDate())) {
                        additions.add((XmlObject)xml);
                        continue;
                    }
                    if (!forceUpdate) continue;
                    additions.add((XmlObject)xml);
                    continue;
                }
                catch (ObjectNotFoundException e) {
                    throw new RuntimeException("Expected item not foud.", e);
                }
            }
            additions.add((XmlObject)xml);
        }
        for (org.openmetadata.xml.report.definition.ReportType xml : responseXml.getStudyUnitList()) {
            if (this.contains(xml.getUrn())) {
                try {
                    local = (StudyUnitType)XmlObjectCaster.cast(StudyUnitType.class, (XmlObject)this.get(xml.getId()));
                    if (!local.isSetVersionDate() || ((Calendar)local.getVersionDate()).before((Calendar)xml.getVersionDate())) {
                        additions.add((XmlObject)xml);
                        continue;
                    }
                    if (!forceUpdate) continue;
                    additions.add((XmlObject)xml);
                    continue;
                }
                catch (ObjectNotFoundException e) {
                    throw new RuntimeException("Expected item not foud.", e);
                }
            }
            additions.add((XmlObject)xml);
        }
        return this.updateLocalFiles(additions);
    }

    protected synchronized String revertChanges(ChangeSet<String> changes) {
        HashSet updates = new HashSet();
        updates.addAll(changes.getDeletions());
        updates.addAll(changes.getUpdates());
        String transactionId = this.getServerItems(true, updates.toArray(new String[0]));
        if (!changes.getAdditions().isEmpty()) {
            SnapshotRepositoryManager manager = this.getMutableManager();
            for (String addition : changes.getAdditions()) {
                new File(this.workspace, manager.getContainerFilePath(addition)).delete();
            }
        }
        this.updateChangeInformation(changes);
        return transactionId;
    }

    protected synchronized String commitChanges(ChangeSet<String> changes) {
        CommitChangesRequestDocument request = CommitChangesRequestDocument.Factory.newInstance();
        CommitChangesRequestType requestXml = request.addNewCommitChangesRequest();
        requestXml.setContextId(this.getBaseContext());
        requestXml.setUser(this.user);
        for (String deletion : changes.getDeletions()) {
            requestXml.addDeletion(deletion);
        }
        try {
            if (changes.getAdditions().size() > 0) {
                this.populateCommitSet(requestXml.addNewAdditions(), changes.getAdditions());
            }
            if (changes.getUpdates().size() > 0) {
                this.populateCommitSet(requestXml.addNewUpdates(), changes.getUpdates());
            }
        }
        catch (ObjectNotFoundException e) {
            throw new RuntimeException("Object to commit was not found.", e);
        }
        CommitChangesResponseDocument response = this.client.commitChanges(request);
        CommitChangesResponseType responseXml = response.getCommitChangesResponse();
        if (responseXml.isSetFailure()) {
            throw new RuntimeException(responseXml.getFailure());
        }
        HashSet<XmlObject> updates = new HashSet<XmlObject>();
        for (XmlObject update : responseXml.getReportList()) {
            updates.add(update);
        }
        for (XmlObject update : responseXml.getReport2List()) {
            updates.add(update);
        }
        for (XmlObject update : responseXml.getStudyUnitList()) {
            updates.add(update);
        }
        String transactionId = this.updateLocalFiles(updates);
        this.updateChangeInformation(changes);
        this.refreshSharedCatalog();
        return transactionId;
    }

    protected void updateChangeInformation(ChangeSet<String> changes) {
        ChangeSet<String> localChanges = this.getLocalChanges();
        localChanges.getAdditions().removeAll(changes.getAdditions());
        localChanges.getDeletions().removeAll(changes.getDeletions());
        localChanges.getUpdates().removeAll(changes.getUpdates());
        this.saveLocalChanges();
    }

    private void populateCommitSet(ChangeGroupType changeGroup, Set<String> ids) throws ObjectNotFoundException {
        for (String id : ids) {
            XmlObject xml = this.get(id);
            if (id.startsWith("urn:dmp:plan:")) {
                if (XmlObjectCaster.canCast(ReportType.class, (XmlObject)xml, (boolean)false)) {
                    changeGroup.getReport2List().add((ReportType)XmlObjectCaster.cast(ReportType.class, (XmlObject)xml));
                    continue;
                }
                throw new RuntimeException("Unexpected document type for plan (" + xml.schemaType().getName().toString() + ")");
            }
            if (id.startsWith("urn:dmp:definition:")) {
                if (XmlObjectCaster.canCast(org.openmetadata.xml.report.definition.ReportType.class, (XmlObject)xml, (boolean)false)) {
                    changeGroup.getReportList().add((org.openmetadata.xml.report.definition.ReportType)XmlObjectCaster.cast(org.openmetadata.xml.report.definition.ReportType.class, (XmlObject)xml));
                    continue;
                }
                throw new RuntimeException("Unexpected document type for definition (" + xml.schemaType().getName().toString() + ")");
            }
            if (!id.startsWith("urn:ddi")) continue;
            if (XmlObjectCaster.canCast(StudyUnitType.class, (XmlObject)xml, (boolean)false)) {
                changeGroup.getStudyUnitList().add((StudyUnitType)XmlObjectCaster.cast(StudyUnitType.class, (XmlObject)xml));
                continue;
            }
            throw new RuntimeException("Unexpected document type for study (" + xml.schemaType().getName().toString() + ")");
        }
    }

    protected CatalogType getCachedCatalog() {
        if (this.cacheCatalog.exists()) {
            try {
                CatalogDocument catalog = CatalogDocument.Factory.parse((File)this.cacheCatalog);
                return catalog.getCatalog();
            }
            catch (XmlException e) {
                throw new RuntimeException(e);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return CatalogType.Factory.newInstance();
    }

    protected void saveCachedCatalog(CatalogType catalog) {
        CatalogDocument catalogDocument = CatalogDocument.Factory.newInstance();
        catalogDocument.setCatalog(catalog);
        try {
            catalogDocument.save(this.cacheCatalog);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void refreshSharedCatalog() {
        GetCatalogRequestDocument request = GetCatalogRequestDocument.Factory.newInstance();
        GetCatalogRequestType requestXml = request.addNewGetCatalogRequest();
        requestXml.setUser(this.user);
        requestXml.addNewAll();
        GetCatalogResponseDocument response = this.client.getCatalog(request);
        this.sharedCatalog = response.getGetCatalogResponse().getCatalog();
        CatalogType cacheCatalog = this.getCachedCatalog();
        ChangeSet changes = CatalogComparer.compareForUpdates((CatalogType)cacheCatalog, (CatalogType)this.sharedCatalog);
        SnapshotRepositoryManager manager = this.getMutableManager();
        ChangeSet<String> localChanges = this.getLocalChanges();
        for (String deletion : changes.getDeletions()) {
            if (localChanges.getUpdates().contains(deletion)) {
                localChanges.getUpdates().remove(deletion);
                localChanges.getAdditions().add(deletion);
                continue;
            }
            File f = new File(this.workspace, manager.getContainerFilePath(deletion));
            f.delete();
        }
        if (!changes.getUpdates().isEmpty()) {
            this.getServerItems(false, changes.getUpdates().toArray(new String[0]));
        }
        this.saveCachedCatalog(this.sharedCatalog);
    }
}

