/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.dmp.beans.impl;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.openmetadata.beans.IdentifiableBean;
import org.openmetadata.beans.exceptions.ResolverException;
import org.openmetadata.beans.impl.MutableBeanInitializer;
import org.openmetadata.beans.notification.ChangeListener;
import org.openmetadata.dmp.beans.FieldBean;
import org.openmetadata.dmp.beans.FieldValueBean;
import org.openmetadata.dmp.beans.TopicBean;
import org.openmetadata.dmp.beans.definitions.FieldDefinitionBean;
import org.openmetadata.dmp.beans.factory.DmpBeanFactory;
import org.openmetadata.dmp.beans.impl.TopicBeanImpl;

public class FieldBeanImpl<Representation extends FieldValueBean>
extends TopicBeanImpl
implements FieldBean<Representation> {
    private FieldDefinitionBean<Representation> cachedDefinition;
    private String definitionID;
    private Representation value;
    private TopicBean parent;

    public FieldBeanImpl(boolean newInstance, String id, DmpBeanFactory factory, MutableBeanInitializer initializer, String definitionID, TopicBean parent) {
        this(newInstance, id, id, factory, initializer, definitionID, parent);
    }

    public FieldBeanImpl(boolean newInstance, String id, String containerId, DmpBeanFactory factory, MutableBeanInitializer initializer, String definitionID, TopicBean parent) {
        super(newInstance, id, containerId, factory, initializer);
        this.definitionID = definitionID;
        this.parent = parent;
    }

    @Override
    public void initSetDefinition(FieldDefinitionBean<Representation> definition) {
        try {
            Field field = definition.getRepresentation().getField("Factory");
            Object fieldObj = field.get(definition);
            Method m = definition.getRepresentation().getField("Factory").getType().getMethod("createNew", ChangeListener.class);
            this.value = (FieldValueBean)m.invoke(fieldObj, this);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        this.cachedDefinition = definition;
    }

    @Override
    public FieldDefinitionBean<Representation> getDefinition() {
        try {
            return this.internalGetDefinition();
        }
        catch (ResolverException e) {
            e.printStackTrace();
            return null;
        }
    }

    private FieldDefinitionBean<Representation> internalGetDefinition() throws ResolverException {
        if (this.cachedDefinition == null) {
            this.cachedDefinition = (FieldDefinitionBean)this.resolver.resolve(FieldDefinitionBean.class, this.definitionID);
        }
        return this.cachedDefinition;
    }

    @Override
    public Representation getValue() {
        if (this.value == null) {
            try {
                this.buildValue();
            }
            catch (ResolverException e) {
                e.printStackTrace();
                return null;
            }
        }
        return this.value;
    }

    @Override
    public void setValue(Representation value) {
        this.value = value;
    }

    @Override
    public TopicBean getParent() {
        return this.parent;
    }

    public Class<? extends IdentifiableBean> getBeanType() {
        return FieldBeanImpl.class;
    }

    private void buildValue() throws ResolverException {
        this.cachedDefinition = this.internalGetDefinition();
        try {
            Field field = this.cachedDefinition.getRepresentation().getField("Factory");
            Object fieldObj = field.get(this.cachedDefinition);
            Method m = this.cachedDefinition.getRepresentation().getField("Factory").getType().getMethod("createNew", ChangeListener.class);
            this.value = (FieldValueBean)m.invoke(fieldObj, this);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean isHeading() {
        return false;
    }

    @Override
    public boolean isField() {
        return true;
    }
}

