/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.dmp.beans.factory;

import java.util.UUID;
import org.openmetadata.beans.IdentifiableBean;
import org.openmetadata.beans.factory.ImplementationConstructor;
import org.openmetadata.beans.impl.IdentifiableBeanImpl;
import org.openmetadata.beans.impl.MutableBeanInitializer;
import org.openmetadata.dmp.beans.DataManagementPlanBean;
import org.openmetadata.dmp.beans.FieldBean;
import org.openmetadata.dmp.beans.HeadingBean;
import org.openmetadata.dmp.beans.TopicBean;
import org.openmetadata.dmp.beans.factory.DmpBeanFactory;
import org.openmetadata.dmp.beans.impl.DataManagementPlanBeanImpl;
import org.openmetadata.dmp.beans.impl.FieldBeanImpl;
import org.openmetadata.dmp.beans.impl.HeadingBeanImpl;

public class DmpFactoryImplConstructorImpl
implements ImplementationConstructor {
    private MutableBeanInitializer initializer;
    private DmpBeanFactory beanFactory;

    public DmpFactoryImplConstructorImpl(DmpBeanFactory beanFactory, MutableBeanInitializer initializer) {
        this.initializer = initializer;
        this.beanFactory = beanFactory;
    }

    public IdentifiableBeanImpl constructImplementation(Class<? extends IdentifiableBean> beanClass, String containerID, String definitionID, TopicBean parent) {
        String newId = String.valueOf(containerID) + "." + UUID.randomUUID().toString();
        if (beanClass.isAssignableFrom(HeadingBean.class)) {
            HeadingBeanImpl heading = new HeadingBeanImpl(true, newId, containerID, this.beanFactory, this.initializer, definitionID, parent);
            return heading;
        }
        if (beanClass.isAssignableFrom(FieldBean.class)) {
            FieldBeanImpl field = new FieldBeanImpl(true, newId, containerID, this.beanFactory, this.initializer, definitionID, parent);
            return field;
        }
        throw new RuntimeException("DmpFactoryImplConstructorImpl.java: Wrong Type");
    }

    public IdentifiableBeanImpl constructImplementation(Class<? extends IdentifiableBean> beanClass) {
        if (beanClass.isAssignableFrom(DataManagementPlanBean.class)) {
            String uuId = UUID.randomUUID().toString();
            DataManagementPlanBeanImpl dmpBean = new DataManagementPlanBeanImpl("urn:dmp:plan:" + uuId, this.beanFactory, this.initializer);
            return dmpBean;
        }
        throw new RuntimeException("Cannot construct bean of type: " + beanClass.getCanonicalName());
    }
}

