/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.dmp.beans.factory;

import org.openmetadata.beans.IdentifiableBean;
import org.openmetadata.beans.factory.ImplementationConstructor;
import org.openmetadata.beans.factory.impl.BeanFactoryImpl;
import org.openmetadata.beans.impl.BeanInitializer;
import org.openmetadata.beans.impl.IdentifiableBeanImpl;
import org.openmetadata.beans.notification.ChangeEvent;
import org.openmetadata.beans.notification.IdentifiableChangeEvent;
import org.openmetadata.beans.notification.impl.ConsolidatedEvent;
import org.openmetadata.beans.notification.impl.CreationEvent;
import org.openmetadata.dmp.beans.TopicBean;
import org.openmetadata.dmp.beans.factory.DmpBeanFactory;
import org.openmetadata.dmp.beans.factory.DmpFactoryImplConstructorImpl;

public class DmpBeanFactoryImpl
extends BeanFactoryImpl
implements DmpBeanFactory {
    public void setDmpImplementationConstructor(DmpFactoryImplConstructorImpl implementationConstructor) {
        super.setImplementationConstructor((ImplementationConstructor)implementationConstructor);
    }

    @Override
    public <B extends IdentifiableBean> B newInstance(Class<B> beanClass, String containerID, String definitionID, TopicBean topicBean) {
        this.setCollectChangeEvents(true);
        DmpFactoryImplConstructorImpl dmpImplConstructor = (DmpFactoryImplConstructorImpl)this.getImplementationConstructor();
        IdentifiableBeanImpl bean = dmpImplConstructor.constructImplementation(beanClass, containerID, definitionID, topicBean);
        if (!bean.verifyInitializer((BeanInitializer)this)) {
            throw new RuntimeException("Bean was not constructed properly: initializer has not been set as expected.");
        }
        this.setCollectChangeEvents(false);
        ConsolidatedEvent beanEvent = this.getConsolidatedEvent((IdentifiableBean)bean);
        if (!beanEvent.getType().equals((Object)ChangeEvent.Type.CREATE)) {
            beanEvent.addEvent((IdentifiableChangeEvent)new CreationEvent((IdentifiableBean)bean));
        }
        System.out.println(beanEvent);
        this.notifyChangeEvent((IdentifiableChangeEvent)beanEvent);
        for (ConsolidatedEvent event : this.getConsolidatedEvents()) {
            this.notifyChangeEvent((IdentifiableChangeEvent)event);
        }
        return (B)this.castBean(beanClass, (IdentifiableBean)bean);
    }
}

