/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.beans.ddi.lifecycle.reusable.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.openmetadata.beans.ddi.lifecycle.reusable.AttributeSet;

public class AttributeSetImpl
implements AttributeSet {
    private Map<String, String> dfAttrSet;
    private Map<String, Map<String, String>> nsAttrSet;

    protected Map<String, String> getInternalDefaultAttrSet() {
        if (this.dfAttrSet == null) {
            this.dfAttrSet = new HashMap<String, String>();
        }
        return this.dfAttrSet;
    }

    protected Map<String, Map<String, String>> getInternalNSAttrSet() {
        if (this.nsAttrSet == null) {
            this.nsAttrSet = new HashMap<String, Map<String, String>>();
        }
        return this.nsAttrSet;
    }

    public void initAdd(String ns, String key, String value) {
        this.internalSetValue(ns, key, value);
    }

    private void internalSetValue(String ns, String key, String value) {
        if (ns != null && !ns.isEmpty()) {
            if (this.getInternalNSAttrSet().containsKey(ns)) {
                this.getInternalNSAttrSet().get(ns).put(key, value);
            } else {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put(key, value);
                this.getInternalNSAttrSet().put(ns, map);
            }
        } else {
            this.getInternalDefaultAttrSet().put(key, value);
        }
    }

    @Override
    public boolean containsKey(String key) {
        return this.getInternalDefaultAttrSet().containsKey(key);
    }

    @Override
    public boolean containsKey(String namespace, String key) {
        if (this.getInternalNSAttrSet().containsKey(namespace)) {
            return this.getInternalNSAttrSet().get(namespace).containsKey(key);
        }
        return false;
    }

    @Override
    public String getValue(String key) {
        String value = this.getInternalDefaultAttrSet().get(key);
        return StringUtils.defaultString((String)value);
    }

    @Override
    public String getValue(String namespace, String key) {
        Map<String, String> map = this.getInternalNSAttrSet().get(namespace);
        if (map != null) {
            String value = map.get(key);
            return StringUtils.defaultString((String)value);
        }
        return "";
    }

    @Override
    public AttributeSet.AttributeEntry[] getAll() {
        ArrayList<AttributeEntryImpl> attrEntryList = new ArrayList<AttributeEntryImpl>();
        for (Map.Entry<String, String> entry : this.getInternalDefaultAttrSet().entrySet()) {
            attrEntryList.add(new AttributeEntryImpl(null, entry.getKey(), entry.getValue()));
        }
        for (Map.Entry<String, Object> entry : this.getInternalNSAttrSet().entrySet()) {
            String namespace = entry.getKey();
            for (Map.Entry subEntry : ((Map)entry.getValue()).entrySet()) {
                attrEntryList.add(new AttributeEntryImpl(namespace, (String)subEntry.getKey(), (String)subEntry.getValue()));
            }
        }
        int n = attrEntryList.size();
        return attrEntryList.toArray(new AttributeSet.AttributeEntry[n]);
    }

    public static class AttributeEntryImpl
    implements AttributeSet.AttributeEntry {
        private final String namespace;
        private final String key;
        private final String value;

        private AttributeEntryImpl(String namespace, String key, String value) {
            this.namespace = namespace;
            this.key = key;
            this.value = value;
        }

        @Override
        public boolean isSetNameSpace() {
            return this.namespace != null && !this.namespace.isEmpty();
        }

        @Override
        public String getNameSpace() {
            return this.namespace;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public String getValue() {
            return this.value;
        }
    }
}

