/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.beans.ddi.lifecycle.reusable.impl;

import org.apache.commons.lang3.StringUtils;
import org.openmetadata.beans.ddi.lifecycle.factory.DdiBeanFactory;
import org.openmetadata.beans.ddi.lifecycle.reusable.IdentifiableBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.MaintainableBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.AbstractVersionableBeanImpl;
import org.openmetadata.beans.ddi.lifecycle.utility.CompareUtil;
import org.openmetadata.beans.impl.MutableBeanInitializer;
import org.openmetadata.ddi_3_1.util.URN;

public abstract class AbstractMaintainableBeanImpl
extends AbstractVersionableBeanImpl
implements MaintainableBean {
    public static final boolean IS_PUBLISHED_DEFAULT = false;
    private String agency;
    private String externalReferenceDefaultUri;
    private Boolean isPublished;
    private String lang;

    public AbstractMaintainableBeanImpl(Boolean isNewInstance, URN urn, MutableBeanInitializer beanInitializer, DdiBeanFactory beanFactory) {
        super(isNewInstance, urn, beanInitializer, beanFactory);
        this.agency = urn.getAgency();
    }

    @Override
    public String getAgency() {
        return this.agency;
    }

    @Override
    public boolean isSetAgency() {
        return this.agency != null;
    }

    protected void setAgency(String arg0) {
        this.agency = arg0;
    }

    @Override
    public String getExternalReferenceDefaultURI() {
        return StringUtils.defaultString((String)this.externalReferenceDefaultUri);
    }

    @Override
    public boolean isSetExternalReferenceDefaultURI() {
        return !StringUtils.isEmpty((CharSequence)this.externalReferenceDefaultUri);
    }

    @Override
    public void setExternalReferenceDefaultURI(String value) {
        if (CompareUtil.areDifferentValues(this.externalReferenceDefaultUri, value)) {
            this.externalReferenceDefaultUri = value;
            this.change();
        }
    }

    @Override
    public boolean getIsPublished() {
        if (this.isPublished != null) {
            return this.isPublished;
        }
        return false;
    }

    @Override
    public boolean isSetIsPublished() {
        return this.isPublished != null;
    }

    @Override
    public void setIsPublished(boolean arg0) {
        if (this.isPublished == null || this.isPublished != arg0) {
            this.isPublished = arg0;
            this.change();
        }
    }

    @Override
    public String getLang() {
        return StringUtils.defaultString((String)this.lang);
    }

    @Override
    public boolean isSetLang() {
        return this.lang != null;
    }

    @Override
    public void setLang(String value) {
        if (CompareUtil.areDifferentValues(this.lang, value)) {
            this.lang = value;
            this.change();
        }
    }

    @Override
    public void delete() {
        IdentifiableBean[] identifiableBeanArray = this.getReferrers();
        int n = identifiableBeanArray.length;
        int n2 = 0;
        while (n2 < n) {
            IdentifiableBean idBean = identifiableBeanArray[n2];
            idBean.changeReference(this, null);
            ++n2;
        }
        this.notifyDelete();
    }
}

