/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.beans.ddi.lifecycle.logicalproduct.impl;

import java.util.HashSet;
import org.openmetadata.beans.ddi.lifecycle.adt.impl.ReferenceSetImpl;
import org.openmetadata.beans.ddi.lifecycle.conceptualcomponent.ConceptBean;
import org.openmetadata.beans.ddi.lifecycle.conceptualcomponent.UniverseBean;
import org.openmetadata.beans.ddi.lifecycle.datacollection.QuestionItemBean;
import org.openmetadata.beans.ddi.lifecycle.datacollection.SequenceBean;
import org.openmetadata.beans.ddi.lifecycle.factory.DdiBeanFactory;
import org.openmetadata.beans.ddi.lifecycle.logicalproduct.CodeSchemeBean;
import org.openmetadata.beans.ddi.lifecycle.logicalproduct.VariableBean;
import org.openmetadata.beans.ddi.lifecycle.logicalproduct.VariableGroupBean;
import org.openmetadata.beans.ddi.lifecycle.logicalproduct.VariableSchemeBean;
import org.openmetadata.beans.ddi.lifecycle.logicalproduct.impl.VariableRepresentationBeanImpl;
import org.openmetadata.beans.ddi.lifecycle.reusable.IdentifiableBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.AbstractSchemeItemBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.CodeRepresentationBeanImpl;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.CodeValueBeanImpl;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.ReferenceBeanImpl;
import org.openmetadata.beans.ddi.lifecycle.types.VariableRepresentationType;
import org.openmetadata.beans.ddi.lifecycle.utility.CompareUtil;
import org.openmetadata.beans.exceptions.ResolverException;
import org.openmetadata.beans.impl.MutableBeanInitializer;
import org.openmetadata.beans.notification.ChangeListener;
import org.openmetadata.ddi.util.exceptions.URNFormatException;
import org.openmetadata.ddi_3_1.util.DdiClass;
import org.openmetadata.ddi_3_1.util.URN;

public class VariableBeanImpl
extends AbstractSchemeItemBean<VariableSchemeBean>
implements VariableBean {
    private static boolean IS_TEMPORAL_DEFAULT = false;
    private static boolean IS_GEOGRAPHIC_DEFAULT = false;
    private static boolean IS_WEIGHT_DEFAULT = false;
    private Boolean isTemporal;
    private Boolean isGeographic;
    private Boolean isWeight;
    private String responseUnit;
    private final ReferenceBeanImpl<ConceptBean> conceptRef;
    private final ReferenceBeanImpl<QuestionItemBean> questionItemRef;
    private final ReferenceBeanImpl<SequenceBean> sequenceRef;
    private final ReferenceSetImpl<UniverseBean> universeRefs;
    private final CodeValueBeanImpl analysisUnit;
    private final VariableRepresentationBeanImpl representation;
    private boolean validating;

    public VariableBeanImpl(Boolean isNewInstance, URN urn, MutableBeanInitializer beanInitializer, DdiBeanFactory factory) {
        super((boolean)isNewInstance, urn, beanInitializer, factory);
        this.conceptRef = new ReferenceBeanImpl<ConceptBean>(ConceptBean.class, factory, (ChangeListener)this);
        this.universeRefs = new ReferenceSetImpl<UniverseBean>(UniverseBean.class, beanInitializer, factory, (ChangeListener)this);
        this.questionItemRef = new ReferenceBeanImpl<QuestionItemBean>(QuestionItemBean.class, factory, (ChangeListener)this);
        this.sequenceRef = new ReferenceBeanImpl<SequenceBean>(SequenceBean.class, factory, (ChangeListener)this);
        this.responseUnit = "";
        this.analysisUnit = new CodeValueBeanImpl(factory, (ChangeListener)this);
        this.representation = new VariableRepresentationBeanImpl(this, factory, (ChangeListener)this);
    }

    public void initSetUniverses(String[] urns) {
        this.universeRefs.initReferenceUrns(urns);
    }

    public void initSetSequence(String sequenceUrn) {
        this.sequenceRef.setReferenceUrn(sequenceUrn);
    }

    public void initSetQuestionItem(String questionItemUrn) throws URNFormatException {
        this.questionItemRef.setReferenceUrn(questionItemUrn);
    }

    public void initSetConceptUrn(String urn) throws URNFormatException {
        this.conceptRef.setReferenceUrn(urn);
    }

    public void setSequenceUrn(String urn) throws URNFormatException {
        this.sequenceRef.setReferenceUrn(urn);
    }

    @Override
    public boolean getIsTemporal() {
        if (this.isSetIsTemporal()) {
            return this.isTemporal;
        }
        return IS_TEMPORAL_DEFAULT;
    }

    @Override
    public void setIsTemporal(boolean boo) {
        if (CompareUtil.areDifferentValues(this.isTemporal, boo)) {
            this.isTemporal = boo;
            this.change();
        }
    }

    @Override
    public boolean isSetIsTemporal() {
        return this.isTemporal != null;
    }

    @Override
    public boolean getIsGeographic() {
        if (this.isSetIsGeographic()) {
            return this.isGeographic;
        }
        return IS_GEOGRAPHIC_DEFAULT;
    }

    @Override
    public void setIsGeographic(boolean isGeographic) {
        if (CompareUtil.areDifferentValues(this.isGeographic, isGeographic)) {
            this.isGeographic = isGeographic;
            this.change();
        }
    }

    @Override
    public boolean isSetIsGeographic() {
        return this.isGeographic != null;
    }

    @Override
    public boolean getIsWeight() {
        if (this.isSetIsWeight()) {
            return this.isWeight;
        }
        return IS_WEIGHT_DEFAULT;
    }

    @Override
    public void setIsWeight(boolean boo) {
        if (CompareUtil.areDifferentValues(this.isWeight, boo)) {
            this.isWeight = boo;
            this.change();
        }
    }

    @Override
    public boolean isSetIsWeight() {
        return this.isWeight != null;
    }

    @Override
    public VariableGroupBean[] getReferringVariableGroups() {
        HashSet<VariableGroupBean> referringGroups = new HashSet<VariableGroupBean>();
        IdentifiableBean[] identifiableBeanArray = this.getReferrers();
        int n = identifiableBeanArray.length;
        int n2 = 0;
        while (n2 < n) {
            IdentifiableBean referrer = identifiableBeanArray[n2];
            if (referrer instanceof VariableGroupBean) {
                VariableGroupBean varGroup = (VariableGroupBean)referrer;
                referringGroups.add(varGroup);
            }
            ++n2;
        }
        return referringGroups.toArray(new VariableGroupBean[0]);
    }

    public ReferenceSetImpl<UniverseBean> getUniverseList() {
        return this.universeRefs;
    }

    @Override
    public boolean isSetConcept() {
        return this.conceptRef.isSet();
    }

    @Override
    public void setConcept(ConceptBean concept) {
        this.conceptRef.setReferenceTo(concept);
    }

    @Override
    public void unsetConcept() {
        this.conceptRef.unset();
    }

    @Override
    public String getConceptUrn() {
        return this.conceptRef.getUrn();
    }

    @Override
    public ConceptBean getConcept() {
        try {
            return this.conceptRef.getReferredObject();
        }
        catch (ResolverException e) {
            throw new RuntimeException(e);
        }
    }

    public ReferenceBeanImpl<QuestionItemBean> getQuestionItemReference() {
        return this.questionItemRef;
    }

    @Override
    public boolean isSetQuestionItem() {
        return this.questionItemRef.isSet();
    }

    @Override
    public void setQuestionItem(QuestionItemBean question) {
        if (question != null) {
            this.questionItemRef.setReferenceTo(question);
            this.sequenceRef.unset();
        } else {
            this.questionItemRef.unset();
        }
    }

    @Override
    public void unsetQuestionItem() {
        if (this.questionItemRef.isSet()) {
            this.questionItemRef.unset();
        }
    }

    @Override
    public QuestionItemBean getQuestionItem() {
        try {
            return this.questionItemRef.getReferredObject();
        }
        catch (ResolverException e) {
            throw new RuntimeException(e);
        }
    }

    public ReferenceBeanImpl<SequenceBean> getSequenceReference() {
        return this.sequenceRef;
    }

    @Override
    public boolean isSetSequence() {
        return this.sequenceRef.isSet();
    }

    @Override
    public void setSequence(SequenceBean sequence) {
        if (sequence != null) {
            this.sequenceRef.setReferenceTo(sequence);
            this.questionItemRef.unset();
        } else {
            this.sequenceRef.unset();
        }
    }

    @Override
    public void unsetSequence() {
        this.sequenceRef.unset();
    }

    @Override
    public String getSequenceUrn() {
        return this.sequenceRef.getUrn();
    }

    @Override
    public SequenceBean getSequence() {
        try {
            return this.sequenceRef.getReferredObject();
        }
        catch (ResolverException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getResponseUnit() {
        if (this.responseUnit != null) {
            return this.responseUnit;
        }
        return "";
    }

    @Override
    public void setResponseUnit(String value) {
        if (CompareUtil.areDifferentValues(this.responseUnit, value)) {
            this.responseUnit = value;
            this.change();
        }
    }

    @Override
    public boolean isSetResponseUnit() {
        return this.responseUnit != null && !this.responseUnit.isEmpty();
    }

    @Override
    public CodeValueBeanImpl getAnalysisUnit() {
        return this.analysisUnit;
    }

    @Override
    public boolean isSetAnalysisUnit() {
        return this.analysisUnit.isSet();
    }

    @Override
    public VariableRepresentationBeanImpl getRepresentation() {
        return this.representation;
    }

    @Override
    public boolean isSetRepresentation() {
        return this.representation.isSet();
    }

    @Override
    protected void doChangeReference(IdentifiableBean current, IdentifiableBean another) {
        VariableRepresentationType repType;
        if (current instanceof ConceptBean && another instanceof ConceptBean) {
            ConceptBean currConcept = (ConceptBean)current;
            if (this.conceptRef.isReferring(currConcept)) {
                ConceptBean anotherConcept = (ConceptBean)another;
                this.conceptRef.setReferenceTo(anotherConcept);
            }
        } else if (current instanceof UniverseBean && another instanceof UniverseBean) {
            UniverseBean currUniverse = (UniverseBean)current;
            if (this.universeRefs.contains(currUniverse)) {
                this.universeRefs.remove(currUniverse.getUrn());
                UniverseBean anotherUniverse = (UniverseBean)another;
                this.universeRefs.add(anotherUniverse);
            }
        } else if (current instanceof QuestionItemBean && another instanceof QuestionItemBean) {
            QuestionItemBean currentQuestion = (QuestionItemBean)current;
            if (this.questionItemRef.isReferring(currentQuestion)) {
                QuestionItemBean anotherQuestion = (QuestionItemBean)another;
                this.questionItemRef.setReferenceTo(anotherQuestion);
            }
        } else if (current instanceof SequenceBean && another instanceof SequenceBean) {
            SequenceBean currSeq = (SequenceBean)current;
            if (this.getSequenceReference().isReferring(currSeq)) {
                SequenceBean anotherSeq = (SequenceBean)another;
                this.getSequenceReference().setReferenceTo(anotherSeq);
            }
        } else if (current instanceof CodeSchemeBean && another instanceof CodeSchemeBean && this.isSetRepresentation() && (repType = this.getRepresentation().getRepresentationType()) == VariableRepresentationType.Code) {
            CodeRepresentationBeanImpl codeRep = (CodeRepresentationBeanImpl)((Object)this.getRepresentation().getCodeRepresentation());
            CodeSchemeBean anotherCodeScheme = (CodeSchemeBean)another;
            codeRep.getCodeSchemeReference().setReferenceTo(anotherCodeScheme);
        }
    }

    @Override
    protected void doRemoveReference(IdentifiableBean toRemove) {
        if (toRemove instanceof ConceptBean) {
            ConceptBean currConcept = (ConceptBean)toRemove;
            if (this.conceptRef.isReferring(currConcept)) {
                this.conceptRef.unset();
            }
        } else if (toRemove instanceof UniverseBean) {
            UniverseBean currUniverse = (UniverseBean)toRemove;
            if (this.universeRefs.contains(currUniverse)) {
                this.universeRefs.remove(currUniverse.getUrn());
            }
        } else if (toRemove instanceof QuestionItemBean) {
            QuestionItemBean question = (QuestionItemBean)toRemove;
            if (this.questionItemRef.isReferring(question)) {
                this.questionItemRef.unset();
            }
        } else if (toRemove instanceof SequenceBean) {
            SequenceBean currSeq = (SequenceBean)toRemove;
            if (this.sequenceRef.isReferring(currSeq)) {
                this.sequenceRef.unset();
            }
        } else if (toRemove instanceof CodeSchemeBean) {
            VariableRepresentationType repType;
            CodeSchemeBean codeScheme = (CodeSchemeBean)toRemove;
            if (this.isSetRepresentation() && (repType = this.getRepresentation().getRepresentationType()) == VariableRepresentationType.Code) {
                CodeRepresentationBeanImpl codeRep = (CodeRepresentationBeanImpl)((Object)this.getRepresentation().getCodeRepresentation());
                if (codeScheme.getUrn().equals(codeRep.getCodeSchemeUrn())) {
                    codeRep.unset();
                    this.getRepresentation().unset();
                }
            }
        }
    }

    @Override
    public DdiClass getDdiClass() {
        return DdiClass.Variable;
    }

    @Override
    public Class<? extends IdentifiableBean> getBeanType() {
        return VariableBean.class;
    }
}

