/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.beans.ddi.lifecycle.logicalproduct.impl;

import java.util.HashSet;
import org.openmetadata.beans.ddi.lifecycle.adt.ResolvingSet;
import org.openmetadata.beans.ddi.lifecycle.factory.DdiBeanFactory;
import org.openmetadata.beans.ddi.lifecycle.impl.DdiBeanImpl;
import org.openmetadata.beans.ddi.lifecycle.logicalproduct.CategoryBean;
import org.openmetadata.beans.ddi.lifecycle.logicalproduct.CodeBean;
import org.openmetadata.beans.ddi.lifecycle.logicalproduct.CodeList;
import org.openmetadata.beans.ddi.lifecycle.logicalproduct.CodeSchemeBean;
import org.openmetadata.beans.ddi.lifecycle.logicalproduct.impl.CodeListImpl;
import org.openmetadata.beans.ddi.lifecycle.reusable.ActionCode;
import org.openmetadata.beans.ddi.lifecycle.reusable.AttributeSet;
import org.openmetadata.beans.ddi.lifecycle.reusable.IdentifiableBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.LabelValueBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.NameValueBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.StructuredStringValueBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.UserIDValueBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.AttributeSetImpl;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.ReferenceBeanImpl;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.UserIDValueBeanImpl;
import org.openmetadata.beans.ddi.lifecycle.utility.CompareUtil;
import org.openmetadata.beans.exceptions.ResolverException;
import org.openmetadata.beans.impl.MutableBeanInitializer;
import org.openmetadata.beans.notification.ChangeListener;
import org.openmetadata.beans.reference.Resolver;
import org.openmetadata.ddi_3_1.util.DdiClass;

public class CodeBeanImpl
extends DdiBeanImpl
implements CodeBean {
    private static boolean IS_DISCRETE_DEFAULT = true;
    private static boolean IS_TOTAL_DEFAULT = false;
    private final String id;
    private final String value;
    private final AttributeSet attrSet;
    private final ReferenceBeanImpl<CategoryBean> categoryReference;
    private final CodeSchemeBean parentScheme;
    private final CodeListImpl codeList;
    private Boolean isDiscrete;
    private Integer levelNumber;
    private Boolean isComprehensive;
    private Boolean isTotal;
    private UserIDValueBeanImpl userIDValues;

    public CodeBeanImpl(String codeVal, CodeSchemeBean parentScheme, MutableBeanInitializer beanInitializer, DdiBeanFactory factory, ChangeListener changeListener) {
        super(beanInitializer, factory, changeListener);
        this.value = codeVal;
        this.id = codeVal;
        this.userIDValues = new UserIDValueBeanImpl(factory, this);
        this.attrSet = new AttributeSetImpl();
        this.parentScheme = parentScheme;
        this.categoryReference = new ReferenceBeanImpl<CategoryBean>(CategoryBean.class, factory, (ChangeListener)this);
        this.codeList = new CodeListImpl(parentScheme, beanInitializer, factory, (ChangeListener)this);
    }

    public void internalAddCode(CodeBean code) {
        this.codeList.internalAddCode(code);
    }

    @Override
    public AttributeSet getAttributeSet() {
        return this.attrSet;
    }

    public CodeSchemeBean getParentScheme() {
        return this.parentScheme;
    }

    @Override
    public CodeList<? extends CodeBean> getCodeList() {
        return this.codeList;
    }

    @Override
    public IdentifiableBean[] getReferrers() {
        return new IdentifiableBean[0];
    }

    @Override
    public ResolvingSet<IdentifiableBean> getReferrerSet() {
        return new ResolvingSet<IdentifiableBean>(new HashSet<String>(), IdentifiableBean.class, (Resolver)this.getBeanFactory());
    }

    @Override
    public boolean getIsDiscrete() {
        if (this.isSetIsDiscrete()) {
            return this.isDiscrete;
        }
        return IS_DISCRETE_DEFAULT;
    }

    @Override
    public void setIsDiscrete(boolean isDiscrete) {
        if (CompareUtil.areDifferentValues(this.isDiscrete, isDiscrete)) {
            this.isDiscrete = isDiscrete;
            this.ddiBeanChanged();
        }
    }

    @Override
    public boolean isSetIsDiscrete() {
        return this.isDiscrete != null;
    }

    @Override
    public int getLevelNumber() {
        if (this.isSetLevelNumber()) {
            return this.levelNumber;
        }
        return 0;
    }

    @Override
    public void setLevelNumber(int value) {
        if (CompareUtil.areDifferentValues(this.levelNumber, value)) {
            this.levelNumber = value;
            this.ddiBeanChanged();
        }
    }

    @Override
    public boolean isSetLevelNumber() {
        return this.levelNumber != null;
    }

    @Override
    public boolean getIsComprehensive() {
        return false;
    }

    @Override
    public void setIsComprehensive(boolean value) {
        if (this.isComprehensive == null || this.isComprehensive != value) {
            this.isComprehensive = value;
            this.ddiBeanChanged();
        }
    }

    @Override
    public boolean isSetIsComprehensive() {
        return this.isComprehensive != null;
    }

    @Override
    public boolean getIsTotal() {
        if (this.isSetIsTotal()) {
            return this.isTotal;
        }
        return IS_TOTAL_DEFAULT;
    }

    @Override
    public void setIsTotal(boolean boo) {
        if (CompareUtil.areDifferentValues(this.isTotal, boo)) {
            this.isTotal = boo;
            this.ddiBeanChanged();
        }
    }

    @Override
    public boolean isSetIsTotal() {
        return this.isTotal != null;
    }

    public ReferenceBeanImpl<CategoryBean> getCategoryReference() {
        return this.categoryReference;
    }

    @Override
    public boolean isSetCategory() {
        return this.categoryReference.isSet();
    }

    @Override
    public void setCategory(CategoryBean category) {
        this.categoryReference.setReferenceTo(category);
    }

    @Override
    public void unsetCategory() {
        this.categoryReference.unset();
    }

    @Override
    public CategoryBean getCategory() {
        try {
            return this.categoryReference.getReferredObject();
        }
        catch (ResolverException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getCategoryUrn() {
        return this.categoryReference.getUrn();
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public boolean isSetUrn() {
        return true;
    }

    @Override
    public String getUrn() {
        return String.valueOf(this.parentScheme.getUrn()) + ":" + this.getObjectSource() + "." + this.getId() + "." + "1.0.0";
    }

    @Override
    public boolean isSetObjectSource() {
        return false;
    }

    @Override
    public String getObjectSource() {
        return DdiClass.Code.toString();
    }

    @Override
    public void setObjectSource(String value) {
    }

    @Override
    public boolean isSetAction() {
        return false;
    }

    @Override
    public ActionCode getAction() {
        return null;
    }

    @Override
    public void setAction(ActionCode arg0) {
    }

    @Override
    public void changeReference(IdentifiableBean current, IdentifiableBean another) {
        if (current != null && current != another && current instanceof CategoryBean) {
            CategoryBean currCtg = (CategoryBean)current;
            if (this.getCategory() == currCtg) {
                if (another != null && another instanceof CategoryBean) {
                    CategoryBean anotherCategory = (CategoryBean)another;
                    this.categoryReference.setReferenceTo(anotherCategory);
                } else {
                    this.categoryReference.unset();
                }
            }
        }
    }

    @Override
    public void removeReference(IdentifiableBean toRemove) {
        if (toRemove != null && toRemove instanceof CategoryBean) {
            CategoryBean currCtg = (CategoryBean)toRemove;
            if (this.getCategory() == currCtg) {
                this.categoryReference.unset();
            }
        }
    }

    @Override
    public void copyNameLabelDescription(IdentifiableBean from) {
    }

    @Override
    public UserIDValueBean getUserIDValues() {
        return this.userIDValues;
    }

    @Override
    public NameValueBean getName() {
        return null;
    }

    @Override
    public LabelValueBean getLabel() {
        return null;
    }

    @Override
    public StructuredStringValueBean getDescription() {
        return null;
    }

    @Override
    public DdiClass getDdiClass() {
        return DdiClass.Code;
    }

    @Override
    public Class<? extends IdentifiableBean> getBeanType() {
        return CodeBean.class;
    }

    @Override
    public void removeAllReferences() {
    }

    public String getPrimaryIdentifier() {
        return this.getUrn();
    }

    public String getContainerIdentifier() {
        return this.parentScheme.getUrn();
    }
}

