/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.beans.ddi.lifecycle.factory.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import org.openmetadata.beans.IdentifiableBean;
import org.openmetadata.beans.ddi.lifecycle.DdiBeans;
import org.openmetadata.beans.ddi.lifecycle.archive.ArchiveBean;
import org.openmetadata.beans.ddi.lifecycle.archive.IndividualBean;
import org.openmetadata.beans.ddi.lifecycle.archive.LocationBean;
import org.openmetadata.beans.ddi.lifecycle.archive.OrganizationBean;
import org.openmetadata.beans.ddi.lifecycle.archive.OrganizationSchemeBean;
import org.openmetadata.beans.ddi.lifecycle.archive.impl.ArchiveBeanImpl;
import org.openmetadata.beans.ddi.lifecycle.archive.impl.IndividualBeanImpl;
import org.openmetadata.beans.ddi.lifecycle.archive.impl.LocationBeanImpl;
import org.openmetadata.beans.ddi.lifecycle.archive.impl.OrganizationBeanImpl;
import org.openmetadata.beans.ddi.lifecycle.archive.impl.OrganizationSchemeBeanImpl;
import org.openmetadata.beans.ddi.lifecycle.conceptualcomponent.ConceptBean;
import org.openmetadata.beans.ddi.lifecycle.conceptualcomponent.ConceptGroupBean;
import org.openmetadata.beans.ddi.lifecycle.conceptualcomponent.ConceptSchemeBean;
import org.openmetadata.beans.ddi.lifecycle.conceptualcomponent.ConceptualComponentBean;
import org.openmetadata.beans.ddi.lifecycle.conceptualcomponent.UniverseBean;
import org.openmetadata.beans.ddi.lifecycle.conceptualcomponent.UniverseSchemeBean;
import org.openmetadata.beans.ddi.lifecycle.conceptualcomponent.impl.ConceptBeanImpl;
import org.openmetadata.beans.ddi.lifecycle.conceptualcomponent.impl.ConceptGroupBeanImpl;
import org.openmetadata.beans.ddi.lifecycle.conceptualcomponent.impl.ConceptSchemeBeanImpl;
import org.openmetadata.beans.ddi.lifecycle.conceptualcomponent.impl.ConceptualComponentBeanImpl;
import org.openmetadata.beans.ddi.lifecycle.conceptualcomponent.impl.UniverseBeanImpl;
import org.openmetadata.beans.ddi.lifecycle.conceptualcomponent.impl.UniverseSchemeBeanImpl;
import org.openmetadata.beans.ddi.lifecycle.datacollection.CodingBean;
import org.openmetadata.beans.ddi.lifecycle.datacollection.CollectionEventBean;
import org.openmetadata.beans.ddi.lifecycle.datacollection.ConstructSequenceBean;
import org.openmetadata.beans.ddi.lifecycle.datacollection.ControlConstructBean;
import org.openmetadata.beans.ddi.lifecycle.datacollection.ControlConstructSchemeBean;
import org.openmetadata.beans.ddi.lifecycle.datacollection.DataCollectionBean;
import org.openmetadata.beans.ddi.lifecycle.datacollection.InstructionBean;
import org.openmetadata.beans.ddi.lifecycle.datacollection.InstrumentBean;
import org.openmetadata.beans.ddi.lifecycle.datacollection.InterviewerInstructionSchemeBean;
import org.openmetadata.beans.ddi.lifecycle.datacollection.MethodologyBean;
import org.openmetadata.beans.ddi.lifecycle.datacollection.ProcessingBean;
import org.openmetadata.beans.ddi.lifecycle.datacollection.QuestionBlockBean;
import org.openmetadata.beans.ddi.lifecycle.datacollection.QuestionConstructBean;
import org.openmetadata.beans.ddi.lifecycle.datacollection.QuestionItemBean;
import org.openmetadata.beans.ddi.lifecycle.datacollection.QuestionSchemeBean;
import org.openmetadata.beans.ddi.lifecycle.datacollection.SequenceBean;
import org.openmetadata.beans.ddi.lifecycle.datacollection.StatementItemBean;
import org.openmetadata.beans.ddi.lifecycle.datacollection.impl.CodingBeanImpl;
import org.openmetadata.beans.ddi.lifecycle.datacollection.impl.CollectionEventBeanImpl;
import org.openmetadata.beans.ddi.lifecycle.datacollection.impl.ConstructSequenceBeanImpl;
import org.openmetadata.beans.ddi.lifecycle.datacollection.impl.ControlConstructBeanImpl;
import org.openmetadata.beans.ddi.lifecycle.datacollection.impl.ControlConstructSchemeBeanImpl;
import org.openmetadata.beans.ddi.lifecycle.datacollection.impl.DataCollectionBeanImpl;
import org.openmetadata.beans.ddi.lifecycle.datacollection.impl.InstructionBeanImpl;
import org.openmetadata.beans.ddi.lifecycle.datacollection.impl.InstrumentBeanImpl;
import org.openmetadata.beans.ddi.lifecycle.datacollection.impl.InterviewerInstructionSchemeBeanImpl;
import org.openmetadata.beans.ddi.lifecycle.datacollection.impl.MethodologyBeanImpl;
import org.openmetadata.beans.ddi.lifecycle.datacollection.impl.ProcessingBeanImpl;
import org.openmetadata.beans.ddi.lifecycle.datacollection.impl.QuestionBlockBeanImpl;
import org.openmetadata.beans.ddi.lifecycle.datacollection.impl.QuestionConstructBeanImpl;
import org.openmetadata.beans.ddi.lifecycle.datacollection.impl.QuestionItemBeanImpl;
import org.openmetadata.beans.ddi.lifecycle.datacollection.impl.QuestionSchemeBeanImpl;
import org.openmetadata.beans.ddi.lifecycle.datacollection.impl.SequenceBeanImpl;
import org.openmetadata.beans.ddi.lifecycle.datacollection.impl.StatementItemBeanImpl;
import org.openmetadata.beans.ddi.lifecycle.factory.DdiBeanFactory;
import org.openmetadata.beans.ddi.lifecycle.factory.DdiBeanImplementationConstructor;
import org.openmetadata.beans.ddi.lifecycle.group.GroupBean;
import org.openmetadata.beans.ddi.lifecycle.group.SubGroupBean;
import org.openmetadata.beans.ddi.lifecycle.group.impl.GroupBeanImpl;
import org.openmetadata.beans.ddi.lifecycle.group.impl.SubGroupBeanImpl;
import org.openmetadata.beans.ddi.lifecycle.logicalproduct.CategoryBean;
import org.openmetadata.beans.ddi.lifecycle.logicalproduct.CategorySchemeBean;
import org.openmetadata.beans.ddi.lifecycle.logicalproduct.CodeSchemeBean;
import org.openmetadata.beans.ddi.lifecycle.logicalproduct.DataRelationshipBean;
import org.openmetadata.beans.ddi.lifecycle.logicalproduct.LogicalProductBean;
import org.openmetadata.beans.ddi.lifecycle.logicalproduct.LogicalRecordBean;
import org.openmetadata.beans.ddi.lifecycle.logicalproduct.RecordRelationshipBean;
import org.openmetadata.beans.ddi.lifecycle.logicalproduct.VariableBean;
import org.openmetadata.beans.ddi.lifecycle.logicalproduct.VariableGroupBean;
import org.openmetadata.beans.ddi.lifecycle.logicalproduct.VariableSchemeBean;
import org.openmetadata.beans.ddi.lifecycle.logicalproduct.impl.CategoryBeanImpl;
import org.openmetadata.beans.ddi.lifecycle.logicalproduct.impl.CategorySchemeBeanImpl;
import org.openmetadata.beans.ddi.lifecycle.logicalproduct.impl.CodeSchemeBeanImpl;
import org.openmetadata.beans.ddi.lifecycle.logicalproduct.impl.DataRelationshipBeanImpl;
import org.openmetadata.beans.ddi.lifecycle.logicalproduct.impl.LogicalProductBeanImpl;
import org.openmetadata.beans.ddi.lifecycle.logicalproduct.impl.LogicalRecordBeanImpl;
import org.openmetadata.beans.ddi.lifecycle.logicalproduct.impl.RecordRelationshipBeanImpl;
import org.openmetadata.beans.ddi.lifecycle.logicalproduct.impl.VariableBeanImpl;
import org.openmetadata.beans.ddi.lifecycle.logicalproduct.impl.VariableGroupBeanImpl;
import org.openmetadata.beans.ddi.lifecycle.logicalproduct.impl.VariableSchemeBeanImpl;
import org.openmetadata.beans.ddi.lifecycle.physicaldataproduct.GrossRecordStructureBean;
import org.openmetadata.beans.ddi.lifecycle.physicaldataproduct.PhysicalDataProductBean;
import org.openmetadata.beans.ddi.lifecycle.physicaldataproduct.PhysicalRecordSegmentBean;
import org.openmetadata.beans.ddi.lifecycle.physicaldataproduct.PhysicalStructureBean;
import org.openmetadata.beans.ddi.lifecycle.physicaldataproduct.PhysicalStructureSchemeBean;
import org.openmetadata.beans.ddi.lifecycle.physicaldataproduct.RecordLayoutBean;
import org.openmetadata.beans.ddi.lifecycle.physicaldataproduct.RecordLayoutSchemeBean;
import org.openmetadata.beans.ddi.lifecycle.physicaldataproduct.impl.GrossRecordStructureBeanImpl;
import org.openmetadata.beans.ddi.lifecycle.physicaldataproduct.impl.PhysicalDataProductBeanImpl;
import org.openmetadata.beans.ddi.lifecycle.physicaldataproduct.impl.PhysicalRecordSegmentBeanImpl;
import org.openmetadata.beans.ddi.lifecycle.physicaldataproduct.impl.PhysicalStructureBeanImpl;
import org.openmetadata.beans.ddi.lifecycle.physicaldataproduct.impl.PhysicalStructureSchemeBeanImpl;
import org.openmetadata.beans.ddi.lifecycle.physicaldataproduct.impl.RecordLayoutBeanImpl;
import org.openmetadata.beans.ddi.lifecycle.physicaldataproduct.impl.RecordLayoutSchemeBeanImpl;
import org.openmetadata.beans.ddi.lifecycle.physicalinstance.DataFileIdentificationBean;
import org.openmetadata.beans.ddi.lifecycle.physicalinstance.GrossFileStructureBean;
import org.openmetadata.beans.ddi.lifecycle.physicalinstance.PhysicalInstanceBean;
import org.openmetadata.beans.ddi.lifecycle.physicalinstance.impl.DataFileIdentificationBeanImpl;
import org.openmetadata.beans.ddi.lifecycle.physicalinstance.impl.GrossFileStructureBeanImpl;
import org.openmetadata.beans.ddi.lifecycle.physicalinstance.impl.PhysicalInstanceBeanImpl;
import org.openmetadata.beans.ddi.lifecycle.reusable.NoteBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.OtherMaterialBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.SoftwareBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.AbstractIdentifiableBeanImpl;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.NoteBeanImpl;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.OtherMaterialBeanImpl;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.SoftwareBeanImpl;
import org.openmetadata.beans.ddi.lifecycle.studyunit.StudyUnitBean;
import org.openmetadata.beans.ddi.lifecycle.studyunit.impl.StudyUnitBeanImpl;
import org.openmetadata.beans.impl.IdentifiableBeanImpl;
import org.openmetadata.beans.impl.MutableBeanInitializer;
import org.openmetadata.ddi.util.DdiClassType;
import org.openmetadata.ddi_3_1.util.DdiClass;
import org.openmetadata.ddi_3_1.util.URN;
import org.openmetadata.ddi_3_1.util.URNBuilder;

public class DdiBeanImplementationConstructorImpl
implements DdiBeanImplementationConstructor {
    private URNBuilder urnBuilder;
    private DdiBeanFactory beanFactory;
    protected Map<Class<? extends IdentifiableBean>, Class<? extends AbstractIdentifiableBeanImpl>> beanIntf2BeanImplMap = new HashMap<Class<? extends IdentifiableBean>, Class<? extends AbstractIdentifiableBeanImpl>>();

    public DdiBeanImplementationConstructorImpl() {
        this.populateBeanInterface2ImplementationMap();
    }

    public void setUrnBuilder(URNBuilder urnBuilder) {
        if (this.urnBuilder != null) {
            throw new RuntimeException("URN builder is already set.");
        }
        this.urnBuilder = urnBuilder;
    }

    public void setDdiBeanFactory(DdiBeanFactory beanFactory) {
        if (this.beanFactory != null) {
            throw new RuntimeException("DdiBeanFactory is already set.");
        }
        this.beanFactory = beanFactory;
    }

    public IdentifiableBeanImpl constructImplementation(Class<? extends IdentifiableBean> beanClass) {
        return this.constructImplementation(beanClass, null);
    }

    @Override
    public IdentifiableBeanImpl constructImplementation(Class<? extends IdentifiableBean> beanClass, String urn) {
        URN urnObj = this.getUrn(beanClass, urn);
        return this.doConstructImplementation(beanClass, urnObj);
    }

    @Override
    public IdentifiableBeanImpl constructImplementation(Class<? extends IdentifiableBean> beanClass, String agency, String version) {
        DdiClass requiredDdiClass = DdiBeans.getDdiClass(beanClass);
        String urnStr = this.urnBuilder.buildNewMaintainableUrn(requiredDdiClass, agency, version);
        return this.doConstructImplementation(beanClass, URN.getURN((String)urnStr));
    }

    public IdentifiableBeanImpl doConstructImplementation(Class<? extends IdentifiableBean> beanClass, URN urnObj) {
        Constructor<? extends IdentifiableBeanImpl> constructor;
        Class<? extends IdentifiableBeanImpl> implClass = this.findImplementationClass(beanClass);
        try {
            constructor = implClass.getConstructor(Boolean.class, URN.class, MutableBeanInitializer.class, DdiBeanFactory.class);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        try {
            IdentifiableBeanImpl idBean = constructor.newInstance(new Object[]{true, urnObj, this.beanFactory, this.beanFactory});
            return idBean;
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public Class<? extends IdentifiableBeanImpl> findImplementationClass(Class<? extends IdentifiableBean> requestedClass) {
        Class<? extends AbstractIdentifiableBeanImpl> implClass = this.beanIntf2BeanImplMap.get(requestedClass);
        if (implClass != null) {
            return implClass;
        }
        if (AbstractIdentifiableBeanImpl.class.isAssignableFrom(requestedClass) && !Modifier.isAbstract(requestedClass.getModifiers())) {
            return requestedClass;
        }
        throw new RuntimeException("Could not find the implementation class for the bean class : " + requestedClass.getName());
    }

    protected URN getUrn(Class<? extends IdentifiableBean> beanClass, String urn) {
        DdiClass requiredDdiClass = DdiBeans.getDdiClass(beanClass);
        if (requiredDdiClass.getType() == DdiClassType.Maintainable) {
            if (urn != null) {
                URN urnObj = URN.getURN((String)urn);
                if (requiredDdiClass == urnObj.getDDIClass()) {
                    return urnObj;
                }
                String agency = urnObj.getAgency();
                String version = urnObj.getVersion();
                String urnStr = this.urnBuilder.buildNewMaintainableUrn(requiredDdiClass, agency, version);
                return URN.getURN((String)urnStr);
            }
            String urnStr = this.urnBuilder.buildNewMaintainableUrn(requiredDdiClass);
            return URN.getURN((String)urnStr);
        }
        if (urn != null) {
            String identifiableUrnStr = this.urnBuilder.buildNewIdentifiableUrn(requiredDdiClass, urn);
            return URN.getURN((String)identifiableUrnStr);
        }
        throw new RuntimeException("Cannot create URN for " + beanClass);
    }

    protected void populateBeanInterface2ImplementationMap() {
        this.beanIntf2BeanImplMap.put(StudyUnitBean.class, StudyUnitBeanImpl.class);
        this.beanIntf2BeanImplMap.put(ArchiveBean.class, ArchiveBeanImpl.class);
        this.beanIntf2BeanImplMap.put(LocationBean.class, LocationBeanImpl.class);
        this.beanIntf2BeanImplMap.put(OrganizationSchemeBean.class, OrganizationSchemeBeanImpl.class);
        this.beanIntf2BeanImplMap.put(OrganizationBean.class, OrganizationBeanImpl.class);
        this.beanIntf2BeanImplMap.put(IndividualBean.class, IndividualBeanImpl.class);
        this.beanIntf2BeanImplMap.put(SoftwareBean.class, SoftwareBeanImpl.class);
        this.beanIntf2BeanImplMap.put(OtherMaterialBean.class, OtherMaterialBeanImpl.class);
        this.beanIntf2BeanImplMap.put(ConceptualComponentBean.class, ConceptualComponentBeanImpl.class);
        this.beanIntf2BeanImplMap.put(UniverseSchemeBean.class, UniverseSchemeBeanImpl.class);
        this.beanIntf2BeanImplMap.put(UniverseBean.class, UniverseBeanImpl.class);
        this.beanIntf2BeanImplMap.put(ConceptSchemeBean.class, ConceptSchemeBeanImpl.class);
        this.beanIntf2BeanImplMap.put(ConceptBean.class, ConceptBeanImpl.class);
        this.beanIntf2BeanImplMap.put(ConceptGroupBean.class, ConceptGroupBeanImpl.class);
        this.beanIntf2BeanImplMap.put(LogicalProductBean.class, LogicalProductBeanImpl.class);
        this.beanIntf2BeanImplMap.put(VariableSchemeBean.class, VariableSchemeBeanImpl.class);
        this.beanIntf2BeanImplMap.put(VariableBean.class, VariableBeanImpl.class);
        this.beanIntf2BeanImplMap.put(VariableGroupBean.class, VariableGroupBeanImpl.class);
        this.beanIntf2BeanImplMap.put(DataRelationshipBean.class, DataRelationshipBeanImpl.class);
        this.beanIntf2BeanImplMap.put(RecordRelationshipBean.class, RecordRelationshipBeanImpl.class);
        this.beanIntf2BeanImplMap.put(LogicalRecordBean.class, LogicalRecordBeanImpl.class);
        this.beanIntf2BeanImplMap.put(DataCollectionBean.class, DataCollectionBeanImpl.class);
        this.beanIntf2BeanImplMap.put(MethodologyBean.class, MethodologyBeanImpl.class);
        this.beanIntf2BeanImplMap.put(InstrumentBean.class, InstrumentBeanImpl.class);
        this.beanIntf2BeanImplMap.put(QuestionSchemeBean.class, QuestionSchemeBeanImpl.class);
        this.beanIntf2BeanImplMap.put(QuestionItemBean.class, QuestionItemBeanImpl.class);
        this.beanIntf2BeanImplMap.put(ControlConstructSchemeBean.class, ControlConstructSchemeBeanImpl.class);
        this.beanIntf2BeanImplMap.put(QuestionConstructBean.class, QuestionConstructBeanImpl.class);
        this.beanIntf2BeanImplMap.put(ConstructSequenceBean.class, ConstructSequenceBeanImpl.class);
        this.beanIntf2BeanImplMap.put(QuestionBlockBean.class, QuestionBlockBeanImpl.class);
        this.beanIntf2BeanImplMap.put(StatementItemBean.class, StatementItemBeanImpl.class);
        this.beanIntf2BeanImplMap.put(CollectionEventBean.class, CollectionEventBeanImpl.class);
        this.beanIntf2BeanImplMap.put(ProcessingBean.class, ProcessingBeanImpl.class);
        this.beanIntf2BeanImplMap.put(CodingBean.class, CodingBeanImpl.class);
        this.beanIntf2BeanImplMap.put(SequenceBean.class, SequenceBeanImpl.class);
        this.beanIntf2BeanImplMap.put(ControlConstructBean.class, ControlConstructBeanImpl.class);
        this.beanIntf2BeanImplMap.put(InterviewerInstructionSchemeBean.class, InterviewerInstructionSchemeBeanImpl.class);
        this.beanIntf2BeanImplMap.put(InstructionBean.class, InstructionBeanImpl.class);
        this.beanIntf2BeanImplMap.put(CategorySchemeBean.class, CategorySchemeBeanImpl.class);
        this.beanIntf2BeanImplMap.put(CategoryBean.class, CategoryBeanImpl.class);
        this.beanIntf2BeanImplMap.put(CodeSchemeBean.class, CodeSchemeBeanImpl.class);
        this.beanIntf2BeanImplMap.put(GrossFileStructureBean.class, GrossFileStructureBeanImpl.class);
        this.beanIntf2BeanImplMap.put(PhysicalRecordSegmentBean.class, PhysicalRecordSegmentBeanImpl.class);
        this.beanIntf2BeanImplMap.put(DataFileIdentificationBean.class, DataFileIdentificationBeanImpl.class);
        this.beanIntf2BeanImplMap.put(PhysicalDataProductBean.class, PhysicalDataProductBeanImpl.class);
        this.beanIntf2BeanImplMap.put(PhysicalInstanceBean.class, PhysicalInstanceBeanImpl.class);
        this.beanIntf2BeanImplMap.put(RecordLayoutSchemeBean.class, RecordLayoutSchemeBeanImpl.class);
        this.beanIntf2BeanImplMap.put(RecordLayoutBean.class, RecordLayoutBeanImpl.class);
        this.beanIntf2BeanImplMap.put(GrossRecordStructureBean.class, GrossRecordStructureBeanImpl.class);
        this.beanIntf2BeanImplMap.put(PhysicalStructureSchemeBean.class, PhysicalStructureSchemeBeanImpl.class);
        this.beanIntf2BeanImplMap.put(PhysicalStructureBean.class, PhysicalStructureBeanImpl.class);
        this.beanIntf2BeanImplMap.put(NoteBean.class, NoteBeanImpl.class);
        this.beanIntf2BeanImplMap.put(GroupBean.class, GroupBeanImpl.class);
        this.beanIntf2BeanImplMap.put(SubGroupBean.class, SubGroupBeanImpl.class);
    }
}

