/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.beans.ddi.lifecycle.conceptualcomponent.impl;

import org.openmetadata.beans.ddi.lifecycle.adt.impl.ReferenceSetImpl;
import org.openmetadata.beans.ddi.lifecycle.conceptualcomponent.ConceptBean;
import org.openmetadata.beans.ddi.lifecycle.conceptualcomponent.ConceptGroupBean;
import org.openmetadata.beans.ddi.lifecycle.conceptualcomponent.ConceptSchemeBean;
import org.openmetadata.beans.ddi.lifecycle.factory.DdiBeanFactory;
import org.openmetadata.beans.ddi.lifecycle.reusable.IdentifiableBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.AbstractSchemeItemBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.ReferenceBeanImpl;
import org.openmetadata.beans.exceptions.ResolverException;
import org.openmetadata.beans.impl.MutableBeanInitializer;
import org.openmetadata.beans.notification.ChangeListener;
import org.openmetadata.ddi_3_1.util.DdiClass;
import org.openmetadata.ddi_3_1.util.URN;

public class ConceptGroupBeanImpl
extends AbstractSchemeItemBean<ConceptSchemeBean>
implements ConceptGroupBean {
    private final ReferenceSetImpl<ConceptBean> conceptRefs;
    private final ReferenceSetImpl<ConceptGroupBean> conceptGroupRefs;
    private final ReferenceBeanImpl<ConceptBean> definingConceptReference;

    public ConceptGroupBeanImpl(Boolean isNewInstance, URN urn, MutableBeanInitializer beanInitializer, DdiBeanFactory factory) {
        super((boolean)isNewInstance, urn, beanInitializer, factory);
        this.conceptRefs = new ReferenceSetImpl<ConceptBean>(ConceptBean.class, beanInitializer, factory, (ChangeListener)this);
        this.conceptGroupRefs = new ReferenceSetImpl<ConceptGroupBean>(ConceptGroupBean.class, beanInitializer, factory, (ChangeListener)this);
        this.definingConceptReference = new ReferenceBeanImpl<ConceptBean>(ConceptBean.class, factory, (ChangeListener)this);
    }

    public void initSetConcepts(String[] conceptUrns) {
        this.conceptRefs.initReferenceUrns(conceptUrns);
    }

    public void initSetConceptGroups(String[] conceptGroupUrns) {
        this.conceptGroupRefs.initReferenceUrns(conceptGroupUrns);
    }

    @Override
    public boolean isSetDefiningConcept() {
        return this.definingConceptReference.isSet();
    }

    @Override
    public void setDefiningConcept(ConceptBean concept) {
        this.definingConceptReference.setReferenceTo(concept);
    }

    @Override
    public String getDefiningConceptUrn() {
        return this.definingConceptReference.getUrn();
    }

    @Override
    public ConceptBean getDefiningConcept() {
        try {
            return this.definingConceptReference.getReferredObject();
        }
        catch (ResolverException e) {
            throw new RuntimeException(e);
        }
    }

    public ReferenceBeanImpl<ConceptBean> getDefiningConceptReference() {
        return this.definingConceptReference;
    }

    @Override
    public boolean isDefiningConcepts() {
        return this.definingConceptReference.isSet();
    }

    @Override
    public boolean isAdministrativePurpose() {
        return !this.definingConceptReference.isSet();
    }

    @Override
    public void setToAdministrativePurpose() {
        this.definingConceptReference.unset();
        this.change();
    }

    public ReferenceSetImpl<ConceptBean> getConceptList() {
        return this.conceptRefs;
    }

    public ReferenceSetImpl<ConceptGroupBean> getConceptGroupList() {
        return this.conceptGroupRefs;
    }

    @Override
    protected void doChangeReference(IdentifiableBean toRemove, IdentifiableBean toAdd) {
        if (toRemove instanceof ConceptBean && toAdd instanceof ConceptBean) {
            ConceptBean concept = (ConceptBean)toRemove;
            if (((ReferenceSetImpl)this.getConceptList()).contains(concept)) {
                ((ReferenceSetImpl)this.getConceptList()).remove(concept);
                ((ReferenceSetImpl)this.getConceptList()).add((ConceptBean)toAdd);
            }
        } else if (toRemove instanceof ConceptGroupBean && toAdd instanceof ConceptGroupBean) {
            ConceptGroupBean conceptGroup = (ConceptGroupBean)toRemove;
            if (((ReferenceSetImpl)this.getConceptGroupList()).contains(conceptGroup)) {
                ((ReferenceSetImpl)this.getConceptGroupList()).remove(conceptGroup);
                ((ReferenceSetImpl)this.getConceptGroupList()).add((ConceptGroupBean)toAdd);
            }
        }
    }

    @Override
    protected void doRemoveReference(IdentifiableBean toRemove) {
        if (toRemove instanceof ConceptBean) {
            ConceptBean concept = (ConceptBean)toRemove;
            if (((ReferenceSetImpl)this.getConceptList()).contains(concept)) {
                ((ReferenceSetImpl)this.getConceptList()).remove(concept);
            }
        } else if (toRemove instanceof ConceptGroupBean) {
            ConceptGroupBean conceptGroup = (ConceptGroupBean)toRemove;
            if (((ReferenceSetImpl)this.getConceptGroupList()).contains(conceptGroup)) {
                ((ReferenceSetImpl)this.getConceptGroupList()).remove(conceptGroup);
            }
        }
    }

    @Override
    public DdiClass getDdiClass() {
        return DdiClass.ConceptGroup;
    }

    @Override
    public Class<? extends IdentifiableBean> getBeanType() {
        return ConceptGroupBean.class;
    }
}

