/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.beans.ddi.lifecycle.adt.impl;

import java.util.Collection;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.openmetadata.beans.IdentifiableBean;
import org.openmetadata.beans.exceptions.ResolverException;
import org.openmetadata.beans.reference.Resolver;

public class DynamicIdentifiableIterator<B extends IdentifiableBean>
implements Iterator<B> {
    private static Logger logger = Logger.getLogger(DynamicIdentifiableIterator.class);
    private final Iterator<String> urnCollIterator;
    private final Resolver resolver;
    private final Class<? extends B> beanClass;

    public DynamicIdentifiableIterator(Collection<String> urnColl, Class<? extends B> beanClass2, Resolver resolver) {
        this.urnCollIterator = urnColl.iterator();
        this.resolver = resolver;
        this.beanClass = beanClass2;
    }

    @Override
    public boolean hasNext() {
        return this.urnCollIterator.hasNext();
    }

    @Override
    public B next() {
        String urn = this.urnCollIterator.next();
        if (urn != null) {
            try {
                IdentifiableBean identifiableBean = this.resolver.resolve(this.beanClass, urn);
                return (B)identifiableBean;
            }
            catch (ResolverException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                return null;
            }
        }
        return null;
    }

    @Override
    public void remove() {
    }
}

