package org.openmetadata.beans.ddi.lifecycle.studyunit.impl;

import org.openmetadata.beans.ddi.lifecycle.adt.impl.InitializingSchemeItemList;
import org.openmetadata.beans.ddi.lifecycle.adt.impl.ReferenceSetImpl;
import org.openmetadata.beans.ddi.lifecycle.adt.impl.ResolvingSchemeItemListImpl;
import org.openmetadata.beans.ddi.lifecycle.archive.ArchiveBean;
import org.openmetadata.beans.ddi.lifecycle.conceptualcomponent.ConceptualComponentBean;
import org.openmetadata.beans.ddi.lifecycle.conceptualcomponent.UniverseBean;
import org.openmetadata.beans.ddi.lifecycle.datacollection.DataCollectionBean;
import org.openmetadata.beans.ddi.lifecycle.factory.DdiBeanFactory;
import org.openmetadata.beans.ddi.lifecycle.logicalproduct.LogicalProductBean;
import org.openmetadata.beans.ddi.lifecycle.physicaldataproduct.PhysicalDataProductBean;
import org.openmetadata.beans.ddi.lifecycle.physicalinstance.PhysicalInstanceBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.IdentifiableBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.OtherMaterialBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.AbstractMaintainableBeanImpl;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.CitationBeanImpl;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.IdentifiedStructuredStringValueBeanImpl;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.SeriesStatementBeanImpl;
import org.openmetadata.beans.ddi.lifecycle.studyunit.StudyUnitBean;
import org.openmetadata.beans.impl.MutableBeanInitializer;
import org.openmetadata.ddi_3_1.util.DdiClass;
import org.openmetadata.ddi_3_1.util.URN;

public class StudyUnitBeanImpl extends AbstractMaintainableBeanImpl implements
		StudyUnitBean {

	private CitationBeanImpl citationBean;	
	private IdentifiedStructuredStringValueBeanImpl studyAbstract;
	private IdentifiedStructuredStringValueBeanImpl studyPurpose;

	private ReferenceSetImpl<ArchiveBean> archives;
	private ReferenceSetImpl<ConceptualComponentBean> conceptualComponents;
	private ReferenceSetImpl<DataCollectionBean> dataCollections;
	
	private ReferenceSetImpl<LogicalProductBean> baseLogicalProducts;	
	private ReferenceSetImpl<PhysicalDataProductBean> physicalDataProducts;
	private ReferenceSetImpl<PhysicalInstanceBean> physicalInstances;
	
	private ReferenceSetImpl<UniverseBean> universes;
	
	private InitializingSchemeItemList<OtherMaterialBean> otherMaterials;
	
	private SeriesStatementBeanImpl seriesStatement;
	
	private String nature;
	
	public StudyUnitBeanImpl(Boolean isNewInstance, URN urn,
			MutableBeanInitializer beanInitializer,
			DdiBeanFactory factory) {
		super(isNewInstance, urn, beanInitializer, factory);
		
		citationBean = new CitationBeanImpl(beanInitializer, factory, this);
		studyAbstract = new IdentifiedStructuredStringValueBeanImpl(factory, this);
		studyPurpose = new IdentifiedStructuredStringValueBeanImpl(factory, this);
		
		conceptualComponents = new ReferenceSetImpl<ConceptualComponentBean>(ConceptualComponentBean.class, beanInitializer, factory, this);
		dataCollections = new ReferenceSetImpl<DataCollectionBean>(DataCollectionBean.class, beanInitializer, factory, this);
		archives = new ReferenceSetImpl<ArchiveBean>(ArchiveBean.class, beanInitializer, factory, this);
		baseLogicalProducts = new ReferenceSetImpl<LogicalProductBean>(LogicalProductBean.class, beanInitializer, factory, this);
		physicalInstances = new ReferenceSetImpl<PhysicalInstanceBean>(PhysicalInstanceBean.class, beanInitializer, factory, this);
		physicalDataProducts = new ReferenceSetImpl<PhysicalDataProductBean>(PhysicalDataProductBean.class, beanInitializer, factory, this);
		
		universes = new ReferenceSetImpl<UniverseBean>(UniverseBean.class, beanInitializer, factory, this);
		
		otherMaterials = new ResolvingSchemeItemListImpl<OtherMaterialBean>(this.getUrn(), OtherMaterialBean.class, beanInitializer, factory, this);
	
		seriesStatement = new SeriesStatementBeanImpl(factory, this);
	}
	
	public void initSetConceptualComponents(String[] urns){
		conceptualComponents.initReferenceUrns(urns);
	}
	public void initSetDataCollections(String[] urns){
		dataCollections.initReferenceUrns(urns);
	}
	public void initSetArchives(String[] urns){
		archives.initReferenceUrns(urns);
	}
	public void initSetLogicalProducts(String[] urns){
		this.baseLogicalProducts.initReferenceUrns(urns);
	}
	public void initSetPhysicalInstances(String[] urns){
		this.physicalInstances.initReferenceUrns(urns);
	}
	public void initSetPhysicalProducts(String[] urns){
		this.physicalDataProducts.initReferenceUrns(urns);
	}
	public void initSetOtherMaterials(String[] urns){
		this.otherMaterials.initSetIdentifiableUrns(urns);
	}
	public void initSetUniverse(String[] urns){
		this.universes.initReferenceUrns(urns);
	}
	
	public void initSetNature(String nature) {
		this.nature = nature;
	}
	
	@Override
	public CitationBeanImpl getCitation() {
		return citationBean;
	}

	@Override
	public IdentifiedStructuredStringValueBeanImpl getAbstract() {
		return studyAbstract;
	}

	@Override
	public IdentifiedStructuredStringValueBeanImpl getPurpose() {
		return studyPurpose;
	}

	@Override
	public ReferenceSetImpl<ConceptualComponentBean> getConceptualComponentList() {
		return conceptualComponents;
	}

	@Override
	public ReferenceSetImpl<LogicalProductBean> getLogicalProductList() {
		return baseLogicalProducts;
	}

	@Override
	public ReferenceSetImpl<DataCollectionBean> getDataCollectionList() {
		return dataCollections;
	}

	@Override
	public ReferenceSetImpl<ArchiveBean> getArchiveList() {
		return archives;
	}

	@Override
	public ReferenceSetImpl<PhysicalInstanceBean> getPhysicalInstanceList() {
		return physicalInstances;
	}
	
	@Override
	public ReferenceSetImpl<PhysicalDataProductBean> getPhysicalDataProductList(){
		return physicalDataProducts;
	}
	
	protected void setOtherMaterials(
			InitializingSchemeItemList<OtherMaterialBean> otherMaterials) {
		this.otherMaterials = otherMaterials;
	}
	
	@Override
	public InitializingSchemeItemList<OtherMaterialBean> getOtherMaterialList() {
		return otherMaterials;
	}	
	
	@Override
	public ReferenceSetImpl<UniverseBean> getUniverses() {
		return this.universes;
	}
	
	@Override
	public SeriesStatementBeanImpl getSeriesStatement() {
		return this.seriesStatement;
	}
	
	@Override
	public boolean isSetNature() {
		return this.nature != null && !this.nature.isEmpty();
	}
	
	@Override
	public void setNature(String nature) {
		this.nature = nature;
		this.change();
	}
	
	@Override
	public String getNature() {
		return (this.nature != null)? nature : "";
	}
	
	@Override
	public DdiClass getDdiClass() {
		return DdiClass.StudyUnit;
	}

	@Override
	public Class<? extends IdentifiableBean> getBeanType() {
		return StudyUnitBean.class;
	}

	@Override
	protected void doChangeReference(IdentifiableBean toRemove,
			IdentifiableBean toAdd) {		
		if(toRemove instanceof ArchiveBean && toAdd instanceof ArchiveBean){
			ArchiveBean ar = (ArchiveBean)toRemove;
			if(archives.contains(ar)){
				archives.remove(ar);
				archives.add((ArchiveBean)toAdd);
			}
		}
		else if(toRemove instanceof ConceptualComponentBean && toAdd instanceof ConceptualComponentBean){
			ConceptualComponentBean cc = (ConceptualComponentBean)toRemove;
			if(conceptualComponents.contains(cc)){
				conceptualComponents.remove(cc);
				conceptualComponents.add((ConceptualComponentBean)toAdd);
			}
		}
		else if(toRemove instanceof DataCollectionBean && toAdd instanceof DataCollectionBean){
			DataCollectionBean dc = (DataCollectionBean)toRemove;
			if(dataCollections.contains(dc)){
				dataCollections.remove(dc);
				dataCollections.add((DataCollectionBean)toAdd);
			}
		}
		else if(toRemove instanceof LogicalProductBean && toAdd instanceof LogicalProductBean){
			LogicalProductBean lp = (LogicalProductBean)toRemove;
			if(baseLogicalProducts.contains(lp)){
				baseLogicalProducts.remove(lp);
				baseLogicalProducts.add((LogicalProductBean)toAdd);
			}
		}	
		else if(toRemove instanceof PhysicalDataProductBean && toAdd instanceof PhysicalDataProductBean){
			PhysicalDataProductBean pd = (PhysicalDataProductBean)toRemove;
			if(physicalDataProducts.contains(pd)){
				physicalDataProducts.remove(pd);
				physicalDataProducts.add((PhysicalDataProductBean)toAdd);
			}
		}
		else if(toRemove instanceof PhysicalInstanceBean && toAdd instanceof PhysicalInstanceBean){
			PhysicalInstanceBean pi = (PhysicalInstanceBean)toRemove;
			if(physicalInstances.contains(pi)){
				physicalInstances.remove(pi);
				physicalInstances.add((PhysicalInstanceBean)toAdd);
			}
		}
	}
	
	@Override
	protected void doRemoveReference(IdentifiableBean toRemove) {
		if(toRemove instanceof ArchiveBean){
			ArchiveBean ar = (ArchiveBean)toRemove;
			if(archives.contains(ar)){
				archives.remove(ar);
			}
		}
		else if(toRemove instanceof ConceptualComponentBean){
			ConceptualComponentBean cc = (ConceptualComponentBean)toRemove;
			if(conceptualComponents.contains(cc)){
				conceptualComponents.remove(cc);
			}
		}
		else if(toRemove instanceof DataCollectionBean){
			DataCollectionBean dc = (DataCollectionBean)toRemove;
			if(dataCollections.contains(dc)){
				dataCollections.remove(dc);
			}
		}
		else if(toRemove instanceof LogicalProductBean){
			LogicalProductBean lp = (LogicalProductBean)toRemove;
			if(baseLogicalProducts.contains(lp)){
				baseLogicalProducts.remove(lp);
			}
		}	
		else if(toRemove instanceof PhysicalDataProductBean){
			PhysicalDataProductBean pd = (PhysicalDataProductBean)toRemove;
			if(physicalDataProducts.contains(pd)){
				physicalDataProducts.remove(pd);
			}
		}
		else if(toRemove instanceof PhysicalInstanceBean){
			PhysicalInstanceBean pi = (PhysicalInstanceBean)toRemove;
			if(physicalInstances.contains(pi)){
				physicalInstances.remove(pi);
			}
		}
	}
}
