package org.openmetadata.beans.ddi.lifecycle.studyunit;

import org.openmetadata.beans.ddi.lifecycle.adt.DdiBeanList;
import org.openmetadata.beans.ddi.lifecycle.adt.ReferenceSet;
import org.openmetadata.beans.ddi.lifecycle.adt.impl.ReferenceSetImpl;
import org.openmetadata.beans.ddi.lifecycle.archive.ArchiveBean;
import org.openmetadata.beans.ddi.lifecycle.conceptualcomponent.ConceptualComponentBean;
import org.openmetadata.beans.ddi.lifecycle.conceptualcomponent.UniverseBean;
import org.openmetadata.beans.ddi.lifecycle.datacollection.DataCollectionBean;
import org.openmetadata.beans.ddi.lifecycle.logicalproduct.LogicalProductBean;
import org.openmetadata.beans.ddi.lifecycle.physicaldataproduct.PhysicalDataProductBean;
import org.openmetadata.beans.ddi.lifecycle.physicalinstance.PhysicalInstanceBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.CitationBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.IdentifiedStructuredStringValueBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.MaintainableBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.OtherMaterialBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.SeriesStatementBean;
import org.openmetadata.ddi_3_1.util.DdiClass;

public interface StudyUnitBean extends MaintainableBean {
	
	final static DdiClass ddiClass = DdiClass.StudyUnit;

	CitationBean getCitation();

	IdentifiedStructuredStringValueBean getAbstract();

	IdentifiedStructuredStringValueBean getPurpose();

	ReferenceSet<ConceptualComponentBean> getConceptualComponentList();

	ReferenceSet<LogicalProductBean> getLogicalProductList();

	ReferenceSet<DataCollectionBean> getDataCollectionList();

	ReferenceSet<ArchiveBean> getArchiveList();

	ReferenceSet<PhysicalInstanceBean> getPhysicalInstanceList();

	ReferenceSet<PhysicalDataProductBean> getPhysicalDataProductList();

	DdiBeanList<OtherMaterialBean> getOtherMaterialList();
	
	ReferenceSetImpl<UniverseBean> getUniverses();
	
	SeriesStatementBean getSeriesStatement();
	
	void setNature(String nature);
	
	boolean isSetNature();
	
	String getNature();
}
