package org.openmetadata.beans.ddi.lifecycle.reusable.impl;

import org.openmetadata.beans.ddi.lifecycle.factory.DdiBeanFactory;
import org.openmetadata.beans.ddi.lifecycle.reusable.DdiPointFormatType;
import org.openmetadata.beans.ddi.lifecycle.reusable.SpatialCoordinateBean;
import org.apache.commons.lang3.StringUtils;
import org.openmetadata.beans.notification.ChangeListener;

public class SpatialCoordinateBeanImpl extends UnsettableDdiBeanImpl implements
		SpatialCoordinateBean {

	private static final DdiPointFormatType DEFAULT_COORD_TYPE = DdiPointFormatType.DECIMAL_DEGREE;

	private String coordinateValue;
	private DdiPointFormatType coordinateType;

	public SpatialCoordinateBeanImpl(DdiBeanFactory factory,
			ChangeListener listener) {
		super(factory, listener);
		coordinateType = null;
		coordinateValue = new String();
	}

	@Override
	public DdiPointFormatType getCoordinateType() {
		return (coordinateType != null) ? coordinateType : DEFAULT_COORD_TYPE;
	}

	@Override
	public void setCoordinateType(DdiPointFormatType value) {
		coordinateType = value;
		this.ddiBeanChanged();
	}

	@Override
	public String getCoordinateValue() {
		return StringUtils.defaultString(coordinateValue);
	}

	@Override
	public void setCoordinateValue(String value) {
		coordinateValue = value;
		this.ddiBeanChanged();
	}

	@Override
	protected boolean internalIsSet() {
		return !StringUtils.isEmpty(coordinateValue);
	}

}
