package org.openmetadata.beans.ddi.lifecycle.reusable.impl;

import org.openmetadata.beans.ddi.lifecycle.factory.DdiBeanFactory;
import org.openmetadata.beans.ddi.lifecycle.reusable.PointBean;
import org.openmetadata.beans.notification.ChangeListener;

public class PointBeanImpl extends UnsettableDdiBeanImpl implements PointBean {

	private SpatialCoordinateBeanImpl xCoordinate;
	private SpatialCoordinateBeanImpl yCoordinate;

	public PointBeanImpl(DdiBeanFactory factory, ChangeListener listener) {
		super(factory, listener);

		xCoordinate = new SpatialCoordinateBeanImpl(factory, this);
		yCoordinate = new SpatialCoordinateBeanImpl(factory, this);
	}

	@Override
	public SpatialCoordinateBeanImpl getXCoordinate() {
		return xCoordinate;
	}

	@Override
	public SpatialCoordinateBeanImpl getYCoordinate() {
		return yCoordinate;
	}

	@Override
	protected boolean internalIsSet() {
		return xCoordinate.isSet() && yCoordinate.isSet();
	}
}
