package org.openmetadata.beans.ddi.lifecycle.reusable.impl;

import org.openmetadata.beans.ddi.lifecycle.factory.DdiBeanFactory;
import org.openmetadata.beans.ddi.lifecycle.reusable.NumericRepresentationBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.NumericTypeCode;
import org.openmetadata.beans.ddi.lifecycle.utility.CompareUtil;
import org.openmetadata.beans.notification.ChangeListener;

public class NumericRepresentationBeanImpl extends RepresentationBeanImpl
		implements NumericRepresentationBean {

	private NumericTypeCode type = NumericTypeCode.INTEGER;

	private Integer scale;
	private Integer decimalPositions;

	private Double startValue;
	private Double endValue;
	private Double interval;

	public NumericRepresentationBeanImpl(NumericTypeCode type,
			DdiBeanFactory factory, ChangeListener listener) {
		super(factory, listener);
		this.type = type;
	}

	@Override
	public NumericTypeCode getType() {
		return type;
	}

	@Override
	public void setType(NumericTypeCode type) {
		if (this.type != type) {
			this.type = type;
			populate();
			this.ddiBeanChanged();
		}
	}

	@Override
	public boolean isSetScale() {
		return scale != null;
	}

	@Override
	public int getScale() {
		if (scale != null) {
			return scale;
		} else {
			return 0;
		}
	}

	@Override
	public void setScale(int value) {
		if (CompareUtil.areDifferentValues(this.scale, value)) {
			scale = value;
			populate();
			this.ddiBeanChanged();
		}
	}

	@Override
	public void unsetScale() {
		this.scale = null;
	}

	@Override
	public boolean isSetInterval() {
		return interval != null;
	}

	@Override
	public double getInterval() {
		if (interval != null) {
			return interval;
		} else {
			return 0;
		}
	}

	@Override
	public void setInterval(double value) {
		if (CompareUtil.areDifferentValues(this.interval, value)) {
			this.interval = value;
			populate();
			this.ddiBeanChanged();
		}
	}

	@Override
	public void unsetInterval() {
		this.interval = null;
	}

	@Override
	public boolean isSetStartValue() {
		return startValue != null;
	}

	@Override
	public double getStartValue() {
		if (startValue != null) {
			return startValue;
		} else {
			return 0;
		}
	}

	@Override
	public void setStartValue(double value) {
		if (CompareUtil.areDifferentValues(this.startValue, value)) {
			this.startValue = value;
			populate();
			this.ddiBeanChanged();
		}
	}

	@Override
	public void unsetStartValue() {
		this.startValue = null;
	}

	@Override
	public boolean isSetEndValue() {
		return endValue != null;
	}

	@Override
	public double getEndValue() {
		if (endValue != null) {
			return endValue;
		} else {
			return 0;
		}
	}

	@Override
	public void setEndValue(double endValue) {
		if (CompareUtil.areDifferentValues(this.endValue, endValue)) {
			this.endValue = endValue;
			populate();
			this.ddiBeanChanged();
		}
	}

	@Override
	public void unsetEndValue() {
		this.endValue = null;
	}

	@Override
	public boolean isSetDecimalPositions() {
		return decimalPositions != null;
	}

	@Override
	public int getDecimalPositions() {
		if (decimalPositions != null) {
			return decimalPositions;
		} else {
			return 0;
		}
	}

	@Override
	public void setDecimalPositions(int decimalPositions) {
		if (CompareUtil.areDifferentValues(this.decimalPositions,
				decimalPositions)) {
			this.decimalPositions = decimalPositions;
			populate();
			this.ddiBeanChanged();
		}
	}

	@Override
	public void unsetDecimalPositions() {
		this.decimalPositions = null;
	}

	@Override
	public boolean internalIsSet() {
		return true;
	}
}
