package org.openmetadata.beans.ddi.lifecycle.reusable.impl;

import org.openmetadata.beans.ddi.lifecycle.factory.DdiBeanFactory;
import org.openmetadata.beans.ddi.lifecycle.reusable.HistoricalDateBean;
import org.openmetadata.beans.ddi.lifecycle.utility.CompareUtil;
import org.apache.commons.lang3.StringUtils;
import org.openmetadata.beans.notification.ChangeListener;

public class HistoricalDateBeanImpl extends UnsettableDdiBeanImpl implements
		HistoricalDateBean {

	public HistoricalDateBeanImpl(DdiBeanFactory factory,
			ChangeListener listener) {
		super(factory, listener);
	}

	private String historicalDateFormat;
	private String strValue;

	@Override
	public String getStringValue() {
		return StringUtils.defaultString(strValue);
	}

	@Override
	public void setStringValue(String value) {
		if (CompareUtil.areDifferentValues(strValue, value)) {
			strValue = value;
			populate();
			this.ddiBeanChanged();
		}
	}

	@Override
	public String getHistoricalDateFormat() {
		return StringUtils.defaultString(historicalDateFormat);
	}

	@Override
	public void setHistoricalDateFormat(String format) {
		if (CompareUtil.areDifferentValues(this.historicalDateFormat, format)) {
			historicalDateFormat = format;
			populate();
			this.ddiBeanChanged();
		}
	}
	
	@Override
	protected boolean internalIsSet() {
		return !StringUtils.isEmpty(strValue);
	}

}
