package org.openmetadata.beans.ddi.lifecycle.reusable.impl;

import org.openmetadata.beans.ddi.lifecycle.factory.DdiBeanFactory;
import org.openmetadata.beans.ddi.lifecycle.reusable.InternationalStringValueBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.VersionableBean;
import org.openmetadata.ddi_3_1.util.URN;
import org.openmetadata.beans.ddi.lifecycle.utility.CompareUtil;
import org.apache.commons.lang3.StringUtils;
import org.openmetadata.beans.impl.MutableBeanInitializer;

public abstract class AbstractVersionableBeanImpl extends
		AbstractIdentifiableBeanImpl implements VersionableBean {

	private final String version;
	private Object versionDate;
	private String versionResposibility;
	private final InternationalStringValueBeanImpl versionRationale;

	public AbstractVersionableBeanImpl(Boolean newInstance, URN urn,
			MutableBeanInitializer beanInitializer,
			DdiBeanFactory beanFactory) {
		super(newInstance, urn, beanInitializer, beanFactory);
		version = urn.getVersion();
		versionRationale = new InternationalStringValueBeanImpl(beanFactory, this);
	}

	@Override
	public String getVersion() {
		return version;
	}

	@Override
	public boolean isSetVersionDate() {
		return versionDate != null;
	}

	@Override
	public Object getVersionDate() {
		return versionDate;
	}

	@Override
	public void setVersionDate(Object arg0) {
		versionDate = arg0;
		change();		
	}

	@Override
	public boolean isSetVersionResponsibility() {
		return !StringUtils.isEmpty(this.versionResposibility);
	}

	@Override
	public String getVersionResponsibility() {
		return StringUtils.defaultString(versionResposibility);
	}

	@Override
	public void setVersionResponsibility(String value) {
		if (CompareUtil.areDifferentValues(this.versionResposibility, value)) {
			versionResposibility = value;
			change();
		}
	}

	@Override
	public InternationalStringValueBean getVersionRationale() {
		return versionRationale;
	}

}