package org.openmetadata.beans.ddi.lifecycle.reusable.impl;

import java.util.Map;

import org.openmetadata.beans.ddi.lifecycle.factory.DdiBeanFactory;
import org.openmetadata.beans.ddi.lifecycle.reusable.StructuredStringBean;
import org.openmetadata.beans.ddi.lifecycle.utility.CompareUtil;
import org.apache.commons.lang3.StringUtils;
import org.openmetadata.beans.notification.ChangeListener;

public abstract class AbstractStructuredStringBeanImpl extends
		LanguageKeyedBeanImpl implements StructuredStringBean {

	private static final boolean DEFAULT_TRANSLATABLE = true;
	private static final boolean DEFAULT_TRANSLATED = false;

	private Boolean translatable;// default: true;
	private Boolean translated;// default: false;
	
	private String xhtmlContent = "";

	public AbstractStructuredStringBeanImpl(String lang, Map<Enum<?>, Object> keyMap,
			DdiBeanFactory factory, ChangeListener listener) {
		super(lang, keyMap, factory, listener);
	}

	@Override
	public String getXhtmlContent() {
		if (xhtmlContent != null) {
			return xhtmlContent;
		} else {
			return "";
		}
	}

	@Override
	public void setXhtmlContent(String value) {
		if (CompareUtil.areDifferentValues(this.xhtmlContent, value)) {
			this.xhtmlContent = value;
			populate();
			this.ddiBeanChanged();
		}
	}

	@Override
	public boolean isSetTranslated() {
		return translated != null;
	}

	@Override
	public boolean getTranslated() {
		if (translated != null) {
			return translated;
		} else {
			return DEFAULT_TRANSLATED;
		}
	}

	@Override
	public void setTranslated(boolean boo) {
		if (CompareUtil.areDifferentValues(translated, boo)) {
			translated = boo;
			populate();
			this.ddiBeanChanged();
		}
	}

	@Override
	public boolean isSetTranslatable() {
		return translatable != null;
	}

	@Override
	public boolean getTranslatable() {
		if (translatable != null) {
			return translatable;
		} else {
			return DEFAULT_TRANSLATABLE;
		}
	}

	@Override
	public void setTranslatable(boolean boo) {
		if (CompareUtil.areDifferentValues(translatable, boo)) {
			translatable = boo;
			populate();
			this.ddiBeanChanged();
		}
	}
	
	@Override
	protected boolean internalIsSet() {
		return !StringUtils.isEmpty(xhtmlContent);
	}

}
