package org.openmetadata.beans.ddi.lifecycle.physicaldataproduct.impl;

import org.openmetadata.beans.ddi.lifecycle.factory.DdiBeanFactory;
import org.openmetadata.beans.ddi.lifecycle.logicalproduct.VariableBean;
import org.openmetadata.beans.ddi.lifecycle.physicaldataproduct.DataItemBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.ReferenceBeanImpl;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.UnsettableDdiBeanImpl;
import org.openmetadata.ddi.util.exceptions.URNFormatException;
import org.openmetadata.beans.exceptions.ResolverException;
import org.openmetadata.beans.impl.MutableBeanInitializer;
import org.openmetadata.beans.notification.ChangeListener;

public class DataItemBeanImpl extends UnsettableDdiBeanImpl implements
		DataItemBean {

	private PhysicalLocationBeanImpl physicalLocation;
	private ReferenceBeanImpl<VariableBean> variableRef;

	public DataItemBeanImpl(MutableBeanInitializer beanInitializer, DdiBeanFactory factory, ChangeListener listener) {
		super(factory, listener);
		physicalLocation = new PhysicalLocationBeanImpl(beanInitializer, factory, listener);
		variableRef = new ReferenceBeanImpl<VariableBean>(VariableBean.class,
				factory, listener);
	}

	public ReferenceBeanImpl<VariableBean> getVariableReference() {
		return variableRef;
	}

	@Override
	public void setVariable(VariableBean variable)  {
		variableRef.setReferenceTo(variable);
	}

	@Override
	public VariableBean getVariable() {
		try {
			return variableRef.getReferredObject();
		} catch (ResolverException e) {
			throw new RuntimeException(e);
		}
	}

	@Override
	public String getVariableUrn() {
		return variableRef.getUrn();
	}

	public void setVariableUrn(String variableUrn) throws URNFormatException {
		variableRef.setReferenceUrn(variableUrn);
	}

	@Override
	public PhysicalLocationBeanImpl getPhysicalLocation() {
		return physicalLocation;
	}

	@Override
	protected boolean internalIsSet() {
		return variableRef.isSet();
	}
}
