package org.openmetadata.beans.ddi.lifecycle.notification;

import java.util.HashSet;
import java.util.Set;

import org.openmetadata.beans.notification.ChangeEvent;

public class ReferenceAddedEvent implements ReferenceChangeEvent {

	private Set<String> addedReferences = new HashSet<String>();

	public ReferenceAddedEvent(String added) {
		if (added != null) {
			addedReferences.add(added);
		}
	}

	public ReferenceAddedEvent(Set<String> added) {
		addedReferences.addAll(added);
	}

	@Override
	public ChangeEvent[] getInitiatingEvents() {
		return new ChangeEvent[0];
	}

	@Override
	public Type getType() {
		return Type.UPDATE;
	}

	@Override
	public Set<String> getAddedReferences() {
		return addedReferences;
	}

	@Override
	public Set<String> getRemovedReferences() {
		return new HashSet<String>();
	}

}
