package org.openmetadata.beans.ddi.lifecycle.logicalproduct.impl;

import org.openmetadata.beans.ddi.lifecycle.factory.DdiBeanFactory;
import org.openmetadata.beans.ddi.lifecycle.logicalproduct.VariableBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.ReferenceBeanImpl;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.UnsettableDdiBeanImpl;
import org.openmetadata.ddi.util.exceptions.URNFormatException;
import org.openmetadata.beans.exceptions.ResolverException;
import org.openmetadata.beans.notification.ChangeListener;

public class VariableSpecificationReferenceBeanImpl extends
		UnsettableDdiBeanImpl {

	ReferenceBeanImpl<VariableBean> varRef;

	public VariableSpecificationReferenceBeanImpl(DdiBeanFactory factory,
			ChangeListener listener) {
		super(factory, listener);
		varRef = new ReferenceBeanImpl<VariableBean>(VariableBean.class,
				factory, this);
	}

	public void initSetVariableUrn(String varUrn) throws URNFormatException {
		varRef.setReferenceUrn(varUrn);
	}

	public String getVariableUrn() {
		return varRef.getUrn();
	}

	public boolean isSetVariable() {
		return varRef.isSet();
	}

	public VariableBean getVariable() {
		try {
			return varRef.getReferredObject();
		} catch (ResolverException e) {
			throw new RuntimeException(e);
		}
	}

	public void setVariable(VariableBean variable)  {
		varRef.setReferenceTo(variable);
	}
	
	@Override
	protected boolean internalIsSet() {
		return varRef.isSet();
	}
}
