package org.openmetadata.beans.ddi.lifecycle.logicalproduct.impl;

import java.util.HashSet;
import java.util.Set;

import org.openmetadata.ddi_3_1.util.DdiClass;
import org.openmetadata.beans.ddi.lifecycle.adt.impl.ReferenceSetImpl;
import org.openmetadata.beans.ddi.lifecycle.conceptualcomponent.ConceptBean;
import org.openmetadata.beans.ddi.lifecycle.conceptualcomponent.UniverseBean;
import org.openmetadata.beans.ddi.lifecycle.datacollection.QuestionItemBean;
import org.openmetadata.beans.ddi.lifecycle.datacollection.SequenceBean;
import org.openmetadata.beans.ddi.lifecycle.factory.DdiBeanFactory;
import org.openmetadata.beans.ddi.lifecycle.logicalproduct.CodeSchemeBean;
import org.openmetadata.beans.ddi.lifecycle.logicalproduct.VariableBean;
import org.openmetadata.beans.ddi.lifecycle.logicalproduct.VariableGroupBean;
import org.openmetadata.beans.ddi.lifecycle.logicalproduct.VariableSchemeBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.IdentifiableBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.AbstractSchemeItemBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.CodeRepresentationBeanImpl;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.CodeValueBeanImpl;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.ReferenceBeanImpl;
import org.openmetadata.beans.ddi.lifecycle.types.VariableRepresentationType;
import org.openmetadata.ddi.util.exceptions.URNFormatException;
import org.openmetadata.ddi_3_1.util.URN;
import org.openmetadata.beans.ddi.lifecycle.utility.CompareUtil;
import org.openmetadata.beans.exceptions.ResolverException;
import org.openmetadata.beans.impl.MutableBeanInitializer;

public class VariableBeanImpl extends
		AbstractSchemeItemBean<VariableSchemeBean> implements VariableBean {

	private static boolean IS_TEMPORAL_DEFAULT = false;
	private static boolean IS_GEOGRAPHIC_DEFAULT = false;
	private static boolean IS_WEIGHT_DEFAULT = false;

	private Boolean isTemporal;
	private Boolean isGeographic;
	private Boolean isWeight;

	private String responseUnit;

	private final ReferenceBeanImpl<ConceptBean> conceptRef;
	private final ReferenceBeanImpl<QuestionItemBean> questionItemRef;
	private final ReferenceBeanImpl<SequenceBean> sequenceRef;
	private final ReferenceSetImpl<UniverseBean> universeRefs;

	private final CodeValueBeanImpl analysisUnit;
	private final VariableRepresentationBeanImpl representation;

	private boolean validating;

	public VariableBeanImpl(Boolean isNewInstance, URN urn,
			MutableBeanInitializer beanInitializer,
			DdiBeanFactory factory) {
		super(isNewInstance, urn, beanInitializer, factory);
		conceptRef = new ReferenceBeanImpl<ConceptBean>(ConceptBean.class,
				factory, this);
		universeRefs = new ReferenceSetImpl<UniverseBean>(UniverseBean.class,
				beanInitializer,factory, this);
		questionItemRef = new ReferenceBeanImpl<QuestionItemBean>(QuestionItemBean.class,
				factory, this);
		sequenceRef = new ReferenceBeanImpl<SequenceBean>(SequenceBean.class,
				factory, this);
		responseUnit = "";
		analysisUnit = new CodeValueBeanImpl(factory, this);
		representation = new VariableRepresentationBeanImpl(this, factory, this);
	}

	public void initSetUniverses(String[] urns) {
		universeRefs.initReferenceUrns(urns);
	}
	
	public void initSetSequence(String sequenceUrn){
		sequenceRef.setReferenceUrn(sequenceUrn);
	}

	public void initSetQuestionItem(String questionItemUrn)
			throws URNFormatException {
		questionItemRef.setReferenceUrn(questionItemUrn);
	}

	public void initSetConceptUrn(String urn) throws URNFormatException {
		this.conceptRef.setReferenceUrn(urn);
	}

	public void setSequenceUrn(String urn) throws URNFormatException {
		this.sequenceRef.setReferenceUrn(urn);
	}

	@Override
	public boolean getIsTemporal() {
		if (isSetIsTemporal())
			return isTemporal;
		else
			return IS_TEMPORAL_DEFAULT;
	}

	@Override
	public void setIsTemporal(boolean boo) {
		if (CompareUtil.areDifferentValues(this.isTemporal, boo)) {
			this.isTemporal = boo;
			this.change();
		}
	}

	@Override
	public boolean isSetIsTemporal() {
		return isTemporal != null;
	}

	@Override
	public boolean getIsGeographic() {
		if (isSetIsGeographic())
			return isGeographic;
		else
			return IS_GEOGRAPHIC_DEFAULT;
	}

	@Override
	public void setIsGeographic(boolean isGeographic) {
		if (CompareUtil.areDifferentValues(this.isGeographic, isGeographic)) {
			this.isGeographic = isGeographic;
			this.change();
		}
	}

	@Override
	public boolean isSetIsGeographic() {
		return isGeographic != null;
	}

	@Override
	public boolean getIsWeight() {
		if (isSetIsWeight())
			return isWeight;
		else
			return IS_WEIGHT_DEFAULT;
	}

	@Override
	public void setIsWeight(boolean boo) {
		if (CompareUtil.areDifferentValues(this.isWeight, boo)) {
			this.isWeight = boo;
			this.change();
		}
	}

	@Override
	public boolean isSetIsWeight() {
		return isWeight != null;
	}

	@Override
	public VariableGroupBean[] getReferringVariableGroups() {
		Set<VariableGroupBean> referringGroups = new HashSet<VariableGroupBean>();
		for (IdentifiableBean referrer : this.getReferrers()) {
			if (referrer instanceof VariableGroupBean) {
				VariableGroupBean varGroup = (VariableGroupBean) referrer;
				referringGroups.add(varGroup);
			}
		}
		return referringGroups.toArray(new VariableGroupBean[0]);
	}

	@Override
	public ReferenceSetImpl<UniverseBean> getUniverseList() {
		return this.universeRefs;
	}

	@Override
	public boolean isSetConcept() {
		return this.conceptRef.isSet();
	}

	@Override
	public void setConcept(ConceptBean concept)  {
		this.conceptRef.setReferenceTo(concept);
	}

	@Override
	public void unsetConcept() {
		this.conceptRef.unset();
	}

	@Override
	public String getConceptUrn() {
		return this.conceptRef.getUrn();
	}

	@Override
	public ConceptBean getConcept() {
		try {
			return this.conceptRef.getReferredObject();
		} catch (ResolverException e) {
			throw new RuntimeException(e);
		}
	}
	
	public ReferenceBeanImpl<QuestionItemBean> getQuestionItemReference(){
		return this.questionItemRef;
	}
	
	@Override
	public boolean isSetQuestionItem(){
		return this.questionItemRef.isSet();
	}
	
	@Override
	public void setQuestionItem(QuestionItemBean question){
		if(question!=null){
			this.questionItemRef.setReferenceTo(question);
			this.sequenceRef.unset();
		}else{
			this.questionItemRef.unset();
		}
	}
	
	@Override
	public void unsetQuestionItem(){
		if(this.questionItemRef.isSet()){
			this.questionItemRef.unset();
		}
	}
	
	@Override
	public QuestionItemBean getQuestionItem(){
		try {
			return this.questionItemRef.getReferredObject();
		} catch (ResolverException e) {
			throw new RuntimeException(e);
		}
	}

	public ReferenceBeanImpl<SequenceBean> getSequenceReference() {
		return sequenceRef;
	}

	@Override
	public boolean isSetSequence() {
		return this.sequenceRef.isSet();
	}

	@Override
	public void setSequence(SequenceBean sequence)  {
		if (sequence != null) {
			this.sequenceRef.setReferenceTo(sequence);
			this.questionItemRef.unset();
		} else {
			this.sequenceRef.unset();
		}
	}

	@Override
	public void unsetSequence() {
		this.sequenceRef.unset();
	}

	@Override
	public String getSequenceUrn() {
		return sequenceRef.getUrn();
	}

	@Override
	public SequenceBean getSequence() {
		try {
			return this.sequenceRef.getReferredObject();
		} catch (ResolverException e) {
			throw new RuntimeException(e);
		}
	}

	@Override
	public String getResponseUnit() {
		if (responseUnit != null) {
			return responseUnit;
		} else {
			return "";
		}
	}

	@Override
	public void setResponseUnit(String value) {
		if (CompareUtil.areDifferentValues(this.responseUnit, value)) {
			responseUnit = value;
			this.change();
		}
	}

	@Override
	public boolean isSetResponseUnit() {
		return (responseUnit != null && responseUnit.isEmpty() == false);
	}

	@Override
	public CodeValueBeanImpl getAnalysisUnit() {
		return analysisUnit;
	}

	@Override
	public boolean isSetAnalysisUnit() {
		return analysisUnit.isSet();
	}

	@Override
	public VariableRepresentationBeanImpl getRepresentation() {
		return representation;
	}

	@Override
	public boolean isSetRepresentation() {
		return representation.isSet();
	}

	@Override
	protected void doChangeReference(IdentifiableBean current,
			IdentifiableBean another)  {

		if (current instanceof ConceptBean && another instanceof ConceptBean) {
			ConceptBean currConcept = (ConceptBean) current;
			if (this.conceptRef.isReferring(currConcept)) {
				ConceptBean anotherConcept = (ConceptBean) another;
				this.conceptRef.setReferenceTo(anotherConcept);
			}
		} else if (current instanceof UniverseBean
				&& another instanceof UniverseBean) {
			UniverseBean currUniverse = (UniverseBean) current;
			if (this.universeRefs.contains(currUniverse)) {
				this.universeRefs.remove(currUniverse.getUrn());

				UniverseBean anotherUniverse = (UniverseBean) another;
				this.universeRefs.add(anotherUniverse);
			}
		} else if(current instanceof QuestionItemBean 
				&& another instanceof QuestionItemBean){
			QuestionItemBean currentQuestion = (QuestionItemBean) current;
			if (this.questionItemRef.isReferring(currentQuestion)){
				QuestionItemBean anotherQuestion = (QuestionItemBean) another;
				this.questionItemRef.setReferenceTo(anotherQuestion);
			}			
		} else if (current instanceof SequenceBean
				&& another instanceof SequenceBean) {
			SequenceBean currSeq = (SequenceBean) current;
			if (this.getSequenceReference().isReferring(currSeq)) {
				SequenceBean anotherSeq = (SequenceBean) another;
				this.getSequenceReference().setReferenceTo(anotherSeq);
			}
		} else if (current instanceof CodeSchemeBean
				&& another instanceof CodeSchemeBean) {
			if (this.isSetRepresentation()) {
				VariableRepresentationType repType = this.getRepresentation()
						.getRepresentationType();
				if (repType == VariableRepresentationType.Code) {
					CodeRepresentationBeanImpl codeRep = (CodeRepresentationBeanImpl) this
							.getRepresentation().getCodeRepresentation();
					CodeSchemeBean anotherCodeScheme = (CodeSchemeBean) another;
					codeRep.getCodeSchemeReference().setReferenceTo(
							anotherCodeScheme);
				}
			}
		}
	}

	@Override
	protected void doRemoveReference(IdentifiableBean toRemove) {
		if (toRemove instanceof ConceptBean) {
			ConceptBean currConcept = (ConceptBean) toRemove;
			if (this.conceptRef.isReferring(currConcept)) {
				this.conceptRef.unset();
			}
		} else if (toRemove instanceof UniverseBean) {
			UniverseBean currUniverse = (UniverseBean) toRemove;
			if (this.universeRefs.contains(currUniverse)) {
				this.universeRefs.remove(currUniverse.getUrn());
			}			
		} else if(toRemove instanceof QuestionItemBean){
			QuestionItemBean question = (QuestionItemBean) toRemove;
			if (this.questionItemRef.isReferring(question)){
				this.questionItemRef.unset();
			}			
		} else if (toRemove instanceof SequenceBean) {
			SequenceBean currSeq = (SequenceBean) toRemove;
			if (this.sequenceRef.isReferring(currSeq)) {
				this.sequenceRef.unset();
			}
		} else if (toRemove instanceof CodeSchemeBean) {
			CodeSchemeBean codeScheme = (CodeSchemeBean) toRemove;
			if (this.isSetRepresentation()) {
				VariableRepresentationType repType = this.getRepresentation()
						.getRepresentationType();
				if (repType == VariableRepresentationType.Code) {
					CodeRepresentationBeanImpl codeRep = (CodeRepresentationBeanImpl) this
							.getRepresentation().getCodeRepresentation();
					if (codeScheme.getUrn().equals(codeRep.getCodeSchemeUrn())) {
						codeRep.unset();
						this.getRepresentation().unset();						
					}
				}
			}
		}
	}

	@Override
	public DdiClass getDdiClass() {
		return DdiClass.Variable;
	}

	@Override
	public Class<? extends IdentifiableBean> getBeanType() {
		return VariableBean.class;
	}
}
