package org.openmetadata.beans.ddi.lifecycle.logicalproduct.impl;

import org.openmetadata.beans.ddi.lifecycle.factory.DdiBeanFactory;
import org.openmetadata.beans.ddi.lifecycle.logicalproduct.CaseIdentificationBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.UnsettableDdiBeanImpl;
import org.openmetadata.ddi.util.exceptions.URNFormatException;
import org.openmetadata.beans.notification.ChangeListener;

public class CaseIdentificationBeanImpl extends UnsettableDdiBeanImpl implements
		CaseIdentificationBean {

	private VariableSpecificationReferenceSetImpl vsRefSet;

	public CaseIdentificationBeanImpl(DdiBeanFactory factory,
			ChangeListener listener) {
		super(factory, listener);
		vsRefSet = new VariableSpecificationReferenceSetImpl(factory, listener);
	}

	public void initSetVariableUrns(String[] variableUrns)
			throws URNFormatException {
		vsRefSet.initSetVariableUrns(variableUrns);
	}

	@Override
	public VariableSpecificationReferenceSetImpl getVariableSpecificationList() {
		return vsRefSet;
	}

	@Override
	protected boolean internalIsSet() {
		return vsRefSet.isSet();
	}
}
