package org.openmetadata.beans.ddi.lifecycle.group.impl;

import org.openmetadata.beans.ddi.lifecycle.adt.impl.InitializingSchemeItemList;
import org.openmetadata.beans.ddi.lifecycle.adt.impl.ResolvingSchemeItemListImpl;
import org.openmetadata.beans.ddi.lifecycle.adt.impl.ReferenceSetImpl;
import org.openmetadata.beans.ddi.lifecycle.archive.ArchiveBean;
import org.openmetadata.beans.ddi.lifecycle.conceptualcomponent.ConceptualComponentBean;
import org.openmetadata.beans.ddi.lifecycle.conceptualcomponent.UniverseBean;
import org.openmetadata.beans.ddi.lifecycle.datacollection.DataCollectionBean;
import org.openmetadata.beans.ddi.lifecycle.factory.DdiBeanFactory;
import org.openmetadata.beans.ddi.lifecycle.group.DataSetGroupCode;
import org.openmetadata.beans.ddi.lifecycle.group.GeographyGroupCode;
import org.openmetadata.beans.ddi.lifecycle.group.InstrumentGroupCode;
import org.openmetadata.beans.ddi.lifecycle.group.LanguageGroupCode;
import org.openmetadata.beans.ddi.lifecycle.group.PanelGroupCode;
import org.openmetadata.beans.ddi.lifecycle.group.SubGroupBean;
import org.openmetadata.beans.ddi.lifecycle.group.TimeGroupCode;
import org.openmetadata.beans.ddi.lifecycle.logicalproduct.LogicalProductBean;
import org.openmetadata.beans.ddi.lifecycle.physicaldataproduct.PhysicalDataProductBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.IdentifiableBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.NoteBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.OtherMaterialBean;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.AbstractVersionableBeanImpl;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.CitationBeanImpl;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.CoverageBeanImpl;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.IdentifiedStructuredStringValueBeanImpl;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.ReferenceBeanImpl;
import org.openmetadata.beans.ddi.lifecycle.reusable.impl.SeriesStatementBeanImpl;
import org.openmetadata.beans.ddi.lifecycle.studyunit.StudyUnitBean;
import org.apache.commons.lang3.StringUtils;
import org.openmetadata.beans.exceptions.ResolverException;
import org.openmetadata.beans.impl.MutableBeanInitializer;
import org.openmetadata.ddi_3_1.util.DdiClass;
import org.openmetadata.ddi_3_1.util.URN;

public class SubGroupBeanImpl extends AbstractVersionableBeanImpl implements SubGroupBean{

	private static final boolean DEFAULT_GROUP_INHERITS = true;
	
	private TimeGroupCode timeGroupCode;
	private InstrumentGroupCode instrumentGroupCode;
	private PanelGroupCode panelGroupCode;
	private GeographyGroupCode geographyGroupCode;
	private DataSetGroupCode dataSetGroupCode;
	private LanguageGroupCode langGroupCode;
	private String userDefinedGroupProperty;
	private String userDefinedGroupPropertyValue;
	private Boolean groupInherits;

	private CitationBeanImpl citation;
	private IdentifiedStructuredStringValueBeanImpl abstractValueBean;
	private IdentifiedStructuredStringValueBeanImpl purposeValueBean;
	private SeriesStatementBeanImpl seriesStatement;
	private CoverageBeanImpl coverage;
	private ReferenceBeanImpl<UniverseBean> universeRef;
	private InitializingSchemeItemList<OtherMaterialBean> otherMatList;
	private ReferenceBeanImpl<ArchiveBean> archiveRef;
	private InitializingSchemeItemList<NoteBean> noteList;
	private ReferenceSetImpl<ConceptualComponentBean> conceptualComponentList;
	private ReferenceSetImpl<DataCollectionBean> dataCollList;
	private ReferenceSetImpl<LogicalProductBean> logicalProductList;
	private ReferenceSetImpl<PhysicalDataProductBean> pdpList;
	private ReferenceSetImpl<StudyUnitBean> studyUnitList;
	private InitializingSchemeItemList<SubGroupBean> subGroupList;

	public SubGroupBeanImpl(Boolean isNewInstance, URN urn,
			MutableBeanInitializer beanInitializer,
			DdiBeanFactory beanFactory) {
		super(isNewInstance, urn, beanInitializer, beanFactory);
		
		abstractValueBean = new IdentifiedStructuredStringValueBeanImpl(beanFactory, this);
		purposeValueBean = new IdentifiedStructuredStringValueBeanImpl(beanFactory, this);
		seriesStatement = new SeriesStatementBeanImpl(beanFactory, this);
		coverage = new CoverageBeanImpl(beanInitializer, beanFactory, this);		
		universeRef = new ReferenceBeanImpl<UniverseBean>(UniverseBean.class, beanFactory, this);
		otherMatList = new ResolvingSchemeItemListImpl<OtherMaterialBean>(urn.getParent().toString(), OtherMaterialBean.class, beanInitializer, beanFactory, this);
		archiveRef = new ReferenceBeanImpl<ArchiveBean>(ArchiveBean.class, beanFactory, this);
		noteList = new ResolvingSchemeItemListImpl<NoteBean>(urn.getParent().toString(), NoteBean.class, beanInitializer, beanFactory, this);
		conceptualComponentList = new ReferenceSetImpl<ConceptualComponentBean>(ConceptualComponentBean.class, beanInitializer, beanFactory, this);
		dataCollList = new ReferenceSetImpl<DataCollectionBean>(DataCollectionBean.class, beanInitializer, beanFactory, this);
		
		logicalProductList = new ReferenceSetImpl<LogicalProductBean>(LogicalProductBean.class, beanInitializer, beanFactory, this);
		pdpList = new ReferenceSetImpl<PhysicalDataProductBean>(PhysicalDataProductBean.class, beanInitializer, beanFactory, this);
		studyUnitList = new ReferenceSetImpl<StudyUnitBean>(StudyUnitBean.class, beanInitializer, beanFactory, this);
		
		subGroupList = new ResolvingSchemeItemListImpl<SubGroupBean>(urn.getParent().toString(), SubGroupBean.class, beanInitializer, beanFactory, this);
	}
	
	public void initSetUniverseUrn(String urn){
		universeRef.setReferenceUrn(urn);
	}
	
	public void initSetOtherMaterialUrns(String[] urns){
		otherMatList.initSetIdentifiableUrns(urns);
	}
	
	public void initSetArchiveUrn(String urn){
		archiveRef.setReferenceUrn(urn);
	}
	
	public void initSetNoteUrns(String[] urns){
		noteList.initSetIdentifiableUrns(urns);
	}
	
	public void initSetConceptualComponentUrns(String[] urns){
		conceptualComponentList.initReferenceUrns(urns);
	}
	
	public void initSetDataCollectionUrns(String[] urns){
		dataCollList.initReferenceUrns(urns);
	}
	
	public void initSetLogicalProductUrns(String[] urns){
		logicalProductList.initReferenceUrns(urns);
	}
	
	public void initSetPhysicalDataProductUrns(String[] urns){
		pdpList.initReferenceUrns(urns);
	}
	
	public void initSetStudyUnitUrns(String[] urns){
		studyUnitList.initReferenceUrns(urns);
	}
	
	public void initSetSubGroupUrns(String[] urns){
		subGroupList.initSetIdentifiableUrns(urns);
	}

	@Override
	public TimeGroupCode getTime() {
		return timeGroupCode;
	}

	@Override
	public void setTime(TimeGroupCode code) {
		timeGroupCode = code;
	}
	
	@Override
	public InstrumentGroupCode getInstrument() {
		return instrumentGroupCode;
	}

	@Override
	public void setInstrument(InstrumentGroupCode code) {
		instrumentGroupCode = code;
	}

	@Override
	public PanelGroupCode getPanel() {
		return panelGroupCode;
	}

	@Override
	public void setPanel(PanelGroupCode code) {
		panelGroupCode = code;
	}

	@Override
	public GeographyGroupCode getGeography() {
		return geographyGroupCode;
	}

	@Override
	public void setGeography(GeographyGroupCode code) {
		geographyGroupCode = code;
	}

	@Override
	public DataSetGroupCode getDataSet() {
		return dataSetGroupCode;
	}

	@Override
	public void setDataSetGroupCode(DataSetGroupCode code) {
		dataSetGroupCode = code;
	}

	@Override
	public LanguageGroupCode getLanguage() {
		return langGroupCode;
	}

	@Override
	public void setLanguageGroupCode(LanguageGroupCode code) {
		langGroupCode = code;
	}

	@Override
	public boolean isSetUserDefinedGroupProperty() {
		return !StringUtils.isEmpty(userDefinedGroupProperty);
	}

	@Override
	public String getUserDefinedGroupProperty() {
		return StringUtils.defaultString(userDefinedGroupProperty);
	}

	@Override
	public void setUserDefinedGroupProperty(String value) {
		userDefinedGroupProperty = value;
	}

	@Override
	public void unsetUserDefinedGroupProperty() {
		userDefinedGroupProperty = null;
	}

	@Override
	public boolean isSetUserDefinedGroupPropertyValue() {
		return !StringUtils.isEmpty(userDefinedGroupPropertyValue);
	}

	@Override
	public String getUserDefinedGroupPropertyValue() {
		return StringUtils.defaultString(userDefinedGroupPropertyValue);
	}

	@Override
	public void setUserDefinedGroupPropertyValue(String value) {
		this.userDefinedGroupPropertyValue = value;		
	}

	@Override
	public void unsetUserDefinedGroupPropertyValue() {
		this.userDefinedGroupPropertyValue = null;
	}

	@Override
	public boolean isSetGroupInherits() {
		return groupInherits != null;
	}

	@Override
	public boolean getGroupInherits() {
		if(groupInherits != null){
			return groupInherits;
		}else{
			return DEFAULT_GROUP_INHERITS;
		}
	}

	@Override
	public void setGroupInherits(boolean boo) {
		groupInherits = boo;
	}

	@Override
	public void unsetGroupInherits() {
		groupInherits = null;
	}
	
	@Override
	public CitationBeanImpl getCitation() {
		if (citation == null) {
			citation = new CitationBeanImpl(this.getBeanInitializer(), this.getBeanFactory(), this);
		}
		return citation;
	}

	@Override
	public IdentifiedStructuredStringValueBeanImpl getAbstract() {
		return abstractValueBean;
	}

	@Override
	public IdentifiedStructuredStringValueBeanImpl getPurpose() {
		return purposeValueBean;
	}

	@Override
	public SeriesStatementBeanImpl getSeriesStatement() {
		return seriesStatement;
	}

	@Override
	public CoverageBeanImpl getCoverage() {
		return coverage;
	}

	@Override
	public boolean isSetUniverse() {
		return universeRef.isSet();
	}

	@Override
	public UniverseBean getUniverse() {
		try {
			return universeRef.getReferredObject();
		} catch (ResolverException e) {
			throw new RuntimeException(e);
		}
	}
	
	@Override
	public String getUniverseUrn() {
		if(universeRef.isSet()){
			return universeRef.getUrn();
		}else{
			return "";
		}		
	}

	@Override
	public void setUniverse(UniverseBean universe) {
		universeRef.setReferenceTo(universe);
	}

	@Override
	public void unsetUniverse() {
		universeRef.unset();
	}

	@Override
	public InitializingSchemeItemList<OtherMaterialBean> getOtherMaterialList() {
		return otherMatList;
	}

	@Override
	public boolean isSetArchive() {
		return archiveRef.isSet();
	}

	@Override
	public ArchiveBean getArchive() {
		try {
			return archiveRef.getReferredObject();
		} catch (ResolverException e) {
			throw new RuntimeException(e);
		}
	}
	
	@Override
	public String getArchiveUrn() {
		if(archiveRef.isSet()){
			return archiveRef.getUrn();
		}else{
			return "";
		}
	}

	@Override
	public void setArchive(ArchiveBean archive) {
		archiveRef.setReferenceTo(archive);
	}

	@Override
	public void unsetArchive() {
		archiveRef.unset();
	}

	@Override
	public InitializingSchemeItemList<NoteBean> getNoteList() {
		return noteList;
	}

	@Override
	public ReferenceSetImpl<ConceptualComponentBean> getConceptualComponentList() {
		return conceptualComponentList;
	}

	@Override
	public ReferenceSetImpl<DataCollectionBean> getDataCollectionList() {
		return dataCollList;
	}

	@Override
	public ReferenceSetImpl<LogicalProductBean> getLogicalProductList() {
		return logicalProductList;
	}

	@Override
	public ReferenceSetImpl<PhysicalDataProductBean> getPhysicalDataProductList() {
		return pdpList;
	}

	@Override
	public ReferenceSetImpl<StudyUnitBean> getStudyUnitList() {
		return studyUnitList;
	}
	
	@Override
	public InitializingSchemeItemList<SubGroupBean> getSubGroupList() {
		return subGroupList;
	}

	@Override
	public DdiClass getDdiClass() {
		return DdiClass.SubGroup;
	}

	@Override
	public Class<? extends IdentifiableBean> getBeanType() {
		return SubGroupBean.class;
	}

	@Override
	protected void doChangeReference(IdentifiableBean toRemove,
			IdentifiableBean toAdd) {
		// TODO implement reference changes		
	}

	@Override
	protected void doRemoveReference(IdentifiableBean toRemove) {
		// TODO implement reference changes		
	}

	

	
}
